package com.ejianc.business.assist.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.rmat.bean.ContractEntity;
import com.ejianc.business.assist.rmat.bean.ContractRelieveEntity;
import com.ejianc.business.assist.rmat.enums.BillPushStatusEnum;
import com.ejianc.business.assist.rmat.enums.ContractStatusEnum;
import com.ejianc.business.assist.rmat.enums.SignatureStatusEnum;
import com.ejianc.business.assist.rmat.service.IContractRelieveService;
import com.ejianc.business.assist.rmat.service.IContractService;
import com.ejianc.business.assist.rmat.vo.ContractVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service("contractRelieve") 
public class ContractRelieveBpmServiceImpl implements ICommonBusinessService {

	private final Logger logger = LoggerFactory.getLogger(this.getClass());
	
	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private SessionManager sessionManager;

	@Autowired
	private IContractRelieveService service;

	@Autowired
	private IContractService contractService;

	@Autowired
	private IExecutionApi executionApi;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		ContractRelieveEntity entity = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		entity.setCommitDate(new Date());
		entity.setCommitUserCode(userContext.getUserCode());
		entity.setCommitUserName(userContext.getUserName());
		
		if (entity != null) {
			// 已签章
			if (entity.getDraftType() == 2) {
				entity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
				
				entity.setEffectiveDate(new Date());
				service.saveOrUpdate(entity, false);

				QueryParam param = new QueryParam();
				param.getParams().put("id", new Parameter(QueryParam.EQ, entity.getContractId()));
				List<ContractEntity> contractEntities = contractService.queryList(param, false);
				if (ListUtil.isNotEmpty(contractEntities)) {
					ContractEntity contractEntity = contractEntities.get(0);
					contractEntity.setContractStatus(ContractStatusEnum.已解除.getCode());
					logger.info("======终审审核完回调,已签章======,{}", JSONObject.toJSONString(contractEntity));
					contractService.saveOrUpdate(contractEntity, false);

					// 合同推送合同池，更新解除状态
					boolean pushResult = contractService.pushContract(BeanMapper.map(contractEntity, ContractVO.class));
					if(pushResult) {
						contractEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
					} else {
						contractEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
					}


					// 推送目标成本
//					CommonResponse<String> response = executionApi.aggPush(service.targetCost(entity));
//					logger.info("推送目标成本入参：" + JSONObject.toJSONString(service.targetCost(entity)));
//					if (!response.isSuccess()){
//						logger.error("推送目标成本失败: , {}", response.getMsg());
//						throw new BusinessException(response.getMsg());
//					}

					contractService.saveOrUpdate(contractEntity, false);
				}
			} 
		}
		
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());

		if (!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能撤回！");
		}

		ContractRelieveEntity entity = service.selectById(billId);
		if (!(SignatureStatusEnum.未签章.getCode().equals(entity.getSignatureStatus()))){
			return CommonResponse.error("当前单据已有签章流程，不能撤回！");
		}
		
		return CommonResponse.success();
	}

}
