package com.ejianc.business.assist.store.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 材料退库表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_assiststore_pick_return")
public class PickReturnEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="org_id")
    private Long orgId; // 所属项目部id
    @TableField(value="org_name")
    private String orgName; // 所属项目部名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="bill_code")
    private String billCode; // 退库单号
    @TableField(value="instore_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date instoreDate; // 退库日期
    @TableField(value="store_id")
    private Long storeId; // 仓库
    @TableField(value="store_name")
    private String storeName; // 仓库名称
    @TableField(value="contract_id")
    private Long contractId; // 分包合同id
    @TableField(value="contract_name")
    private String contractName; // 分包合同名称
    @TableField(value="sub_org_id")
    private Long subOrgId; // 分包单位id
    @TableField(value="sub_org_name")
    private String subOrgName; // 分包单位名称
    @TableField(value="manager_name")
    private String managerName; // 负责人姓名
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="department_id")
    private Long departmentId; // 部门id
    @TableField(value="department_name")
    private String departmentName; // 部门名称
    @TableField(value="project_id")
    private Long projectId; // 所属项目
    @TableField(value="project_name")
    private String projectName; // 所属项目名称
    @TableField(value="project_code")
    private String projectCode; // 所属项目编码
    @TableField(value="instore_type")
    private String instoreType; // 入库类型
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="material_names")
    private String materialNames; // 材料分类名称
    @TableField(value="total_tax_mny")
    private BigDecimal totalTaxMny; // 退库金额含税
    @TableField(value="total_mny")
    private BigDecimal totalMny; // 退库金额不含税
    @TableField(value="pick_return_name")
    private String pickReturnName; // 退料人
    @TableField(value="pick_return_reason")
    private String pickReturnReason; // 退库原因
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="pickReturnDetailService",pidName = "instoreId")
    private List<PickReturnDetailEntity> pickReturnDetailList = new ArrayList<>(); // 材料退库明细表
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getInstoreDate() {
        return instoreDate;
    }

    public void setInstoreDate(Date instoreDate) {
        this.instoreDate = instoreDate;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getSubOrgId() {
        return subOrgId;
    }

    public void setSubOrgId(Long subOrgId) {
        this.subOrgId = subOrgId;
    }
    public String getSubOrgName() {
        return subOrgName;
    }

    public void setSubOrgName(String subOrgName) {
        this.subOrgName = subOrgName;
    }
    public String getManagerName() {
        return managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getInstoreType() {
        return instoreType;
    }

    public void setInstoreType(String instoreType) {
        this.instoreType = instoreType;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getMaterialNames() {
        return materialNames;
    }

    public void setMaterialNames(String materialNames) {
        this.materialNames = materialNames;
    }
    public BigDecimal getTotalTaxMny() {
        return totalTaxMny;
    }

    public void setTotalTaxMny(BigDecimal totalTaxMny) {
        this.totalTaxMny = totalTaxMny;
    }
    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }
    public String getPickReturnName() {
        return pickReturnName;
    }

    public void setPickReturnName(String pickReturnName) {
        this.pickReturnName = pickReturnName;
    }
    public String getPickReturnReason() {
        return pickReturnReason;
    }

    public void setPickReturnReason(String pickReturnReason) {
        this.pickReturnReason = pickReturnReason;
    }
    

    public List<PickReturnDetailEntity> getPickReturnDetailList() {
        return pickReturnDetailList;
    }

    public void setPickReturnDetailList(List<PickReturnDetailEntity> pickReturnDetailList) {
        this.pickReturnDetailList = pickReturnDetailList;
    }
}
