/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.material.bean.MaterialContractDetailEntity;
import com.ejianc.business.assist.material.service.IMaterialContractDetailService;
import com.ejianc.business.assist.material.vo.MaterialContractDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"materialContractDetail"})
public class MaterialContractDetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IMaterialContractDetailService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialContractDetailVO> saveOrUpdate(@RequestBody MaterialContractDetailVO saveOrUpdateVO) {
        BillCodeParam billCodeParam;
        CommonResponse billCode;
        MaterialContractDetailEntity entity = (MaterialContractDetailEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MaterialContractDetailEntity.class));
        if (!(entity.getId() != null && entity.getId() != 0L || (billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess())) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.service.saveOrUpdate((Object)entity, false);
        MaterialContractDetailVO vo = (MaterialContractDetailVO)BeanMapper.map((Object)((Object)entity), MaterialContractDetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialContractDetailVO> queryDetail(Long id) {
        MaterialContractDetailEntity entity = (MaterialContractDetailEntity)((Object)this.service.selectById(id));
        MaterialContractDetailVO vo = (MaterialContractDetailVO)BeanMapper.map((Object)((Object)entity), MaterialContractDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialContractDetailVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialContractDetailVO materialContractDetailVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/refMaterialContractDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialContractDetailVO>> refMaterialContractDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        Map conditionMap;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("materialName");
        param.getFuzzyFields().add("materialTypeName");
        param.getFuzzyFields().add("materialCode");
        param.getFuzzyFields().add("spec");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("contractId")) {
            Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
            param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        }
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialContractDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

