/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.store.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.assist.store.bean.StoreCheckDetailEntity;
import com.ejianc.business.assist.store.bean.StoreCheckEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.consts.StoreCommonConsts;
import com.ejianc.business.assist.store.controller.FlowController;
import com.ejianc.business.assist.store.mapper.StoreCheckDetailMapper;
import com.ejianc.business.assist.store.mapper.StoreCheckMapper;
import com.ejianc.business.assist.store.service.IStoreCheckService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.util.StoreManageUtil;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.business.assist.store.vo.UseMaterialPriceVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="storeCheckService")
public class StoreCheckServiceImpl
extends BaseServiceImpl<StoreCheckMapper, StoreCheckEntity>
implements IStoreCheckService {
    @Autowired
    private StoreCheckDetailMapper storeCheckDetailMapper;
    @Autowired
    private StoreCheckMapper storeCheckMapper;
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private FlowController flowHandle;

    @Override
    public CommonResponse saveCheckStore(StoreCheckEntity entity) {
        Long projectId = entity.getProjectId();
        Long storeId = entity.getStoreId();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"project_id", (Object)projectId);
        wrapper.eq((Object)"store_id", (Object)storeId);
        wrapper.eq((Object)"bill_state", (Object)StoreCommonConsts.ZERO);
        List list = super.list((Wrapper)wrapper);
        Integer checkCount = list.size();
        if (null == entity.getId() ? checkCount > 0 : checkCount > 1) {
            return CommonResponse.error((String)"\u8be5\u4ed3\u5e93\u5df2\u4e0b\u5b58\u5728\u81ea\u7531\u6001\u76d8\u70b9\u5355\uff01");
        }
        if (null != entity.getId()) {
            this.storeCheckDetailMapper.delByCheckId(entity.getId());
        }
        super.saveOrUpdate((Object)entity, false);
        List<StoreCheckDetailEntity> checkSubList = entity.getCheckSubList();
        ArrayList subList = new ArrayList();
        checkSubList.forEach(item -> {
            if (item.getInventory() != null && item.getInventory().compareTo(BigDecimal.ZERO) < 0) {
                subList.add(item);
            }
        });
        HashMap checkMap = new HashMap();
        String materialIds = "[";
        for (StoreCheckDetailEntity item2 : subList) {
            materialIds = materialIds + item2.getMaterialId() + ",";
        }
        materialIds = materialIds.substring(0, materialIds.length() - 1) + "]";
        String condition = "{projectId:" + entity.getProjectId() + ",storeId:" + entity.getStoreId() + ",materialIds:" + materialIds + "}";
        if (subList.size() > 0) {
            CommonResponse<IPage<FlowVO>> iPageCommonResponse = this.flowHandle.refInstoreFlowData(1, 1000, condition, "", "");
            if (!iPageCommonResponse.isSuccess() || null == iPageCommonResponse.getData()) {
                return CommonResponse.error((String)"\u83b7\u53d6\u6700\u65b0\u6570\u91cf\u5931\u8d25\uff01");
            }
            List records = ((IPage)iPageCommonResponse.getData()).getRecords();
            records.forEach(item -> checkMap.put(item.getMaterialId(), item));
            for (StoreCheckDetailEntity item3 : subList) {
                FlowVO flowVO = (FlowVO)checkMap.get(item3.getMaterialId());
                if (null == flowVO) {
                    return CommonResponse.error((String)("\u3010" + item3.getMaterialName() + "_" + item3.getSpec() + "\u3011\u5e93\u5b58\u53ef\u7528\u6570\u91cf\u4e0d\u8db3\uff0c\u65e0\u6cd5\u5f62\u6210\u76d8\u4e8f\u51fa\u5e93\u5355\uff1b  \u4e0d\u53ef\u4fdd\u5b58"));
                }
                if (item3.getInventory().add(flowVO.getSurplusNum()).compareTo(BigDecimal.ZERO) >= 0) continue;
                return CommonResponse.error((String)("\u3010" + item3.getMaterialName() + "_" + item3.getSpec() + "\u3011\u5e93\u5b58\u53ef\u7528\u6570\u91cf\u4e0d\u8db3\uff0c\u65e0\u6cd5\u5f62\u6210\u76d8\u4e8f\u51fa\u5e93\u5355\uff1b  \u4e0d\u53ef\u4fdd\u5b58"));
            }
        }
        if (subList.size() > 0) {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u76d8\u4e8f\u51fa\u5e93);
            ArrayList<FlowVO> flowVOS = new ArrayList<FlowVO>();
            subList.forEach(item -> {
                if (item.getInventory() == null) {
                    item.setInventory(BigDecimal.ZERO);
                }
                FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u76d8\u4e8f\u51fa\u5e93, (Integer)0);
                flowVO.setStoreId(entity.getStoreId());
                flowVO.setStoreName(entity.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgCode(entity.getParentOrgCode());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setMaterialCategoryId(item.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(item.getMaterialCategoryName());
                flowVO.setMaterialId(item.getMaterialId());
                flowVO.setMaterialName(item.getMaterialName());
                flowVO.setMaterialSpec(item.getSpec());
                flowVO.setNum(BigDecimal.ZERO.subtract(item.getInventory()));
                if (null != item.getPrice()) {
                    flowVO.setTaxPrice(item.getPrice());
                    flowVO.setTaxMny(item.getPrice().multiply(flowVO.getNum()));
                }
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(item.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getCheckDate());
                flowVOS.add(flowVO);
            });
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setFlowVOList(flowVOS);
            CommonResponse<StoreManageVO> commonResponse = this.storeManageService.surplusMaterialPrice(storeManageVO);
            if (!commonResponse.isSuccess()) {
                return commonResponse;
            }
            List useMaterialPriceVOList = new ArrayList();
            if (null != commonResponse.getData()) {
                useMaterialPriceVOList = ((StoreManageVO)commonResponse.getData()).getUseMaterialPriceVOList();
            }
            Map<Long, UseMaterialPriceVO> priceMap = useMaterialPriceVOList.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k));
            flowVOS.forEach(item -> {
                item.setTaxPrice(((UseMaterialPriceVO)priceMap.get(item.getMaterialId())).getTaxPrice());
                item.setTaxMny(((UseMaterialPriceVO)priceMap.get(item.getMaterialId())).getTaxMny());
            });
            storeManageVO.setFlowVOList(flowVOS);
            CommonResponse<StoreManageVO> storeManageVOCommonResponse = this.storeManageService.inOutStore(storeManageVO);
            if (!storeManageVOCommonResponse.isSuccess()) {
                return storeManageVOCommonResponse;
            }
        }
        return CommonResponse.success((Object)((Object)entity));
    }

    @Override
    public CommonResponse myRemoveByIds(List<Long> ids) {
        CommonResponse commonResponse = this.checkRollback(ids);
        if (!commonResponse.isSuccess()) {
            return commonResponse;
        }
        super.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse checkRollback(List<Long> ids) {
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> SourceIds = new ArrayList<Long>();
        for (Long item : ids) {
            StoreCheckEntity entity = (StoreCheckEntity)((Object)super.selectById((Serializable)item));
            List<StoreCheckDetailEntity> checkSubList = entity.getCheckSubList();
            Boolean checkFalg = false;
            for (StoreCheckDetailEntity t : checkSubList) {
                if (t.getInventory().compareTo(BigDecimal.ZERO) >= 0) continue;
                checkFalg = true;
                break;
            }
            if (!checkFalg.booleanValue()) continue;
            SourceIds.clear();
            SourceIds.add(item);
            storeManageVO.setSourceId(item);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u76d8\u4e8f\u51fa\u5e93);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            CommonResponse<StoreManageVO> rollbackCommonResponse = this.storeManageService.inOutStoreRollback(storeManageVO);
            if (rollbackCommonResponse.isSuccess()) continue;
            return rollbackCommonResponse;
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse checkOut(List<Long> ids) {
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> SourceIds = new ArrayList<Long>();
        for (Long item : ids) {
            StoreCheckEntity entity = (StoreCheckEntity)((Object)super.selectById((Serializable)item));
            SourceIds.clear();
            SourceIds.add(item);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u76d8\u4e8f\u51fa\u5e93);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            storeManageVO.setSourceId(item);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            CommonResponse<StoreManageVO> rollbackCommonResponse = this.storeManageService.inOutStore(storeManageVO);
            if (rollbackCommonResponse.isSuccess()) continue;
            return rollbackCommonResponse;
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse checkByDate(Long storeId, String checkDate) {
        List<StoreCheckEntity> checkEntities = this.storeCheckMapper.queryByDate(storeId, checkDate);
        if (checkEntities.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u65f6\u95f4\u70b9\u540e\u5df2\u53d1\u751f\u4ed3\u5e93\u76d8\u70b9\u5355");
        }
        return CommonResponse.success();
    }
}

