package com.ejianc.business.assist.store.service.impl;

import com.ejianc.business.assist.store.bean.ReturnGoodsEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.service.IStoreCheckService;
import com.ejianc.business.assist.store.service.IReturnGoodsService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.vo.ReturnGoodsVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;

@Service("returnGoods") 
public class ReturnGoodsBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IReturnGoodsService returnGoodsService;

	@Autowired
	private StoreManageService storeManageService;
	@Autowired
	private IStoreCheckService checkService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ReturnGoodsEntity entity = returnGoodsService.selectById(billId);
		ReturnGoodsVO returnGoodsVO = BeanMapper.map(entity, ReturnGoodsVO.class);
		if(returnGoodsVO!=null && returnGoodsVO.getReturnGoodsDetailList().size()>0){
			StoreManageVO storeManageVO = returnGoodsVO.getStoreManageVO(returnGoodsVO);
			storeManageService.inOutStore(storeManageVO);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 1、退货单是否被物资合同结算引用，如引用，不可弃审；
		// 2、处置时间之后有盘点单时，不可弃审
		ReturnGoodsEntity entity = returnGoodsService.selectById(billId);
		if(entity != null){
			CommonResponse commonResponse = checkService.checkByDate(entity.getStoreId(), DateFormatUtil.formatDate("yyyy-MM-dd", entity.getOutDate()));
 			return commonResponse;
		}else{
			return CommonResponse.error("单据异常，弃审失败");
		}

	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		ReturnGoodsEntity entity = returnGoodsService.selectById(billId);
		if(entity!=null && entity.getReturnGoodsDetailList().size()>0){
			StoreManageVO storeManageVO = new StoreManageVO();
			storeManageVO.setSourceId(entity.getId());
			storeManageVO.setStoreId(entity.getStoreId());
			storeManageVO.setOutEffectiveON(true);
			storeManageVO.setInOutTypeEnum(InOutTypeEnum.材料退货);
			ArrayList<Long> longs = new ArrayList<>();
			longs.add(entity.getId());
			storeManageVO.setSourceIdsForRollBack(longs);
			storeManageService.inOutStoreRollback(storeManageVO);
		}

		return CommonResponse.success();
	}

}
