package com.ejianc.business.assist.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.assist.rmat.bean.*;
import com.ejianc.business.assist.rmat.enums.*;
import com.ejianc.business.assist.rmat.mapper.ChangeMapper;
import com.ejianc.business.assist.rmat.service.*;
import com.ejianc.business.assist.rmat.utils.MaterialConstant;
import com.ejianc.business.assist.rmat.vo.*;
import com.ejianc.business.assist.rmat.vo.record.ChangeRecordVO;
import com.ejianc.business.common.CommonConstant;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 周转材租赁合同变更表
 * 
 * @author generator
 * 
 */
@Service("changeService")
public class ChangeServiceImpl extends BaseServiceImpl<ChangeMapper, ChangeEntity> implements IChangeService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "ASSIST_RMAT_RENT_IN_CONTRACT_CNAHGE";//此处需要根据实际修改
    
    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IBillCodeApi billCodeApi;
    
    @Autowired
    private IContractService contractService;

    @Autowired
    private IRecordService recordService;
    
    @Autowired
    private IChangeService changeService;

    @Autowired
    private IContractDailyRentService dailyRentService;

    @Autowired
    private IContractMonthRentService monthRentService;

    @Autowired
    private IContractNumRentService numRentService;

    @Autowired
    private IContractRepairService repairService;

    @Autowired
    private IContractScrapService scrapService;

    @Autowired
    private IContractOtherService otherService;

    @Autowired
    private IContractPaymentService paymentService;

    @Autowired
    private IContractClauseService clauseService;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private IExecutionApi executionApi;

    @Autowired
    private IContractPoolApi contractPoolApi;
    
    @Override
    public ChangeVO saveOrUpdate(ChangeVO saveOrUpdateVO) {
        // 获取主合同当前合同文件Id
        ContractEntity contractEntity = contractService.selectById(saveOrUpdateVO.getMainContractId());
        // 将主合同原合同文件从attachId中删除，否改文件会被该写到变更合同中
        if(ListUtil.isNotEmpty(saveOrUpdateVO.getAttachIds()) &&  null != contractEntity.getContractFileId()) {
            saveOrUpdateVO.getAttachIds().remove(contractEntity.getContractFileId());
        }
        
        ChangeEntity entity = BeanMapper.map(saveOrUpdateVO, ChangeEntity.class);

        // 变更合同只能存在一条未生效的
        // 查询语句，主合同id一致，且变更id不同，单据状态不为已通过或已提交的，或签章状态不为已签章的
        LambdaQueryWrapper<ChangeEntity> lambdachange = Wrappers.<ChangeEntity>lambdaQuery();
        lambdachange.eq(ChangeEntity::getContractId, saveOrUpdateVO.getMainContractId());
        if(saveOrUpdateVO.getId() != null) {
            lambdachange.ne(ChangeEntity::getId,saveOrUpdateVO.getId());
        }
        lambdachange.and(l -> l.ne(ChangeEntity::getSignatureStatus, SignatureStatusEnum.已签章.getCode()).or(c -> c.notIn(ChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        int num = super.count(lambdachange);
        if(num > 0){
            throw new BusinessException("该合同已存在未生效的变更单!");
        }
        
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

            entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
            entity.setPerformanceStatus(PerformanceStatusEnum.未签订.getCode());
            
            if (null == entity.getChangeVersion() || entity.getChangeVersion() == 0) {
                // 第一次变更
                entity.setChangeVersion(1);
            } else {
                // 版本号+1
                entity.setChangeVersion(entity.getChangeVersion() + 1);
            }
            
            // 清空字表id、复制sourceBid
            clearDetailList(entity);

            // 删除旧的目标成本
            deleteOldCost(BeanMapper.map(contractEntity, ChangeVO.class));
        }

        contractService.validateContract(saveOrUpdateVO.getMainContractId(), MaterialConstant.变更单, saveOrUpdateVO.getId(), MaterialConstant.保存);
        
        entity.setContractId(entity.getMainContractId());
        entity.setBeforeContractName(entity.getMainContractName());
        entity.setChangeContractName(entity.getContractName());
        this.saveOrUpdate(entity, false);
        
        // 回写主合同信息
        LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(ContractEntity::getChangeId, entity.getId());
        updateWrapper.set(ContractEntity::getChangingMny, entity.getContractMny());
        updateWrapper.set(ContractEntity::getChangingTaxMny, entity.getContractTaxMny());
        updateWrapper.set(ContractEntity::getChangeCode, entity.getBillCode());
        updateWrapper.set(ContractEntity::getChangeVersion, entity.getChangeVersion());
        updateWrapper.set(ContractEntity::getChangeStatus, ChangeStatusEnum.变更中.getCode());
        updateWrapper.set(ContractEntity::getChangeDate, entity.getChangeDate());
        updateWrapper.set(ContractEntity::getChangeDraftType, entity.getChangeDraftType());
        updateWrapper.set(ContractEntity::getChangeContractSignatureStatus, entity.getSignatureStatus());
        updateWrapper.set(ContractEntity::getChangeFileId, entity.getChangeFileId());
        updateWrapper.set(ContractEntity::getChangeContractName, entity.getContractName());
        updateWrapper.eq(ContractEntity::getId, entity.getMainContractId());
        contractService.update(updateWrapper);

        ChangeVO vo = BeanMapper.map(this.selectById(entity.getId()), ChangeVO.class);
        
        
        // 推送新目标成本
//        CommonResponse<String> response = executionApi.aggPush(targetCost(vo));
//        if (!response.isSuccess()){
//            throw new BusinessException("目标成本推送失败！");
//        }

        return BeanMapper.map(this.selectById(entity.getId()), ChangeVO.class);
    }

    @Override
    public ChangeRecordVO queryChangeRecord(Long id) {
        ContractEntity entity = contractService.selectById(id);

        ChangeRecordVO vo = new ChangeRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractMny(entity.getContractMny());
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setBaseMny(entity.getBaseMny());
        vo.setBaseTaxMny(entity.getBaseTaxMny());
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());

        // 查询变更记录
        LambdaQueryWrapper<ChangeEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ChangeEntity::getContractId, id);
        wrapper.orderByDesc(ChangeEntity::getSignDate);
        List<ChangeEntity> changeList = super.list(wrapper);

        vo.setTotalChangeMny(ComputeUtil.safeSub(vo.getContractMny(), vo.getBaseMny()));
        vo.setTotalChangeTaxMny(ComputeUtil.safeSub(vo.getContractTaxMny(), vo.getBaseTaxMny()));
        vo.setTotalChangeNum(changeList.size());
        vo.setTotalChangeRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(vo.getTotalChangeMny(), vo.getBaseTaxMny()), new BigDecimal("100")));
        
        vo.setDetailList(BeanMapper.mapList(changeList, ChangeVO.class));

        return vo;
    }

    @Override
    public ChangeVO queryContractRecordDetail(Long id) {
        LambdaQueryWrapper<RecordEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(RecordEntity::getChangeId, id);
        List<RecordEntity> list = recordService.list(wrapper);
        if (ListUtil.isNotEmpty(list)) {
            return BeanMapper.map(recordService.selectById(list.get(0).getId()), ChangeVO.class);
        }else {
            return new ChangeVO();
        }
    }

    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState) {
        // 表更表
        ChangeEntity changeEntity = this.selectById(changeBillId);
        // 原合同数据
        ContractVO contractVO = contractService.queryDetail(changeEntity.getContractId());
        
        // 回写记录表数据
        writeBackRecord(changeEntity, contractVO);

        // 回写原合同数据
        writeBackContract(changeEntity, contractVO);

        
        // 设置变更合同生效状态
        changeEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
        changeEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
        changeEntity.setCommitDate(new Date());
        
        // 变更单更新
        changeService.saveOrUpdate(changeEntity);
        
        return CommonResponse.success("变更单生效，回写合同成功！");
        
    }

    @Override
    public void deleteByIds(List<ChangeVO> vos) {
        for (ChangeVO vo : vos) {
            ChangeEntity changeEntity = super.selectById(vo.getId());

            // 删除当前变更单的目标成本
            deleteOldCost(BeanMapper.map(changeEntity, ChangeVO.class));
            
            // 查询变更记录
            LambdaQueryWrapper<ChangeEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(ChangeEntity::getContractId, changeEntity.getContractId());
            wrapper.ne(BaseEntity::getId, vo.getId());
            wrapper.orderByDesc(BaseEntity::getCreateTime);
            List<ChangeEntity> list = this.list(wrapper);

            ChangeVO changeVO = new ChangeVO();
            if (ListUtil.isNotEmpty(list)) {
                // 推送上个变更单
                changeVO = BeanMapper.map(list.get(0), ChangeVO.class);
            }else {
                // 推送原合同
                ContractEntity contractEntity = contractService.selectById(changeEntity.getContractId());
                changeVO = BeanMapper.map(contractEntity, ChangeVO.class);
            }

            // 推送上个版本的目标成本
            targetCost(changeVO);
            
            LambdaUpdateWrapper<ContractEntity> lambdaUpdate = new LambdaUpdateWrapper<>();
            if (changeEntity.getChangeVersion() == 1) {
                lambdaUpdate.set(ContractEntity::getChangeStatus, 1);
            } else {
                lambdaUpdate.set(ContractEntity::getChangeStatus, 3);
            }
            lambdaUpdate.eq(ContractEntity::getId, changeEntity.getContractId());
            contractService.update(lambdaUpdate);

            super.removeById(vo, false);
        }
    }

    @Override
    public Map<String, Object> queryChangeCompare(Long id) {
        /*
            当前变更合同如果未提交，则和主合同对比
            如果提交，则和合同记录表对比
         */
        ChangeEntity changeEntity = this.selectById(id);
        ChangeCompareVO changeCompareVO = BeanMapper.map(changeEntity, ChangeCompareVO.class);
        ContractEntity contractEntity = contractService.selectById(changeEntity.getContractId());

        ChangeCompareVO beforeChangeVO = new ChangeCompareVO();
        boolean flag = false;
        if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(changeEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(changeEntity.getBillState())) {
            // 若变更单已审批通过，则查询最新的合同记录
            LambdaQueryWrapper<RecordEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(RecordEntity::getChangeId, id);
            wrapper.eq(RecordEntity::getContractId, changeEntity.getContractId());
            wrapper.orderByDesc(BaseEntity::getCreateTime);

            List<RecordEntity> recordEntityList = recordService.list(wrapper);
            if (ListUtil.isNotEmpty(recordEntityList)) {
                beforeChangeVO = BeanMapper.map(recordService.selectById(recordEntityList.get(0).getId()), ChangeCompareVO.class);
            }
        }else {
            beforeChangeVO = BeanMapper.map(contractEntity, ChangeCompareVO.class);
            flag = true;
        }

        Map<String, Object> returnMap = new HashMap<>();
        if (changeCompareVO != null && beforeChangeVO != null) {
            // 日租
            if (ListUtil.isNotEmpty(changeCompareVO.getDailyRentList())) {
                List<ChangeDailyRentVO> dailyRentList = beforeChangeVO.getDailyRentList();
                Map<Long, ChangeDailyRentVO> beforeDailyMap = new HashMap<>();
                if (flag) {
                    beforeDailyMap = dailyRentList.stream().collect(Collectors.toMap(ChangeDailyRentVO::getId, Function.identity()));
                }else {
                    beforeDailyMap = dailyRentList.stream().collect(Collectors.toMap(ChangeDailyRentVO::getSourceBid, Function.identity()));
                }

                for (ChangeDailyRentVO vo : changeCompareVO.getDailyRentList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        ChangeDailyRentVO beforeVO = beforeDailyMap.get(vo.getSourceBid());
                        vo.setBcCount(beforeVO.getCount());
                        vo.setBcUnitTaxPrice(beforeVO.getUnitTaxPrice());
                        vo.setBcStopUnitTaxPrice(beforeVO.getStopUnitTaxPrice());
                        vo.setBcLoseUnitTaxPrice(beforeVO.getLoseUnitTaxPrice());
                        vo.setBcTaxRate(beforeVO.getTaxRate());
                        vo.setBcStartDate(beforeVO.getStartDate());
                        vo.setBcEndDate(beforeVO.getEndDate());
                        vo.setBcMemo(beforeVO.getMemo());
                        vo.setBcUnitName(beforeVO.getUnitName());
                        vo.setBcRentDays(beforeVO.getRentDays());
                        vo.setBcRentTaxMny(beforeVO.getRentTaxMny());
                    }
                }

                changeCompareVO.setDailyRentList(changeCompareVO.getDailyRentList().stream().filter(daily -> StringUtils.isNotEmpty(daily.getChangeType())).collect(Collectors.toList()));
            }

            // 月租
            if (ListUtil.isNotEmpty(changeCompareVO.getMonthRentList())) {
                List<ChangeMonthRentVO> monthRentList = beforeChangeVO.getMonthRentList();
                Map<Long, ChangeMonthRentVO> beforeMonthMap = new HashMap<>();
                if (flag) {
                    beforeMonthMap = monthRentList.stream().collect(Collectors.toMap(ChangeMonthRentVO::getId, Function.identity()));
                }else {
                    beforeMonthMap = monthRentList.stream().collect(Collectors.toMap(ChangeMonthRentVO::getSourceBid, Function.identity()));
                }

                for (ChangeMonthRentVO vo : changeCompareVO.getMonthRentList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        ChangeMonthRentVO beforeVO = beforeMonthMap.get(vo.getSourceBid());
                        vo.setBcCount(beforeVO.getCount());
                        vo.setBcUnitTaxPrice(beforeVO.getUnitTaxPrice());
                        vo.setBcLackMonthDayUnitTaxPrice(beforeVO.getLackMonthDayUnitTaxPrice());
                        vo.setBcStopUnitTaxPrice(beforeVO.getStopUnitTaxPrice());
                        vo.setBcLoseUnitTaxPrice(beforeVO.getLoseUnitTaxPrice());
                        vo.setBcTaxRate(beforeVO.getTaxRate());
                        vo.setBcStartDate(beforeVO.getStartDate());
                        vo.setBcEndDate(beforeVO.getEndDate());
                        vo.setBcMemo(beforeVO.getMemo());
                        vo.setBcUnitName(beforeVO.getUnitName());
                        vo.setBcRentMonths(beforeVO.getRentMonths());
                        vo.setBcRentDays(beforeVO.getRentDays());
                        vo.setBcRentTaxMny(beforeVO.getRentTaxMny());
                    }
                }

                changeCompareVO.setMonthRentList(changeCompareVO.getMonthRentList().stream().filter(month -> StringUtils.isNotEmpty(month.getChangeType())).collect(Collectors.toList()));
            }

            // 工程量租
            if (ListUtil.isNotEmpty(changeCompareVO.getNumRentList())) {
                List<ChangeNumRentVO> numRentList = beforeChangeVO.getNumRentList();
                Map<Long, ChangeNumRentVO> beforeNumMap = new HashMap<>();
                if (flag) {
                    beforeNumMap = numRentList.stream().collect(Collectors.toMap(ChangeNumRentVO::getId, Function.identity()));
                }else {
                    beforeNumMap = numRentList.stream().collect(Collectors.toMap(ChangeNumRentVO::getSourceBid, Function.identity()));
                }

                for (ChangeNumRentVO vo : changeCompareVO.getNumRentList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        ChangeNumRentVO beforeVO = beforeNumMap.get(vo.getSourceBid());
                        vo.setBcCount(beforeVO.getCount());
                        vo.setBcUnitTaxPrice(beforeVO.getUnitTaxPrice());
                        vo.setBcLoseUnitTaxPrice(beforeVO.getLoseUnitTaxPrice());
                        vo.setBcTaxRate(beforeVO.getTaxRate());
                        vo.setBcStartDate(beforeVO.getStartDate());
                        vo.setBcEndDate(beforeVO.getEndDate());
                        vo.setBcMemo(beforeVO.getMemo());
                        vo.setBcUnitName(beforeVO.getUnitName());
                        vo.setBcQuantities(beforeVO.getQuantities());
                        vo.setBcRentTaxMny(beforeVO.getRentTaxMny());
                    }
                }

                changeCompareVO.setNumRentList(changeCompareVO.getNumRentList().stream().filter(num -> StringUtils.isNotEmpty(num.getChangeType())).collect(Collectors.toList()));
            }

            // 维修
            if (ListUtil.isNotEmpty(changeCompareVO.getRepairList())) {
                List<ChangeRepairVO> repairList = beforeChangeVO.getRepairList();
                Map<Long, ChangeRepairVO> beforeRepairMap = new HashMap<>();
                if (flag) {
                    beforeRepairMap = repairList.stream().collect(Collectors.toMap(ChangeRepairVO::getId, Function.identity()));
                }else {
                    beforeRepairMap = repairList.stream().collect(Collectors.toMap(ChangeRepairVO::getSourceBid, Function.identity()));
                }
                for (ChangeRepairVO vo : changeCompareVO.getRepairList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        ChangeRepairVO beforeVO = beforeRepairMap.get(vo.getSourceBid());
                        vo.setBcRepairItemName(beforeVO.getRepairItemName());
                        vo.setBcRepairUnitName(beforeVO.getRepairUnitName());
                        vo.setBcRepairTaxPrice(beforeVO.getRepairTaxPrice());
                        vo.setBcTaxRate(beforeVO.getTaxRate());
                        vo.setBcMemo(beforeVO.getMemo());
                    }
                }

                changeCompareVO.setRepairList(changeCompareVO.getRepairList().stream().filter(repair -> StringUtils.isNotEmpty(repair.getChangeType())).collect(Collectors.toList()));
            }

            // 报废
            if (ListUtil.isNotEmpty(changeCompareVO.getScrapList())) {
                List<ChangeScrapVO> scrapList = beforeChangeVO.getScrapList();
                Map<Long, ChangeScrapVO> beforeScrapMap = new HashMap<>();
                if (flag) {
                    beforeScrapMap = scrapList.stream().collect(Collectors.toMap(ChangeScrapVO::getId, Function.identity()));
                }else {
                    beforeScrapMap = scrapList.stream().collect(Collectors.toMap(ChangeScrapVO::getSourceBid, Function.identity()));
                }
                for (ChangeScrapVO vo : changeCompareVO.getScrapList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        ChangeScrapVO beforeVO = beforeScrapMap.get(vo.getSourceBid());
                        vo.setBcDamageScrapName(beforeVO.getDamageScrapName());
                        vo.setBcDamageScrapUnitName(beforeVO.getDamageScrapUnitName());
                        vo.setBcDamageScrapTaxPrice(beforeVO.getDamageScrapTaxPrice());
                        vo.setBcTaxRate(beforeVO.getTaxRate());
                        vo.setBcMemo(beforeVO.getMemo());
                    }
                }

                changeCompareVO.setScrapList(changeCompareVO.getScrapList().stream().filter(scarp -> StringUtils.isNotEmpty(scarp.getChangeType())).collect(Collectors.toList()));
            }

            // 其他
            if (ListUtil.isNotEmpty(changeCompareVO.getOtherList())) {
                List<ChangeOtherVO> otherList = beforeChangeVO.getOtherList();
                Map<Long, ChangeOtherVO> beforeOtherMap = new HashMap<>();
                if (flag) {
                    beforeOtherMap = otherList.stream().collect(Collectors.toMap(ChangeOtherVO::getId, Function.identity()));
                }else {
                    beforeOtherMap = otherList.stream().collect(Collectors.toMap(ChangeOtherVO::getSourceBid, Function.identity()));
                }
                for (ChangeOtherVO vo : changeCompareVO.getOtherList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        ChangeOtherVO beforeVO = beforeOtherMap.get(vo.getSourceBid());
                        vo.setBcCostName(beforeVO.getCostName());
                        vo.setBcCount(beforeVO.getCount());
                        vo.setBcUnitTaxPrice(BigDecimal.ZERO);
                        vo.setBcTaxRate(beforeVO.getTaxRate());
                        vo.setBcMemo(beforeVO.getMemo());
                    }
                }

                changeCompareVO.setOtherList(changeCompareVO.getOtherList().stream().filter(other -> StringUtils.isNotEmpty(other.getChangeType())).collect(Collectors.toList()));
            }

            // 设置合同付款阶段
            List<ChangePaymentVO> newPayList = new ArrayList<>();
            Map<Long, ChangePaymentVO> beforePayMap = new HashMap<>();
            if (flag) {
                beforePayMap = beforeChangeVO.getPaymentList().stream().collect(Collectors.toMap(ChangePaymentVO::getId, item -> item, (v1, v2) -> v2));
            }else {
                beforePayMap = beforeChangeVO.getPaymentList().stream().collect(Collectors.toMap(ChangePaymentVO::getSourceBid, item -> item, (v1, v2) -> v2));
            }
            if (ListUtil.isNotEmpty(changeCompareVO.getClauseList())) {
                ChangePaymentVO beforeVo = null;
                for (ChangePaymentVO vo : changeCompareVO.getPaymentList()) {
                    if (vo.getSourceBid() == null) {
                        //没有来源则说明为新增项
                        vo.setChangeType(ChangePaymentVO.CHANGE_TYPE_ADD.toString());
                        newPayList.add(vo);
                    } else if (beforePayMap.containsKey(vo.getSourceBid())) {
                        beforeVo = beforePayMap.get(vo.getSourceBid());
                        if (!beforeVo.getPaymentName().equals(vo.getPaymentName()) || !beforeVo.getPaymentScale().equals(vo.getPaymentScale())) {
                            vo.setBcPaymentName(beforeVo.getPaymentName());
                            vo.setBcPaymentScale(beforeVo.getPaymentScale());
                            vo.setChangeType(ChangePaymentVO.CHANGE_TYPE_CONTENT_CHANGE.toString());
                            newPayList.add(vo);
                        }
                        beforePayMap.remove(vo.getSourceBid());
                    }
                }
            }
            if(MapUtils.isNotEmpty(beforePayMap)) {
                //若原始条款有剩余项，则说这些项变更时被删除
                beforePayMap.values().forEach(c -> {
                    c.setChangeType(ChangePaymentVO.CHANGE_TYPE_DEL.toString());
                    newPayList.add(c);
                });
            }
            changeCompareVO.setPaymentList(newPayList);

            //设置合同条款
            List<ChangeClauseVO> newClauses = new ArrayList<>();
            Map<Long, ChangeClauseVO> beforeClauseMap = new HashMap<>();
            if (flag) {
                beforeClauseMap = beforeChangeVO.getClauseList().stream().collect(Collectors.toMap(ChangeClauseVO::getId, clause -> clause, (v1,v2) ->v2));
            }else {
                beforeClauseMap = beforeChangeVO.getClauseList().stream().collect(Collectors.toMap(ChangeClauseVO::getSourceBid, clause -> clause, (v1,v2) ->v2));
            }
            if(ListUtil.isNotEmpty(changeCompareVO.getClauseList())) {
                ChangeClauseVO beforeVo = null;
                for (ChangeClauseVO vo : changeCompareVO.getClauseList()) {
                    if(vo.getSourceBid() == null) {
                        // 没有来源则说明为新增项
                        vo.setChangeType(ChangePaymentVO.CHANGE_TYPE_ADD.toString());
                        newClauses.add(vo);
                    } else if(beforeClauseMap.containsKey(vo.getSourceBid())) {
                        beforeVo = beforeClauseMap.get(vo.getSourceBid());
                        if (!Objects.equals(beforeVo.getClauseNameId(), vo.getClauseNameId()) || !Objects.equals(beforeVo.getClauseContent(), vo.getClauseContent())) {
                            // 参照变更
                            vo.setBcClauseName(beforeVo.getClauseName());
                            vo.setBcClauseContent(beforeVo.getClauseContent());
                            vo.setChangeType(ChangePaymentVO.CHANGE_TYPE_CONTENT_CHANGE.toString());
                            newClauses.add(vo);
                        }

                        beforeClauseMap.remove(vo.getSourceBid());
                    }
                }
            }
            if(MapUtils.isNotEmpty(beforeClauseMap)) {
                //若原始条款有剩余项，则说这些项变更时被删除
                beforeClauseMap.values().forEach(c -> {
                    c.setChangeType(ChangePaymentVO.CHANGE_TYPE_DEL.toString());
                    newClauses.add(c);
                });
            }
            changeCompareVO.setClauseList(newClauses);



            returnMap.put("newData", changeCompareVO);
            returnMap.put("oldData", beforeChangeVO);
        }

        return returnMap;
    }

    /**
     * 回写记录表数据
     * @param changeEntity
     * @param contractVO
     */
    public void writeBackRecord(ChangeEntity changeEntity, ContractVO contractVO) {
        // 同步原合同到记录表
        RecordEntity recordEntity = BeanMapper.map(contractVO, RecordEntity.class);
        recordEntity.setContractId(changeEntity.getContractId());
        recordEntity.setId(null);

        // 历史记录子表处理
        if(ListUtil.isNotEmpty(recordEntity.getDailyRentList())){
            for (RecordDailyRentEntity entity : recordEntity.getDailyRentList()) {
                // 来源合同子表id
                entity.setSourceBid(entity.getId());
                entity.setId(null);
            }
        }
        if(ListUtil.isNotEmpty(recordEntity.getMonthRentList())){
            for (RecordMonthRentEntity entity : recordEntity.getMonthRentList()) {
                // 来源合同子表id
                entity.setSourceBid(entity.getId());
                entity.setId(null);
            }
        }
        if(ListUtil.isNotEmpty(recordEntity.getNumRentList())){
            for (RecordNumRentEntity entity : recordEntity.getNumRentList()) {
                // 来源合同子表id
                entity.setSourceBid(entity.getId());
                entity.setId(null);
            }
        }
        if(ListUtil.isNotEmpty(recordEntity.getRepairList())){
            for (RecordRepairEntity entity : recordEntity.getRepairList()) {
                // 来源合同子表id
                entity.setSourceBid(entity.getId());
                entity.setId(null);
            }
        }
        if(ListUtil.isNotEmpty(recordEntity.getScrapList())){
            for (RecordScrapEntity entity : recordEntity.getScrapList()) {
                // 来源合同子表id
                entity.setSourceBid(entity.getId());
                entity.setId(null);
            }
        }
        if(ListUtil.isNotEmpty(recordEntity.getOtherList())){
            for (RecordOtherEntity entity : recordEntity.getOtherList()) {
                // 来源合同子表id
                entity.setSourceBid(entity.getId());
                entity.setId(null);
            }
        }
        if(ListUtil.isNotEmpty(recordEntity.getClauseList())){
            for (RecordClauseEntity entity : recordEntity.getClauseList()) {
                // 来源合同子表id
                entity.setSourceBid(entity.getId());
                entity.setId(null);
            }
        }
        if(ListUtil.isNotEmpty(recordEntity.getPaymentList())){
            for (RecordPaymentEntity entity : recordEntity.getPaymentList()) {
                // 来源合同子表id
                entity.setSourceBid(entity.getId());
                entity.setId(null);
            }
        }

        recordService.saveOrUpdate(recordEntity, false);
        logger.info("审批-变更记录表保存主合同数据成功！");

        // 原合同附件、起草附件同步到记录单据中
        logger.info("同步附件");
        CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(contractVO.getId()), BillTypeEnum.辅料中心租入合同.getCode(), CommonConstant.CONTRACT_ATTACH_SOURCE_TYPE,
                String.valueOf(recordEntity.getId()), BillTypeEnum.辅料中心租入合同记录.getCode(), CommonConstant.CONTRACT_RECORD_ATTACH_SOURCE_TYPE);
        logger.info("同步附件::::::::::::结果::" + JSONObject.toJSONString(response));

        logger.info("同步附件");
        CommonResponse<String> response2 = attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(contractVO.getId()), BillTypeEnum.辅料中心租入合同.getCode(), CommonConstant.CONTRACT_FILE_SOURCE_TYPE,
                String.valueOf(recordEntity.getId()), BillTypeEnum.辅料中心租入合同记录.getCode(), CommonConstant.CONTRACT_RECORD_FILE_SOURCE_TYPE);
        logger.info("同步附件::::::::::::结果::" + JSONObject.toJSONString(response2));
        
    }

    /**
     * 回写原合同数据
     * @param changeEntity
     * @param contractVO
     */
    public void writeBackContract(ChangeEntity changeEntity, ContractVO contractVO) {
        ContractEntity contractEntity = BeanMapper.map(contractVO, ContractEntity.class);
        
        // 甲方、乙方信息
        contractEntity.setFirstPartyProjectManagerId(changeEntity.getFirstPartyProjectManagerId());
        contractEntity.setFirstPartyProjectManagerName(changeEntity.getFirstPartyProjectManagerName());
        contractEntity.setFirstPartyEmployeeId(changeEntity.getFirstPartyEmployeeId());
        contractEntity.setFirstPartyEmployeeName(changeEntity.getFirstPartyEmployeeName());
        contractEntity.setFirstPartyPhone(changeEntity.getFirstPartyPhone());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setSupplierEmployeeId(changeEntity.getSupplierEmployeeId());
        contractEntity.setSupplierEmployeeName(changeEntity.getSupplierEmployeeName());
        contractEntity.setSupplierPhone(changeEntity.getSupplierPhone());
        contractEntity.setSupplierAddress(changeEntity.getSupplierAddress());
        
        contractEntity.setFirstPartyEntrustedAgentId(changeEntity.getFirstPartyEntrustedAgentId());
        contractEntity.setFirstPartyEntrustedAgentName(changeEntity.getFirstPartyEntrustedAgentName());
        contractEntity.setFirstPartyPrincipalId(changeEntity.getFirstPartyPrincipalId());
        contractEntity.setFirstPartyPrincipalName(changeEntity.getFirstPartyPrincipalName());
        contractEntity.setFirstPartyAddress(changeEntity.getFirstPartyAddress());
        contractEntity.setSupplierPrincipalId(changeEntity.getSupplierPrincipalId());
        contractEntity.setSupplierPrincipalName(changeEntity.getSupplierPrincipalName());
        contractEntity.setMaterialClerkOneId(changeEntity.getMaterialClerkOneId());
        contractEntity.setMaterialClerkOneName(changeEntity.getMaterialClerkOneName());
        contractEntity.setMaterialClerkOnePhone(changeEntity.getMaterialClerkOnePhone());
        contractEntity.setMaterialClerkTwoId(changeEntity.getMaterialClerkTwoId());
        contractEntity.setMaterialClerkTwoName(changeEntity.getMaterialClerkTwoName());
        contractEntity.setMaterialClerkTwoPhone(changeEntity.getMaterialClerkTwoPhone());
        
        
        // 合同金额
        contractEntity.setContractMny(changeEntity.getContractMny());
        contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setTax(changeEntity.getTax());
        contractEntity.setChangingMny(null);
        contractEntity.setChangingTaxMny(null);
        
        // 计租方式
        contractEntity.setRentCalculationType(changeEntity.getRentCalculationType());
        contractEntity.setMonthSettlementDay(changeEntity.getMonthSettlementDay());
        
        // 其他业务字段
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setChangeContractName(changeEntity.getContractName());
        contractEntity.setSupplyAddress(changeEntity.getSupplyAddress());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setRentCalculationDate(changeEntity.getRentCalculationDate());
        contractEntity.setEndRentCalculationDate(changeEntity.getEndRentCalculationDate());
        contractEntity.setChangeStatus(ChangeStatusEnum.已变更.getCode());
        contractEntity.setChangeContractSignatureStatus(SignatureStatusEnum.已签章.getCode().toString());
        contractEntity.setChangeDraftType(changeEntity.getChangeDraftType());
        contractEntity.setChangeFileId(changeEntity.getChangeFileId());
        
        // 回写原合同子表信息
        // 日租
        if (ListUtil.isNotEmpty(contractVO.getDailyRentList())) {
            dailyRentService.removeByIds(contractVO.getDailyRentList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        List<ContractDailyRentEntity> dailyRentList = BeanMapper.mapList(changeEntity.getDailyRentList(), ContractDailyRentEntity.class);
        if (ListUtil.isNotEmpty(dailyRentList)) {
            for (ContractDailyRentEntity entity : dailyRentList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setDailyRentList(dailyRentList);
        
        // 月租
        if (ListUtil.isNotEmpty(contractVO.getMonthRentList())) {
            monthRentService.removeByIds(contractVO.getMonthRentList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        List<ContractMonthRentEntity> monthRentList = BeanMapper.mapList(changeEntity.getMonthRentList(), ContractMonthRentEntity.class);
        if (ListUtil.isNotEmpty(monthRentList)) {
            for (ContractMonthRentEntity entity : monthRentList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setMonthRentList(monthRentList);
        
        // 工程量租
        if (ListUtil.isNotEmpty(contractVO.getNumRentList())) {
            numRentService.removeByIds(contractVO.getNumRentList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        List<ContractNumRentEntity> numRentList = BeanMapper.mapList(changeEntity.getNumRentList(), ContractNumRentEntity.class);
        if (ListUtil.isNotEmpty(numRentList)) {
            for (ContractNumRentEntity entity : numRentList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setNumRentList(numRentList);

        // 维修
        if (ListUtil.isNotEmpty(contractVO.getRepairList())) {
            repairService.removeByIds(contractVO.getRepairList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        List<ContractRepairEntity> repairList = BeanMapper.mapList(changeEntity.getRepairList(), ContractRepairEntity.class);
        if (ListUtil.isNotEmpty(repairList)) {
            for (ContractRepairEntity entity : repairList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setRepairList(repairList);

        // 报废
        if (ListUtil.isNotEmpty(contractVO.getScrapList())) {
            scrapService.removeByIds(contractVO.getScrapList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        List<ContractScrapEntity> scrapList = BeanMapper.mapList(changeEntity.getScrapList(), ContractScrapEntity.class);
        if (ListUtil.isNotEmpty(scrapList)) {
            for (ContractScrapEntity entity : scrapList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setScrapList(scrapList);

        // 其他费用
        if (ListUtil.isNotEmpty(contractVO.getOtherList())) {
            otherService.removeByIds(contractVO.getOtherList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        List<ContractOtherEntity> otherList = BeanMapper.mapList(changeEntity.getOtherList(), ContractOtherEntity.class);
        if (ListUtil.isNotEmpty(otherList)) {
            for (ContractOtherEntity entity : otherList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setOtherList(otherList);

        // 付款计划
        if (ListUtil.isNotEmpty(contractVO.getPaymentList())) {
            paymentService.removeByIds(contractVO.getPaymentList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        List<ContractPaymentEntity> paymentList = BeanMapper.mapList(changeEntity.getPaymentList(), ContractPaymentEntity.class);
        if (ListUtil.isNotEmpty(paymentList)) {
            for (ContractPaymentEntity entity : paymentList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setPaymentList(paymentList);

        // 条款
        if (ListUtil.isNotEmpty(contractVO.getClauseList())) {
            clauseService.removeByIds(contractVO.getClauseList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        List<ContractClauseEntity> clauseList = BeanMapper.mapList(changeEntity.getClauseList(), ContractClauseEntity.class);
        if (ListUtil.isNotEmpty(clauseList)) {
            for (ContractClauseEntity entity : clauseList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setClauseList(clauseList);

        // 更新合同池操作
        Boolean pushResult = this.pushContract(BeanMapper.map(contractEntity, ContractVO.class), UpdateLevelEnum.全量覆盖更新.getLevelCode());
        if(pushResult) {
            contractEntity.setPushPoolFlag(BillPushStatusEnum.推送成功.getStatus());
        } else {
            contractEntity.setPushPoolFlag(BillPushStatusEnum.未成功推送.getStatus());
        }
        
        
        contractService.saveOrUpdate(contractEntity, false);
        
        // 同步起草方式附件（不包含变更附件管理附件）到原合同
        logger.info("同步附件");
        CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(changeEntity.getId()), BillTypeEnum.辅料中心租入合同变更.getCode(), CommonConstant.CONTRACT_CHANGE_ATTACH_SOURCE_TYPE,
                String.valueOf(contractEntity.getId()), BillTypeEnum.辅料中心租入合同.getCode(), CommonConstant.CONTRACT_ATTACH_SOURCE_TYPE);
        logger.info("同步附件::::::::::::结果::" + JSONObject.toJSONString(response));
        
    }

    public void clearDetailList(ChangeEntity changeEntity) {
        // 日租
        if(ListUtil.isNotEmpty(changeEntity.getDailyRentList())){
            for (ChangeDailyRentEntity entity : changeEntity.getDailyRentList()) {
                if (entity.getId() != null) {
                    // 来源合同子表id
                    entity.setSourceBid(entity.getId());
                }
                entity.setId(null);
                entity.setContractId(changeEntity.getMainContractId());
            }
        }
        // 月租
        if(ListUtil.isNotEmpty(changeEntity.getMonthRentList())){
            for (ChangeMonthRentEntity entity : changeEntity.getMonthRentList()) {
                if (entity.getId() != null) {
                    // 来源合同子表id
                    entity.setSourceBid(entity.getId());
                }
                entity.setId(null);
                entity.setContractId(changeEntity.getMainContractId());
            }
        }
        // 工程量租
        if(ListUtil.isNotEmpty(changeEntity.getNumRentList())){
            for (ChangeNumRentEntity entity : changeEntity.getNumRentList()) {
                if (entity.getId() != null) {
                    // 来源合同子表id
                    entity.setSourceBid(entity.getId());
                }
                entity.setId(null);
                entity.setContractId(changeEntity.getMainContractId());
            }
        }
        // 维修
        if(ListUtil.isNotEmpty(changeEntity.getRepairList())){
            for (ChangeRepairEntity entity : changeEntity.getRepairList()) {
                if (entity.getId() != null) {
                    // 来源合同子表id
                    entity.setSourceBid(entity.getId());
                }
                entity.setId(null);
                entity.setContractId(changeEntity.getMainContractId());
            }
        }
        // 报废
        if(ListUtil.isNotEmpty(changeEntity.getScrapList())){
            for (ChangeScrapEntity entity : changeEntity.getScrapList()) {
                if (entity.getId() != null) {
                    // 来源合同子表id
                    entity.setSourceBid(entity.getId());
                }
                entity.setId(null);
                entity.setContractId(changeEntity.getMainContractId());
            }
        }
        // 其他费用
        if(ListUtil.isNotEmpty(changeEntity.getOtherList())){
            for (ChangeOtherEntity entity : changeEntity.getOtherList()) {
                if (entity.getId() != null) {
                    // 来源合同子表id
                    entity.setSourceBid(entity.getId());
                }
                entity.setId(null);
                entity.setContractId(changeEntity.getMainContractId());
            }
        }
        // 付款计划
        if(ListUtil.isNotEmpty(changeEntity.getPaymentList())){
            for (ChangePaymentEntity entity : changeEntity.getPaymentList()) {
                if (entity.getId() != null) {
                    // 来源合同子表id
                    entity.setSourceBid(entity.getId());
                }
                entity.setId(null);
                entity.setContractId(changeEntity.getMainContractId());
            }
        }
        // 合同条款
        if(ListUtil.isNotEmpty(changeEntity.getClauseList())){
            for (ChangeClauseEntity entity : changeEntity.getClauseList()) {
                if (entity.getId() != null) {
                    // 来源合同子表id
                    entity.setSourceBid(entity.getId());
                }
                entity.setId(null);
                entity.setContractId(changeEntity.getMainContractId());
            }
        }
    }


    public void deleteOldCost(ChangeVO changeVO) {
        List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();

        ExecutionVO executionVO = targetCost(changeVO);
        totalExecutionVOList.add(executionVO.getTotalVO());
        CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()){
            throw new BusinessException("删除旧目标成本失败！");
        }
        
    }
    
    public ExecutionVO targetCost(ChangeVO changeVO) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();

        totalVO.setSourceId(changeVO.getId());
        totalVO.setTenantId(changeVO.getTenantId());
        totalVO.setBillCode(changeVO.getBillCode());
        totalVO.setBillType("BT220210000000005");
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.周转材租赁合同.getCode());
        totalVO.setProjectId(changeVO.getProjectId());
        totalVO.setOrgId(changeVO.getOrgId());
        totalVO.setMoney(changeVO.getContractMny());
        totalVO.setTaxMoney(changeVO.getContractTaxMny());
        totalVO.setLinkUrl(baseHost + "ejc-assistrmat-frontend/#/contract/changeCard?id=" + changeVO.getId());

        executionVO.setTotalVO(totalVO);

        return executionVO;
    }

    @Override
    public Boolean pushContract(ContractVO vo, String updateLevel) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            // 删除原单据
            contractService.delContractFromPool(vo.getId());
            
            BeanConvertorUtil.convert(vo, data);
            data.setSourceType(ContractTypeEnum.周转材合同.getTypeCode());
            data.setContractProperty(Integer.valueOf(SettleEnum.支出.getCode()));

            // 合同累计变更金额
            ChangeRecordVO changeRecordVO = queryChangeRecord(vo.getId());
            data.setTotalChangeMny(changeRecordVO.getTotalChangeMny());
            data.setTotalChangeTaxMny(changeRecordVO.getTotalChangeTaxMny());
            data.setTotalChangeTax(ComputeUtil.safeSub(data.getTotalChangeTaxMny(), data.getTotalChangeMny()));
            data.setTaotalChangeScale(changeRecordVO.getTotalChangeRate());

            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);

            if(transDataResp.isSuccess()) {
                return true;
            } else {
                logger.error("合同id-{}推送合同池失败，{}",vo.getId(), transDataResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", vo.getId(), e);
        }

        return null;
    }
    
}
