/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.assist.material.bean.MaterialCheckDetailEntity;
import com.ejianc.business.assist.material.bean.MaterialCheckEntity;
import com.ejianc.business.assist.material.bean.MaterialDeliveryDetailEntity;
import com.ejianc.business.assist.material.bean.MaterialDeliveryEntity;
import com.ejianc.business.assist.material.mapper.MaterialCheckMapper;
import com.ejianc.business.assist.material.service.IMaterialCheckDetailService;
import com.ejianc.business.assist.material.service.IMaterialCheckService;
import com.ejianc.business.assist.material.service.IMaterialDeliveryDetailService;
import com.ejianc.business.assist.material.service.IMaterialDeliveryService;
import com.ejianc.business.assist.material.vo.MaterialCheckDetailVO;
import com.ejianc.business.assist.material.vo.MaterialCheckVO;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.enums.SupplierSignStatusEnum;
import com.ejianc.business.assist.rmat.utils.PushSupUtil;
import com.ejianc.business.common.util.MathUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="materialCheckService")
public class MaterialCheckServiceImpl
extends BaseServiceImpl<MaterialCheckMapper, MaterialCheckEntity>
implements IMaterialCheckService {
    private static final String BILL_CODE = "MATERIAL_CHECK";
    private static final String OPERATE = "CHECK_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.\u9a8c\u6536\u5355.getCode();
    private static final String BILL_NAME = BillTypeEnum.\u9a8c\u6536\u5355.getName();
    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/check/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/check/billDel";
    @Autowired
    private PushSupUtil pushSupUtil;
    @Autowired
    private IMaterialDeliveryDetailService deliveryDetailService;
    @Autowired
    private IMaterialCheckDetailService checkDetailService;
    @Autowired
    private IMaterialDeliveryService deliveryService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    @Transactional
    public MaterialCheckVO saveOrUpdate(MaterialCheckVO saveOrUpdateVO) {
        MaterialCheckEntity entity = (MaterialCheckEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MaterialCheckEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
        }
        if (null == entity.getSupplierSignStatus()) {
            entity.setSupplierSignStatus(SupplierSignStatusEnum.\u4e59\u65b9\u672a\u7b7e\u5b57.getCode());
        }
        super.saveOrUpdate((Object)entity, false);
        if ("1".equals(entity.getCheckSource())) {
            String checkStatus = "0";
            MaterialDeliveryEntity materialDeliveryEntity = (MaterialDeliveryEntity)((Object)this.deliveryService.selectById(entity.getDeliveryId()));
            LambdaQueryWrapper lambdaCheckDetail = Wrappers.lambdaQuery();
            lambdaCheckDetail.eq(MaterialCheckDetailEntity::getDeliveryId, (Object)entity.getDeliveryId());
            List materialCheckDetailEntityList = this.checkDetailService.list((Wrapper)lambdaCheckDetail);
            if (CollectionUtils.isNotEmpty((Collection)materialCheckDetailEntityList)) {
                Map<Long, List<MaterialCheckDetailEntity>> checkMap = materialCheckDetailEntityList.stream().collect(Collectors.groupingBy(MaterialCheckDetailEntity::getDeliveryDetailId));
                LambdaQueryWrapper lambdaDeliveryDetail = Wrappers.lambdaQuery();
                lambdaDeliveryDetail.eq(MaterialDeliveryDetailEntity::getDeliveryId, (Object)entity.getDeliveryId());
                List materialDeliveryDetailEntityList = this.deliveryDetailService.list((Wrapper)lambdaDeliveryDetail);
                for (MaterialDeliveryDetailEntity materialDeliveryDetailEntity : materialDeliveryDetailEntityList) {
                    List<MaterialCheckDetailEntity> checkAllDetailEntityList = checkMap.get(materialDeliveryDetailEntity.getId());
                    if (CollectionUtils.isNotEmpty(checkAllDetailEntityList)) {
                        BigDecimal checkNum = checkAllDetailEntityList.stream().map(MaterialCheckDetailEntity::getCheckNumsSum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        materialDeliveryDetailEntity.setCheckNumsSum(checkNum);
                    }
                    if (null != materialDeliveryDetailEntity.getCheckNumsSum()) continue;
                    materialDeliveryDetailEntity.setCheckNumsSum(BigDecimal.ZERO);
                }
                Boolean allCheck = materialDeliveryDetailEntityList.stream().allMatch(e -> e.getCheckNumsSum().compareTo(e.getDeliveredNumsSum()) > -1);
                Boolean anyCheck = materialDeliveryDetailEntityList.stream().anyMatch(e -> e.getCheckNumsSum().compareTo(BigDecimal.ZERO) == 1 && e.getCheckNumsSum().compareTo(e.getDeliveredNumsSum()) == -1);
                if (allCheck.booleanValue()) {
                    checkStatus = "2";
                }
                if (anyCheck.booleanValue()) {
                    checkStatus = "1";
                }
                materialDeliveryEntity.setAcceptanceState(checkStatus);
                String msg = this.deliveryService.updateBillConfirmState(materialDeliveryEntity);
                if (null != msg) {
                    throw new BusinessException("\u63a8\u9001\u5931\u8d25");
                }
                this.deliveryDetailService.updateBatchById(materialDeliveryDetailEntityList);
            }
        }
        MaterialCheckVO vo = (MaterialCheckVO)BeanMapper.map((Object)((Object)entity), MaterialCheckVO.class);
        return vo;
    }

    @Override
    public void delete(List<MaterialCheckVO> vos) {
        if (vos.size() > 1) {
            throw new BusinessException("\u9a8c\u6536\u5355\u4e0d\u5141\u8bb8\u6279\u91cf\u5220\u9664!");
        }
        MaterialCheckVO materialCheckVO = vos.get(0);
        MaterialCheckEntity materialCheckEntity = (MaterialCheckEntity)((Object)super.selectById((Serializable)materialCheckVO.getId()));
        if ("1".equals(materialCheckEntity.getCheckSource())) {
            List<MaterialCheckDetailEntity> checkDetailList = materialCheckEntity.getCheckDetailList();
            MaterialDeliveryEntity materialDeliveryEntity = (MaterialDeliveryEntity)((Object)this.deliveryService.selectById(materialCheckEntity.getDeliveryId()));
            List<MaterialDeliveryDetailEntity> deliveryDetailList = materialDeliveryEntity.getDeliveryDetailList();
            Map checkDetailEntityMap = checkDetailList.stream().collect(Collectors.toMap(MaterialCheckDetailEntity::getDeliveryDetailId, Function.identity()));
            for (MaterialDeliveryDetailEntity materialDeliveryDetailEntity : deliveryDetailList) {
                if (!checkDetailEntityMap.containsKey(materialDeliveryDetailEntity.getId())) continue;
                MaterialCheckDetailEntity materialCheckDetailEntity = (MaterialCheckDetailEntity)((Object)checkDetailEntityMap.get(materialDeliveryDetailEntity.getId()));
                materialDeliveryDetailEntity.setCheckNumsSum(MathUtil.safeSub(materialDeliveryDetailEntity.getCheckNumsSum(), materialCheckDetailEntity.getCheckNumsSum()));
            }
            Boolean notCheck = deliveryDetailList.stream().allMatch(e -> e.getCheckNumsSum().compareTo(BigDecimal.ZERO) < 1);
            Boolean anyCheck = deliveryDetailList.stream().anyMatch(e -> e.getCheckNumsSum().compareTo(BigDecimal.ZERO) == 1);
            String checkStatus = "0";
            if (notCheck.booleanValue()) {
                checkStatus = "0";
            }
            if (anyCheck.booleanValue()) {
                checkStatus = "1";
            }
            materialDeliveryEntity.setAcceptanceState(checkStatus);
            String msg = this.deliveryService.updateBillConfirmState(materialDeliveryEntity);
            if (null != msg) {
                throw new BusinessException("\u63a8\u9001\u5931\u8d25");
            }
            this.deliveryDetailService.updateBatchById(deliveryDetailList);
        }
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        super.removeByIds(ids, true);
    }

    @Override
    public boolean pushBillToSupCenter(MaterialCheckEntity entity) {
        Boolean syncFlag = this.pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON((Object)((Object)entity)), OPERATE, BILL_TYPE, BILL_NAME, PUSH_BILL_SERVER_URL);
        return syncFlag;
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String billId = request.getParameter("billId");
        MaterialCheckEntity entity = (MaterialCheckEntity)((Object)super.selectById((Serializable)((Object)billId)));
        String msg = this.pushSupUtil.updateBillSupSignSyncInfo(request, (JSONObject)JSONObject.toJSON((Object)((Object)entity)), MaterialCheckEntity.class, OPERATE, BILL_TYPE, BILL_NAME);
        return msg;
    }

    @Override
    public boolean delPushBill(MaterialCheckEntity entity) {
        Boolean delSuc = this.pushSupUtil.delPushBill((JSONObject)JSONObject.toJSON((Object)((Object)entity)), OPERATE, BILL_TYPE, BILL_NAME, DEL_SUP_BILL_SERVER_URL);
        return delSuc;
    }

    @Override
    public void submitChangeCheckNums(List<MaterialCheckDetailEntity> checkDetailList) {
        for (MaterialCheckDetailEntity detailEntity : checkDetailList) {
            MaterialDeliveryDetailEntity materialDeliveryDetailEntity = (MaterialDeliveryDetailEntity)((Object)this.deliveryDetailService.selectById(detailEntity.getDeliveryDetailId()));
            BigDecimal checkNumsSum = MathUtil.safeAdd(materialDeliveryDetailEntity.getCheckNumsSum(), detailEntity.getCheckNumsSum());
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)detailEntity.getDeliveryDetailId());
            wrapper.set(MaterialDeliveryDetailEntity::getCheckNumsSum, (Object)checkNumsSum);
            this.deliveryDetailService.update((Wrapper)wrapper);
        }
    }

    @Override
    public void backChangeCheckNums(List<MaterialCheckDetailEntity> checkDetailList) {
        for (MaterialCheckDetailEntity detailEntity : checkDetailList) {
            MaterialDeliveryDetailEntity materialDeliveryDetailEntity = (MaterialDeliveryDetailEntity)((Object)this.deliveryDetailService.selectById(detailEntity.getDeliveryDetailId()));
            BigDecimal checkNumsSum = MathUtil.safeSub(materialDeliveryDetailEntity.getCheckNumsSum(), detailEntity.getCheckNumsSum());
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)detailEntity.getDeliveryDetailId());
            wrapper.set(MaterialDeliveryDetailEntity::getCheckNumsSum, (Object)checkNumsSum);
            this.deliveryDetailService.update((Wrapper)wrapper);
        }
    }

    @Override
    public void submitChangeCheckState(Long deliveryId, List<MaterialCheckDetailEntity> detailEntities) {
        LambdaUpdateWrapper wrapper;
        Map collect = detailEntities.stream().collect(Collectors.toMap(MaterialCheckDetailEntity::getDeliveryDetailId, Function.identity(), (k1, k2) -> k2));
        MaterialDeliveryEntity materialDeliveryEntity = (MaterialDeliveryEntity)((Object)this.deliveryService.selectById(deliveryId));
        Boolean allCheck = true;
        for (MaterialDeliveryDetailEntity materialDeliveryDetailEntity : materialDeliveryEntity.getDeliveryDetailList()) {
            BigDecimal checkNumsSum = BigDecimal.ZERO;
            checkNumsSum = materialDeliveryDetailEntity.getCheckNumsSum();
            if (null != checkNumsSum && checkNumsSum.compareTo(materialDeliveryDetailEntity.getDeliveredNumsSum()) != -1) continue;
            allCheck = false;
        }
        if (allCheck.booleanValue()) {
            wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)deliveryId);
            wrapper.set(MaterialDeliveryEntity::getAcceptanceState, (Object)"2");
            this.deliveryService.update((Wrapper)wrapper);
        } else {
            wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)deliveryId);
            wrapper.set(MaterialDeliveryEntity::getAcceptanceState, (Object)"1");
            this.deliveryService.update((Wrapper)wrapper);
        }
    }

    @Override
    public void backChangeCheckState(Long deliveryId, List<MaterialCheckDetailEntity> detailEntities) {
        LambdaUpdateWrapper wrapper;
        Map collect = detailEntities.stream().collect(Collectors.toMap(MaterialCheckDetailEntity::getDeliveryDetailId, Function.identity(), (k1, k2) -> k2));
        MaterialDeliveryEntity materialDeliveryEntity = (MaterialDeliveryEntity)((Object)this.deliveryService.selectById(deliveryId));
        Boolean waitCheck = true;
        for (MaterialDeliveryDetailEntity materialDeliveryDetailEntity : materialDeliveryEntity.getDeliveryDetailList()) {
            BigDecimal checkNumsSum = BigDecimal.ZERO;
            checkNumsSum = materialDeliveryDetailEntity.getCheckNumsSum();
            if (null != checkNumsSum && checkNumsSum.compareTo(BigDecimal.ZERO) != 1) continue;
            waitCheck = false;
        }
        if (waitCheck.booleanValue()) {
            wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)deliveryId);
            wrapper.set(MaterialDeliveryEntity::getAcceptanceState, (Object)"0");
            this.deliveryService.update((Wrapper)wrapper);
        } else {
            wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)deliveryId);
            wrapper.set(MaterialDeliveryEntity::getAcceptanceState, (Object)"1");
            this.deliveryService.update((Wrapper)wrapper);
        }
    }

    @Override
    public String validateTime(MaterialCheckVO materialCheckVO, String type) {
        if (materialCheckVO.getRmatDate().getTime() < materialCheckVO.getCheckDate().getTime()) {
            throw new BusinessException("\u8ba1\u79df\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u9a8c\u6536\u65e5\u671f\uff01");
        }
        if (CollectionUtils.isNotEmpty((Collection)materialCheckVO.getCheckDetailList())) {
            for (MaterialCheckDetailVO detailVO : materialCheckVO.getCheckDetailList()) {
                if ("del".equals(detailVO.getRowState()) || detailVO.getRmatDate().getTime() >= materialCheckVO.getCheckDate().getTime()) continue;
                throw new BusinessException("\u3010" + detailVO.getMaterialName() + "\u3011\u8ba1\u79df\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u9a8c\u6536\u65e5\u671f\uff01");
            }
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contractId", materialCheckVO.getContractId());
        if (materialCheckVO.getId() != null) {
            params.put("billType", "\u9a8c\u6536\u5355");
            params.put("billId", materialCheckVO.getId());
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }
}

