/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.material.bean.MaterialDeliveryDetailEntity;
import com.ejianc.business.assist.material.bean.MaterialDeliveryEntity;
import com.ejianc.business.assist.material.bean.MaterialOrderDetailEntity;
import com.ejianc.business.assist.material.bean.MaterialOrderEntity;
import com.ejianc.business.assist.material.mapper.MaterialDeliveryDetailMapper;
import com.ejianc.business.assist.material.mapper.MaterialDeliveryMapper;
import com.ejianc.business.assist.material.service.IMaterialDeliveryService;
import com.ejianc.business.assist.material.service.IMaterialOrderDetailService;
import com.ejianc.business.assist.material.service.IMaterialOrderService;
import com.ejianc.business.assist.rmat.utils.EntityUtil;
import com.ejianc.business.assist.rmat.utils.PushSupUtil;
import com.ejianc.business.common.util.MathUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="materialDeliveryService")
public class MaterialDeliveryServiceImpl
extends BaseServiceImpl<MaterialDeliveryMapper, MaterialDeliveryEntity>
implements IMaterialDeliveryService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String noPower = "\u65e0\u6743\u9650\u8bbf\u95ee\u8be5\u670d\u52a1\uff0c\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u6388\u6743\uff01";
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private MaterialDeliveryDetailMapper detailMapper;
    @Autowired
    private IMaterialOrderService orderService;
    @Autowired
    private IMaterialOrderDetailService orderDetailService;
    @Autowired
    private PushSupUtil pushSupUtil;
    private static final String OPERATE = "supDeliveryBill";
    private static final String BILL_CODE = "BT220223000000005";
    private static final String BILL_NAME = "\u9001\u8d27\u5355";
    private static final String BILL_WITER_BACK_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/delivery/supSignSync";
    private static final String CHANGE_CLOSE_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/delivery/changeCloseState";

    @Override
    public String saveSyncBill(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String transData = request.getParameter("transData");
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map map = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        this.logger.info("\u63a5\u6536\u5230\u63a8\u9001\u5355\u636e-{}: {}, \u5f53\u524d\u4e0a\u4e0b\u6587: {}", new Object[]{BILL_NAME, transData, authority});
        if (StringUtils.isBlank((CharSequence)transData)) {
            return "\u5355\u636e\u540c\u6b65\u5931\u8d25\uff0c\u5355\u636e\u5185\u5bb9\u4e3a\u7a7a\uff01";
        }
        MaterialDeliveryEntity entity = (MaterialDeliveryEntity)((Object)JSONObject.parseObject((String)transData, MaterialDeliveryEntity.class));
        entity.setSourceId(entity.getId().toString());
        this.clearInvalidData(entity);
        MaterialDeliveryEntity data = (MaterialDeliveryEntity)((Object)EntityUtil.selectOne((String)"source_id", (Object)entity.getSourceId(), MaterialDeliveryEntity.class));
        if (null != data) {
            return "\u5355\u636e\u5df2\u7ecf\u8fdb\u884c\u8fc7\u540c\u6b65\u64cd\u4f5c\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01";
        }
        ArrayList attchIdsList = new ArrayList();
        if (request instanceof MultipartHttpServletRequest) {
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, map, BILL_CODE, authority, null);
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
        }
        entity.setAttachIds(attchIdsList);
        this.submitChangeDeliveryNums(entity.getDeliveryDetailList());
        this.submitChangeDeliveryState(entity.getOrderId(), entity.getDeliveryDetailList());
        super.saveOrUpdate((Object)entity, false);
        String[] channel = new String[]{"sys"};
        String linkId = entity.getLinkId().toString();
        Object[] receivers = new String[]{linkId};
        String result = this.pushSupUtil.sendMsg(channel, (String[])receivers, "notice", "\u8ba2\u5355\u5f00\u59cb\u9001\u8d27\u63d0\u9192", "\u9001\u8d27\u5355[BT220223000000005]\u8ba2\u5355\u5f00\u59cb\u9001\u8d27");
        if (null != result) {
            this.logger.error("\u5411\u7528\u6237-{}\u53d1\u9001\u5355\u636eid-{}\u9001\u8d27\u5355\u63a8\u9001\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", new Object[]{StringUtils.join((Object[])receivers), entity.getId(), result});
        }
        return null;
    }

    private void clearInvalidData(MaterialDeliveryEntity entity) {
        entity.setCreateTime(null);
        entity.setUpdateTime(null);
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        entity.setUpdateUserCode(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateBillConfirmState(MaterialDeliveryEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "BT220223000000005::" + entity.getId().toString() + "::sup";
        CommonResponse userResp = this.userApi.findUserByUserId(InvocationInfoProxy.getUserid());
        if (!userResp.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u5f53\u524d\u7528\u6237id-{},\u4fe1\u606f\u5931\u8d25\uff0c {}", (Object)InvocationInfoProxy.getUserid(), (Object)userResp.getMsg());
            return "\u67e5\u8be2\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25!";
        }
        UserVO user = (UserVO)userResp.getData();
        this.logger.info("\u7528\u6237{}\u5bf9\u5355\u636eid-{}\u8fdb\u884c\u786e\u8ba4\u64cd\u4f5c\uff01", (Object)user.getUserName(), (Object)entity.getId());
        entity.setSupOperateTime(new Date());
        entity.setSupOperatorPhone(user.getUserMobile());
        entity.setSupOperatorName(user.getUserName());
        entity.setSupOperatorUserCode(user.getUserCode());
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)OPERATE, (int)600);
            if (!locked) {
                this.releaseLock(jedis, false, key, OPERATE);
                String string = "\u5355\u636e\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01";
                return string;
            }
            HashMap files = new HashMap();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("billId", entity.getId().toString());
            params.put("supOperatorName", entity.getSupOperatorName());
            params.put("supOperatorPhone", entity.getSupOperatorPhone());
            params.put("supOperatorUserCode", entity.getSupOperatorUserCode());
            params.put("supOperateTime", String.valueOf(entity.getSupOperateTime().getTime()));
            params.put("acceptanceState", entity.getAcceptanceState());
            this.logger.info("\u5355\u636e-{}id-{}\u5df2\u786e\u8ba4\uff0c\u901a\u77e5\u5355\u636e\u63a8\u9001\u65b9systemId-{},\u53c2\u6570-{}", new Object[]{BILL_NAME, entity.getId(), entity.getSourceSystemId(), JSONObject.toJSONString(params)});
            CommonResponse backResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(BILL_WITER_BACK_SERVER_URL, params, entity.getSupplierId().toString(), files);
            this.logger.error("\u5355\u636e-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u53d1\u9001\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)BILL_NAME, (Object)JSONObject.toJSONString((Object)backResp));
            if (!backResp.isSuccess()) {
                this.logger.error("\u5355\u636e-{}id-{}\u786e\u8ba4\u4fe1\u606f\u56de\u5199\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c{}", new Object[]{BILL_NAME, entity.getId(), backResp.getMsg()});
                String string = "\u9001\u8d27\u5355\u786e\u8ba4\u4fe1\u606f\u56de\u5199\u53d1\u9001\u8bf7\u6c42\u5931\u8d25";
                return string;
            }
            CommonResponse operateResp = (CommonResponse)JSONObject.parseObject((String)((String)backResp.getData()), CommonResponse.class);
            if (!operateResp.isSuccess()) {
                this.logger.error("\u5355\u636e-{}id-{}\u786e\u8ba4\u4fe1\u606f\u56de\u8c03\u5904\u7406\u5931\u8d25\uff0c{}", new Object[]{BILL_NAME, entity.getId(), operateResp.getMsg()});
                String string = "\u786e\u8ba4\u4fe1\u606f\u56de\u8c03\u5904\u7406\u5931\u8d25";
                return string;
            }
            super.saveOrUpdate((Object)entity);
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636e-{}id-{}\u786e\u8ba4\u5f02\u5e38\uff0c", new Object[]{BILL_NAME, entity.getId(), e});
            msg = "\u64cd\u4f5c\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, OPERATE);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String billDel(MaterialDeliveryEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "BT220223000000005::" + entity.getId().toString() + "::sup";
        try {
            CommonResponse fileDelResp;
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)OPERATE, (int)600);
            if (!locked) {
                this.releaseLock(jedis, false, key, OPERATE);
                String string = "\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u6570\u636e\u5df2\u88ab\u4fee\u6539\uff01";
                return string;
            }
            CommonResponse fileResp = this.attachmentApi.queryListBySourceId(entity.getId(), null, null, null);
            if (!fileResp.isSuccess()) {
                String string = "\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u83b7\u53d6\u5355\u636e\u9644\u4ef6\u5931\u8d25\uff01";
                return string;
            }
            List files = (List)fileResp.getData();
            if (CollectionUtils.isNotEmpty((Collection)files) && !(fileDelResp = this.attachmentApi.delete(StringUtils.join((Iterable)files.stream().map(file -> file.getId()).collect(Collectors.toList()), (String)","))).isSuccess()) {
                String string = "\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9644\u4ef6\u5220\u9664\u5931\u8d25\uff01";
                return string;
            }
            this.backChangeDeliveryNums(entity.getDeliveryDetailList());
            this.backChangeDeliveryState(entity.getOrderId(), entity.getDeliveryDetailList());
            boolean delResult = this.delById(entity.getId());
            if (!delResult) {
                String string = "\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e\u5220\u9664\u5931\u8d25\uff01";
                return string;
            }
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636e-{}id-{}\u4f5c\u5e9f\u5931\u8d25\uff0c", new Object[]{BILL_NAME, entity.getId(), e});
            msg = "\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e\u4fe1\u606f\u5904\u7406\u5f02\u5e38\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, OPERATE);
        }
        return msg;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean delById(Long id) {
        ((MaterialDeliveryMapper)this.baseMapper).delById(id);
        this.detailMapper.delByTId(id);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public void submitChangeDeliveryNums(List<MaterialDeliveryDetailEntity> deliveryDetailList) {
        for (MaterialDeliveryDetailEntity detailEntity : deliveryDetailList) {
            MaterialOrderDetailEntity materialOrderDetailEntity = (MaterialOrderDetailEntity)((Object)this.orderDetailService.selectById(detailEntity.getOrderDetailId()));
            BigDecimal notDeliveredNumsSum = MathUtil.safeSub(materialOrderDetailEntity.getNotDeliveredNumsSum(), detailEntity.getDeliveredNumsSum());
            BigDecimal deliveredNumsSum = MathUtil.safeAdd(materialOrderDetailEntity.getDeliveredNumsSum(), detailEntity.getDeliveredNumsSum());
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)detailEntity.getOrderDetailId());
            wrapper.set(MaterialOrderDetailEntity::getNotDeliveredNumsSum, (Object)notDeliveredNumsSum);
            wrapper.set(MaterialOrderDetailEntity::getDeliveredNumsSum, (Object)deliveredNumsSum);
            this.orderDetailService.update((Wrapper)wrapper);
        }
    }

    @Override
    public void backChangeDeliveryNums(List<MaterialDeliveryDetailEntity> deliveryDetailList) {
        for (MaterialDeliveryDetailEntity detailEntity : deliveryDetailList) {
            MaterialOrderDetailEntity materialOrderDetailEntity = (MaterialOrderDetailEntity)((Object)this.orderDetailService.selectById(detailEntity.getOrderDetailId()));
            BigDecimal notDeliveredNumsSum = MathUtil.safeAdd(materialOrderDetailEntity.getNotDeliveredNumsSum(), detailEntity.getDeliveredNumsSum());
            BigDecimal deliveredNumsSum = MathUtil.safeSub(materialOrderDetailEntity.getDeliveredNumsSum(), detailEntity.getDeliveredNumsSum());
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)detailEntity.getOrderDetailId());
            wrapper.set(MaterialOrderDetailEntity::getNotDeliveredNumsSum, (Object)notDeliveredNumsSum);
            wrapper.set(MaterialOrderDetailEntity::getDeliveredNumsSum, (Object)deliveredNumsSum);
            this.orderDetailService.update((Wrapper)wrapper);
        }
    }

    @Override
    public void submitChangeDeliveryState(Long orderId, List<MaterialDeliveryDetailEntity> detailEntities) {
        LambdaUpdateWrapper wrapper;
        Map collect = detailEntities.stream().collect(Collectors.toMap(MaterialDeliveryDetailEntity::getOrderDetailId, Function.identity(), (k1, k2) -> k2));
        MaterialOrderEntity materialOrderEntity = (MaterialOrderEntity)((Object)this.orderService.selectById(orderId));
        Boolean allDelivery = true;
        for (MaterialOrderDetailEntity materialOrderDetailEntity : materialOrderEntity.getOrderDetailList()) {
            BigDecimal deliveredNumsSum;
            BigDecimal bigDecimal = deliveredNumsSum = materialOrderDetailEntity.getDeliveredNumsSum() == null ? BigDecimal.ZERO : materialOrderDetailEntity.getDeliveredNumsSum();
            if (null != deliveredNumsSum && deliveredNumsSum.compareTo(materialOrderDetailEntity.getReceiveNumsSum()) != -1) continue;
            allDelivery = false;
        }
        if (allDelivery.booleanValue()) {
            wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)orderId);
            wrapper.set(MaterialOrderEntity::getDeliverState, (Object)"2");
            this.orderService.update((Wrapper)wrapper);
        } else {
            wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)orderId);
            wrapper.set(MaterialOrderEntity::getDeliverState, (Object)"3");
            this.orderService.update((Wrapper)wrapper);
        }
    }

    @Override
    public void backChangeDeliveryState(Long orderId, List<MaterialDeliveryDetailEntity> detailEntities) {
        LambdaUpdateWrapper wrapper;
        Map collect = detailEntities.stream().collect(Collectors.toMap(MaterialDeliveryDetailEntity::getOrderDetailId, Function.identity(), (k1, k2) -> k2));
        MaterialOrderEntity materialOrderEntity = (MaterialOrderEntity)((Object)this.orderService.selectById(orderId));
        Boolean waitDelivery = true;
        for (MaterialOrderDetailEntity materialOrderDetailEntity : materialOrderEntity.getOrderDetailList()) {
            BigDecimal deliveredNumsSum;
            BigDecimal bigDecimal = deliveredNumsSum = materialOrderDetailEntity.getDeliveredNumsSum() == null ? BigDecimal.ZERO : materialOrderDetailEntity.getDeliveredNumsSum();
            if (null != deliveredNumsSum && deliveredNumsSum.compareTo(BigDecimal.ZERO) != 1) continue;
            waitDelivery = false;
        }
        if (waitDelivery.booleanValue()) {
            wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)orderId);
            wrapper.set(MaterialOrderEntity::getDeliverState, (Object)"1");
            this.orderService.update((Wrapper)wrapper);
        } else {
            wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)orderId);
            wrapper.set(MaterialOrderEntity::getDeliverState, (Object)"3");
            this.orderService.update((Wrapper)wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String changeCloseState(MaterialDeliveryEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "BT220223000000005::" + entity.getId().toString() + "::sup";
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)OPERATE, (int)600);
            if (!locked) {
                this.releaseLock(jedis, false, key, OPERATE);
                String string = "\u5355\u636e\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01";
                return string;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("billId", entity.getId().toString());
            HashMap files = new HashMap();
            this.logger.info("\u53c2\u6570-{}\uff0c\u4f9b\u65b9-{}", (Object)JSONObject.toJSONString(params), (Object)entity.getSupplierId().toString());
            CommonResponse backResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(CHANGE_CLOSE_BILL_SERVER_URL, params, entity.getSupplierId().toString(), files);
            this.logger.error("\u5355\u636e-{}\u53d1\u9001\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)BILL_NAME, (Object)JSONObject.toJSONString((Object)backResp));
            if (!backResp.isSuccess()) {
                String string = "\u9001\u8d27\u5355\u6821\u9a8c\u5173\u95ed\u53d1\u9001\u8bf7\u6c42\u5931\u8d25";
                return string;
            }
            if (noPower.equals(backResp.getData())) {
                this.logger.error("\u53d1\u9001\u8bf7\u6c42URL-{}\u7ed9\u4f9b\u5e94\u5546-{}\u5931\u8d25, {}", new Object[]{CHANGE_CLOSE_BILL_SERVER_URL, entity.getSupplierId(), backResp.getData()});
                String string = (String)backResp.getData();
                return string;
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getId());
            updateWrapper.set(MaterialDeliveryEntity::getDisableState, (Object)"1");
            super.update((Wrapper)updateWrapper);
        }
        catch (Exception e) {
            msg = "\u64cd\u4f5c\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, OPERATE);
        }
        return msg;
    }
}

