package com.ejianc.business.assist.store.service.impl;

import com.ejianc.business.assist.store.bean.HandleDetailEntity;
import com.ejianc.business.assist.store.bean.HandleEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.mapper.HandleDetailMapper;
import com.ejianc.business.assist.store.mapper.HandleMapper;
import com.ejianc.business.assist.store.service.IHandleService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.util.StoreManageUtil;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 仓库材料处置表
 * 
 * @author generator
 * 
 */
@Service("handleService")
public class HandleServiceImpl extends BaseServiceImpl<HandleMapper, HandleEntity> implements IHandleService{

    @Autowired
    private HandleDetailMapper handleDetailMapper;

    @Autowired
    private StoreManageService storeManageService;

    @Override
    public CommonResponse saveCheckHandle(HandleEntity entity) {
        //更新子表信息
        if(null != entity.getId()) {
            handleDetailMapper.delByHandleId(entity.getId());
        }

        List<HandleDetailEntity> subList = new ArrayList<>();
        List<HandleDetailEntity> handleSubList = entity.getHandleSubList();
        // 设置主表分类名称
        String names = "";
        for (HandleDetailEntity detailEntity:handleSubList
             ) {
            if(detailEntity.getHandleNum() != null && detailEntity.getHandleNum().compareTo(BigDecimal.ZERO) > 0){
                subList.add(detailEntity);
            }
             names = names+detailEntity.getMaterialCategoryName()+",";
        }
        if(handleSubList.size() > 0){
            names = names.substring(0,names.length()-1);
        }
        entity.setMaterialTypes(names);
        super.saveOrUpdate(entity, false);

        if(subList.size() > 0){
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.材料处置);
            ArrayList<FlowVO> flowVOS = new ArrayList<>();
            subList.forEach(item->{
                FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.材料处置,0);
                flowVO.setStoreId(entity.getStoreId());
                flowVO.setStoreName(entity.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgCode(entity.getParentOrgCode());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setMaterialCategoryId(item.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(item.getMaterialCategoryName());
                flowVO.setMaterialId(item.getMaterialId());
                flowVO.setMaterialName(item.getMaterialName());
                flowVO.setMaterialSpec(item.getSpec());
                flowVO.setNum(item.getHandleNum());
                flowVO.setTaxPrice(item.getHandlePrice());
                flowVO.setTaxMny(item.getHandleMny());
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(item.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getHandleDate());
                flowVOS.add(flowVO);
            });
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setFlowVOList(flowVOS);
            CommonResponse<StoreManageVO> commonResponse = storeManageService.inOutStore(storeManageVO);
            if(!commonResponse.isSuccess()){
                return commonResponse;
            }
        }
        return CommonResponse.success(entity);
    }

    @Override
    public CommonResponse myRemoveByIds(List<Long> ids) {
        CommonResponse commonResponse = handleInOut(ids,false);
        if(!commonResponse.isSuccess()){
            return commonResponse;
        }
        super.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public CommonResponse handleInOut(List<Long> ids,Boolean outEffectiveON){
        StoreManageVO storeManageVO = new StoreManageVO();
        List<Long> SourceIds = new ArrayList<>();
        for (Long item:ids
        ) {
            HandleEntity entity = super.selectById(item);
            List<HandleDetailEntity> handleSubList = entity.getHandleSubList();
            Boolean checkFlag = false;
            for (HandleDetailEntity t:handleSubList
                 ) {
                if(t.getHandleNum().compareTo(BigDecimal.ZERO) > 0){
                    checkFlag = true;
                    break;
                }
            }
            if(checkFlag){
                SourceIds.clear();
                SourceIds.add(item);
                storeManageVO.setSourceId(item);
                storeManageVO.setStoreId(entity.getStoreId());
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.材料处置);
                storeManageVO.setSourceIdsForRollBack(SourceIds);
                storeManageVO.setOutEffectiveON(outEffectiveON);
                CommonResponse<StoreManageVO> commonResponse;
                if(outEffectiveON){
                    commonResponse = storeManageService.inOutStore(storeManageVO);
                }else{
                    commonResponse = storeManageService.inOutStoreRollback(storeManageVO);
                }
                if(!commonResponse.isSuccess()){
                    return commonResponse;
                }
            }
        }
        return CommonResponse.success();
    };
}
