/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.store.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.assist.store.bean.AllotInDetailEntity;
import com.ejianc.business.assist.store.bean.AllotInEntity;
import com.ejianc.business.assist.store.bean.AllotOutEntity;
import com.ejianc.business.assist.store.consts.AllocationState;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.consts.NoticeEnum;
import com.ejianc.business.assist.store.service.AllotInMessageService;
import com.ejianc.business.assist.store.service.IAllotInService;
import com.ejianc.business.assist.store.service.IAllotOutService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.vo.AllotInVO;
import com.ejianc.business.assist.store.vo.AllotOutVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="allotOut")
public class AllotOutBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAllotOutService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAllotInService allotInService;
    @Autowired
    private AllotInMessageService allotInMessageService;
    private static final String BILL_CODE = "STORE_ALLOT_IN";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    StoreManageService storeManageService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        block12: {
            Jedis jedis = this.jedisPool.getResource();
            boolean locked = false;
            locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(billId), (String)"generateAllotIn", (int)1000);
            this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
            try {
                if (locked) {
                    AllotOutEntity allotOutEntity = (AllotOutEntity)((Object)this.service.selectById(billId));
                    AllotOutVO allotoutvo = (AllotOutVO)BeanMapper.map((Object)((Object)allotOutEntity), AllotOutVO.class);
                    if (CollectionUtils.isNotEmpty(allotOutEntity.getAllotOutDetailList())) {
                        StoreManageVO storeManageVO = new StoreManageVO();
                        storeManageVO.setStoreId(allotOutEntity.getStoreId());
                        storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u8c03\u62e8\u51fa\u5e93);
                        storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
                        storeManageVO.setSourceId(allotOutEntity.getId());
                        this.storeManageService.inOutStore(storeManageVO);
                    }
                    if (!Objects.isNull((Object)allotOutEntity)) {
                        AllotInEntity allot;
                        LambdaUpdateWrapper allotOutWrapper = new LambdaUpdateWrapper();
                        allotOutWrapper.eq(BaseEntity::getId, (Object)billId);
                        allotOutWrapper.set(AllotOutEntity::getReceiveState, (Object)Integer.parseInt(AllocationState.TO_RECEIVING.getCode()));
                        allotOutWrapper.set(AllotOutEntity::getReturnReason, null);
                        allotOutWrapper.set(AllotOutEntity::getReceiverPersonId, null);
                        allotOutWrapper.set(AllotOutEntity::getReceiverPerson, null);
                        this.service.update((Wrapper)allotOutWrapper);
                        AllotInEntity allotInEntity = new AllotInEntity();
                        allotInEntity.setInUnitName(allotOutEntity.getInUnitName());
                        allotInEntity.setOutAllocaScope(allotOutEntity.getOutAllocaScope());
                        allotInEntity.setOutProjectId(allotOutEntity.getProjectId());
                        allotInEntity.setOutProjectName(allotOutEntity.getProjectName());
                        allotInEntity.setOutOrgId(allotOutEntity.getOrgId());
                        allotInEntity.setOutOrgName(allotOutEntity.getOrgName());
                        allotInEntity.setOutTaxMny(allotOutEntity.getOutTaxMny());
                        allotInEntity.setInAllocaScope(allotOutEntity.getInAllocaScope());
                        allotInEntity.setStoreId(allotOutEntity.getInStoreId());
                        allotInEntity.setStoreName(allotOutEntity.getInStoreName());
                        allotInEntity.setProjectId(allotOutEntity.getInProjectId());
                        allotInEntity.setProjectName(allotOutEntity.getInProjectName());
                        allotInEntity.setParentOrgId(allotOutEntity.getInParentOrgId());
                        allotInEntity.setParentOrgName(allotOutEntity.getInParentOrgName());
                        allotInEntity.setParentOrgCode(allotOutEntity.getInParentOrgCode());
                        allotInEntity.setOrgId(allotOutEntity.getInOrgId());
                        allotInEntity.setOrgName(allotOutEntity.getInOrgName());
                        allotInEntity.setAllotOutId(allotOutEntity.getId());
                        allotInEntity.setOutMny(allotOutEntity.getOutMny());
                        allotInEntity.setOutDate(allotOutEntity.getOutDate());
                        allotInEntity.setEmployeeId(allotOutEntity.getEmployeeId());
                        allotInEntity.setEmployeeName(allotOutEntity.getEmployeeName());
                        allotInEntity.setDepartmentId(allotOutEntity.getDepartmentId());
                        allotInEntity.setDepartmentName(allotOutEntity.getDepartmentName());
                        allotInEntity.setOutStoreId(allotOutEntity.getStoreId());
                        allotInEntity.setOutStoreName(allotOutEntity.getStoreName());
                        allotInEntity.setNotifyReceiverId(allotOutEntity.getReceiverId());
                        allotInEntity.setReceiverName(allotOutEntity.getReceiverName());
                        allotInEntity.setAllocatType(allotOutEntity.getAllocatType());
                        allotInEntity.setMemo(allotOutEntity.getMemo());
                        allotInEntity.setMaterialNames(allotOutEntity.getMaterialNames());
                        allotInEntity.setReceiveState(Integer.valueOf(AllocationState.TO_RECEIVING.getCode()));
                        long id = IdWorker.getId();
                        if (CollectionUtils.isNotEmpty(allotOutEntity.getAllotOutDetailList())) {
                            List allotInDetailEntitys = BeanMapper.mapList(allotOutEntity.getAllotOutDetailList(), AllotInDetailEntity.class);
                            allotInDetailEntitys.forEach(item -> {
                                item.setId(null);
                                item.setAllocatId(id);
                            });
                            allotInEntity.setAllotInDetailList(allotInDetailEntitys);
                            this.logger.info("\u5b50\u8868\u4fe1\u606f\uff1a" + allotInDetailEntitys.toString());
                        }
                        AllotInVO vo = (AllotInVO)BeanMapper.map((Object)((Object)allotInEntity), AllotInVO.class);
                        BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)vo);
                        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                        if (!billCode.isSuccess()) {
                            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                        }
                        allotInEntity.setBillCode((String)billCode.getData());
                        allotInEntity.setId(id);
                        boolean b = this.allotInService.saveOrUpdate((Object)allotInEntity, false);
                        if (b && (allot = (AllotInEntity)((Object)this.allotInService.selectById(Long.valueOf(id)))) != null && allot.getNotifyReceiverId() != null) {
                            String[] notifyReceive = new String[]{String.valueOf(allot.getNotifyReceiverId())};
                            this.allotInMessageService.sendMsg(allot, notifyReceive, NoticeEnum.ALLOTIN_ENROLL);
                        }
                    }
                    this.logger.info("\u5468\u8f6c\u6750\u91c7\u8d2d\u8c03\u62e8\u51fa\u5e93\u5ba1\u6279\u901a\u8fc7try\u65b9\u6cd5");
                    break block12;
                }
                CommonResponse allotOutEntity = CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                return allotOutEntity;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (locked) {
                    RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(billId), (String)"generateAllotIn");
                }
                jedis.close();
                this.logger.info("\u5468\u8f6c\u6750\u91c7\u8d2d\u8c03\u62e8\u51fa\u5e93\u5ba1\u6279\u901a\u8fc7finally\u65b9\u6cd5");
            }
        }
        this.logger.info("\u5468\u8f6c\u6750\u91c7\u8d2d\u8c03\u62e8\u51fa\u5e93\u5ba1\u6279\u901a\u8fc7------billTypeCode-{},state-{}", (Object)billTypeCode, (Object)state);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        AllotOutEntity entity = (AllotOutEntity)((Object)this.service.selectById(billId));
        if (BillStateEnum.COMMITED_STATE.getBillStateCode() == entity.getBillState() || BillStateEnum.PASSED_STATE.getBillStateCode() == entity.getBillState()) {
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u5df2\u63a8\u9001\u7ed9\u8c03\u5165\u65b9\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

