package com.ejianc.business.assist.store.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 仓库出入库关系表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_assiststore_in_out")
public class InOutEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="in_project_id")
    private Long inProjectId; // 项目ID
    @TableField(value="in_project_name")
    private String inProjectName; // 项目名称
    @TableField(value="in_store_id")
    private Long inStoreId; // 仓库
    @TableField(value="in_store_name")
    private String inStoreName; // 仓库名称
    @TableField(value="material_type")
    private String materialType; // 材料类型编码
    @TableField(value="material_type_name")
    private String materialTypeName; // 材料类型名称
    @TableField(value="out_project_id")
    private Long outProjectId; // 项目ID
    @TableField(value="out_project_name")
    private String outProjectName; // 项目名称
    @TableField(value="out_store_id")
    private Long outStoreId; // 仓库
    @TableField(value="out_store_name")
    private String outStoreName; // 仓库名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="out_date")
    private Date outDate; // 出库日期
    @TableField(value="in_out_type")
    private Integer inOutType; // 出入库类型:收料入库等
    @TableField(value="in_out_type_name")
    private String inOutTypeName; // 出入库类型名称
    @TableField(value="in_bill_id")
    private Long inBillId; // 入库单据id
    @TableField(value="in_bill_code")
    private String inBillCode; // 入库单据编码
    @TableField(value="out_bill_id")
    private Long outBillId; // 出库单据id
    @TableField(value="out_bill_code")
    private String outBillCode; // 出库单据编码
    @TableField(value="material_category_id")
    private Long materialCategoryId; // 物资分类id
    @TableField(value="material_category_code")
    private String materialCategoryCode; // 物资分类编码
    @TableField(value="material_category_name")
    private String materialCategoryName; // 物资分类名称
    @TableField(value="material_id")
    private Long materialId; // 物资id
    @TableField(value="material_code")
    private String materialCode; // 物资编码
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="material_spec")
    private String materialSpec; // 规格型号
    @TableField(value="material_unit_id")
    private Long materialUnitId; // 计量单位id
    @TableField(value="material_unit_name")
    private String materialUnitName; // 计量单位
    @TableField(value="price")
    private BigDecimal price; // 单价(无税)
    @TableField(value="tax_price")
    private BigDecimal taxPrice; // 单价
    @TableField(value="num")
    private BigDecimal num; // 数量
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 金额含税
    @TableField(value="mny")
    private BigDecimal mny; // 金额(无税)
    @TableField(value="tax")
    private BigDecimal tax; // 税额
    @TableField(value="pick_unit_id")
    private Long pickUnitId; // 领料单位id
    @TableField(value="pick_unit_name")
    private String pickUnitName; // 领料单位
    @TableField(value="pick_contract_id")
    private Long pickContractId; // 领料合同id
    @TableField(value="pick_contract_name")
    private String pickContractName; // 领料合同
    @TableField(value="out_num")
    private BigDecimal outNum; // 出库数量
    @TableField(value="out_lock_num")
    private BigDecimal outLockNum; // 出库占用数量
    @TableField(value="return_store_num")
    private BigDecimal returnStoreNum; // 退库数量
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效时间
    @TableField(value="effective_state")
    private Integer effectiveState; // 生效状态0自由1已生效
    @TableField(value="out_use_flag")
    private Integer outUseFlag; // 针对入库出库使用状态0无需出库1可以出库2出库占用中3出库完成
    @TableField(value="in_flow_id")
    private Long inFlowId; // 入库流水ID
    @TableField(value="out_flow_id")
    private Long outFlowId; // 出库流水ID
    @TableField(value="in_bill_detail_id")
    private Long inBillDetailId; // 入库单据明细id
    @TableField(value="out_bill_detail_id")
    private Long outBillDetailId; // 出库单据明细id

    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率

    @TableField(value="out_net_mny")
    private BigDecimal outNetMny; //出库净值
    @TableField(value="out_net_tax_mny")
    private BigDecimal outNetTaxMny;

    public BigDecimal getOutNetMny() {
        return outNetMny;
    }

    public void setOutNetMny(BigDecimal outNetMny) {
        this.outNetMny = outNetMny;
    }

    public BigDecimal getOutNetTaxMny() {
        return outNetTaxMny;
    }

    public void setOutNetTaxMny(BigDecimal outNetTaxMny) {
        this.outNetTaxMny = outNetTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    

    public Long getInProjectId() {
        return inProjectId;
    }

    public void setInProjectId(Long inProjectId) {
        this.inProjectId = inProjectId;
    }
    public String getInProjectName() {
        return inProjectName;
    }

    public void setInProjectName(String inProjectName) {
        this.inProjectName = inProjectName;
    }
    public Long getInStoreId() {
        return inStoreId;
    }

    public void setInStoreId(Long inStoreId) {
        this.inStoreId = inStoreId;
    }
    public String getInStoreName() {
        return inStoreName;
    }

    public void setInStoreName(String inStoreName) {
        this.inStoreName = inStoreName;
    }
    public String getMaterialType() {
        return materialType;
    }

    public void setMaterialType(String materialType) {
        this.materialType = materialType;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Long getOutProjectId() {
        return outProjectId;
    }

    public void setOutProjectId(Long outProjectId) {
        this.outProjectId = outProjectId;
    }
    public String getOutProjectName() {
        return outProjectName;
    }

    public void setOutProjectName(String outProjectName) {
        this.outProjectName = outProjectName;
    }
    public Long getOutStoreId() {
        return outStoreId;
    }

    public void setOutStoreId(Long outStoreId) {
        this.outStoreId = outStoreId;
    }
    public String getOutStoreName() {
        return outStoreName;
    }

    public void setOutStoreName(String outStoreName) {
        this.outStoreName = outStoreName;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    public Integer getInOutType() {
        return inOutType;
    }

    public void setInOutType(Integer inOutType) {
        this.inOutType = inOutType;
    }
    public String getInOutTypeName() {
        return inOutTypeName;
    }

    public void setInOutTypeName(String inOutTypeName) {
        this.inOutTypeName = inOutTypeName;
    }
    public Long getInBillId() {
        return inBillId;
    }

    public void setInBillId(Long inBillId) {
        this.inBillId = inBillId;
    }
    public String getInBillCode() {
        return inBillCode;
    }

    public void setInBillCode(String inBillCode) {
        this.inBillCode = inBillCode;
    }
    public Long getOutBillId() {
        return outBillId;
    }

    public void setOutBillId(Long outBillId) {
        this.outBillId = outBillId;
    }
    public String getOutBillCode() {
        return outBillCode;
    }

    public void setOutBillCode(String outBillCode) {
        this.outBillCode = outBillCode;
    }
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    public String getMaterialCategoryCode() {
        return materialCategoryCode;
    }

    public void setMaterialCategoryCode(String materialCategoryCode) {
        this.materialCategoryCode = materialCategoryCode;
    }
    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getMaterialSpec() {
        return materialSpec;
    }

    public void setMaterialSpec(String materialSpec) {
        this.materialSpec = materialSpec;
    }
    public Long getMaterialUnitId() {
        return materialUnitId;
    }

    public void setMaterialUnitId(Long materialUnitId) {
        this.materialUnitId = materialUnitId;
    }
    public String getMaterialUnitName() {
        return materialUnitName;
    }

    public void setMaterialUnitName(String materialUnitName) {
        this.materialUnitName = materialUnitName;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    public Long getPickUnitId() {
        return pickUnitId;
    }

    public void setPickUnitId(Long pickUnitId) {
        this.pickUnitId = pickUnitId;
    }
    public String getPickUnitName() {
        return pickUnitName;
    }

    public void setPickUnitName(String pickUnitName) {
        this.pickUnitName = pickUnitName;
    }
    public Long getPickContractId() {
        return pickContractId;
    }

    public void setPickContractId(Long pickContractId) {
        this.pickContractId = pickContractId;
    }
    public String getPickContractName() {
        return pickContractName;
    }

    public void setPickContractName(String pickContractName) {
        this.pickContractName = pickContractName;
    }
    public BigDecimal getOutNum() {
        return outNum;
    }

    public void setOutNum(BigDecimal outNum) {
        this.outNum = outNum;
    }
    public BigDecimal getOutLockNum() {
        return outLockNum;
    }

    public void setOutLockNum(BigDecimal outLockNum) {
        this.outLockNum = outLockNum;
    }
    public BigDecimal getReturnStoreNum() {
        return returnStoreNum;
    }

    public void setReturnStoreNum(BigDecimal returnStoreNum) {
        this.returnStoreNum = returnStoreNum;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Integer getEffectiveState() {
        return effectiveState;
    }

    public void setEffectiveState(Integer effectiveState) {
        this.effectiveState = effectiveState;
    }
    public Integer getOutUseFlag() {
        return outUseFlag;
    }

    public void setOutUseFlag(Integer outUseFlag) {
        this.outUseFlag = outUseFlag;
    }
    public Long getInFlowId() {
        return inFlowId;
    }

    public void setInFlowId(Long inFlowId) {
        this.inFlowId = inFlowId;
    }
    public Long getOutFlowId() {
        return outFlowId;
    }

    public void setOutFlowId(Long outFlowId) {
        this.outFlowId = outFlowId;
    }
    public Long getInBillDetailId() {
        return inBillDetailId;
    }

    public void setInBillDetailId(Long inBillDetailId) {
        this.inBillDetailId = inBillDetailId;
    }
    public Long getOutBillDetailId() {
        return outBillDetailId;
    }

    public void setOutBillDetailId(Long outBillDetailId) {
        this.outBillDetailId = outBillDetailId;
    }
    
}
