/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.material.bean.MaterialCheckDetailEntity;
import com.ejianc.business.assist.material.bean.MaterialCheckEntity;
import com.ejianc.business.assist.material.bean.MaterialDeliveryEntity;
import com.ejianc.business.assist.material.service.IMaterialCheckService;
import com.ejianc.business.assist.material.service.IMaterialDeliveryService;
import com.ejianc.business.assist.store.api.IStoreManageApi;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.util.StoreManageUtil;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialCheck")
public class MaterialCheckBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMaterialCheckService service;
    @Autowired
    private IMaterialDeliveryService deliveryService;
    @Autowired
    private IStoreManageApi storeManageApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        MaterialDeliveryEntity materialDeliveryEntity;
        MaterialCheckEntity materialCheckEntity = (MaterialCheckEntity)((Object)this.service.selectById(billId));
        if ("1".equals(materialCheckEntity.getCheckSource()) && null != (materialDeliveryEntity = (MaterialDeliveryEntity)((Object)this.deliveryService.selectById(materialCheckEntity.getDeliveryId()))).getDisableState() && "1".equals(materialDeliveryEntity.getDisableState())) {
            return CommonResponse.error((String)"\u5f85\u9a8c\u6536\u5355\u5df2\u7ecf\u5173\u95ed\uff0c\u5f53\u524d\u5355\u636e\u65e0\u6cd5\u63d0\u4ea4\u3002");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        MaterialCheckEntity materialCheckEntity = (MaterialCheckEntity)((Object)this.service.selectById(billId));
        if ("0".equals(materialCheckEntity.getCheckType())) {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6536\u6599\u5165\u5e93);
            storeManageVO.setStoreId(materialCheckEntity.getStoreId());
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            storeManageVO.setSourceId(materialCheckEntity.getId());
            ArrayList flowVOS = new ArrayList();
            materialCheckEntity.getCheckDetailList().forEach(t -> {
                FlowVO flowVO = new FlowVO();
                flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u6536\u6599\u5165\u5e93, (Integer)0);
                this.getFlow(materialCheckEntity, (MaterialCheckDetailEntity)((Object)t), flowVO);
                flowVOS.add(flowVO);
            });
            storeManageVO.setFlowVOList(flowVOS);
            String stringInfo = JSONObject.toJSONString((Object)storeManageVO);
            this.logger.info("\u6d88\u8017\u6750\u9a8c\u6536\u5165\u5e93\u53c2\u6570\uff1a" + stringInfo);
            CommonResponse response = this.storeManageApi.inOutStore(storeManageVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f" + response.getMsg());
            }
        }
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u6210\u529f\uff01");
    }

    private void getFlow(MaterialCheckEntity checkEntity, MaterialCheckDetailEntity t, FlowVO flowVO) {
        flowVO.setProjectId(checkEntity.getProjectId());
        flowVO.setTaxRate(t.getTaxRate());
        flowVO.setProjectName(checkEntity.getProjectName());
        flowVO.setParentOrgId(checkEntity.getParentOrgId());
        flowVO.setParentOrgName(checkEntity.getParentOrgName());
        flowVO.setOrgId(checkEntity.getOrgId());
        flowVO.setOrgName(checkEntity.getOrgName());
        flowVO.setStoreId(checkEntity.getStoreId());
        flowVO.setStoreName(checkEntity.getStoreName());
        flowVO.setEmployeeId(checkEntity.getEmployeeId());
        flowVO.setEmployeeName(checkEntity.getEmployeeName());
        flowVO.setMaterialType(checkEntity.getCheckType());
        flowVO.setMaterialTypeName(checkEntity.getCheckType());
        flowVO.setSupplierId(checkEntity.getSupplierId());
        flowVO.setSupplierName(checkEntity.getSupplierName());
        flowVO.setPurchaseContractId(checkEntity.getContractId());
        flowVO.setPurchaseContractName(checkEntity.getContractName());
        flowVO.setMaterialCategoryId(t.getMaterialTypeId());
        flowVO.setMaterialCategoryName(t.getMaterialTypeName());
        flowVO.setMaterialId(t.getMaterialId());
        flowVO.setMaterialName(t.getMaterialName());
        flowVO.setMaterialCode(t.getMaterialCode());
        flowVO.setMaterialSpec(t.getSpec());
        flowVO.setMaterialUnitId(t.getUnitId());
        flowVO.setMaterialUnitName(t.getUnitName());
        flowVO.setTaxPrice(t.getUnitTaxPrice());
        flowVO.setPrice(t.getUnitPrice());
        flowVO.setNum(t.getCheckNumsSum());
        flowVO.setTaxMny(t.getTaxMny());
        flowVO.setMny(t.getMny());
        flowVO.setTax(t.getTaxMny());
        flowVO.setPickUnitId(checkEntity.getSupplierId());
        flowVO.setPickUnitName(checkEntity.getSupplierName());
        flowVO.setPickContractId(checkEntity.getContractId());
        flowVO.setPickContractName(checkEntity.getContractName());
        flowVO.setSourceId(checkEntity.getId());
        flowVO.setSourceDetailId(t.getId());
        flowVO.setSourceBillCode(checkEntity.getBillCode());
        flowVO.setSourceBillDate(checkEntity.getCheckDate());
        flowVO.setSourceBillRemark(checkEntity.getMemo());
        flowVO.setSourceBillDetailRemark(t.getMemo());
        flowVO.setRowState(t.getRowState());
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        MaterialCheckEntity entity = (MaterialCheckEntity)((Object)this.service.selectById(billId));
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)res.getMsg());
        }
        return CommonResponse.success((String)"\u5f03\u5ba1\u524d\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

