/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.assist.material.bean.OwnDetailEntity;
import com.ejianc.business.assist.material.bean.OwnEntity;
import com.ejianc.business.assist.material.mapper.OwnMapper;
import com.ejianc.business.assist.material.service.IOwnDetailService;
import com.ejianc.business.assist.material.service.IOwnService;
import com.ejianc.business.assist.material.vo.OwnDetailVO;
import com.ejianc.business.assist.material.vo.OwnVO;
import com.ejianc.business.assist.rmat.utils.DateUtil;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.service.IAllotOutService;
import com.ejianc.business.assist.store.service.IFlowService;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.pro.ownrmat.api.IAmortizationApi;
import com.ejianc.business.pro.ownrmat.vo.AmortizationVO;
import com.ejianc.business.pro.ownrmat.vo.ResidualVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ownService")
public class OwnServiceImpl
extends BaseServiceImpl<OwnMapper, OwnEntity>
implements IOwnService {
    private static final String BILL_CODE = "ASSIST_MATERIAL_OWN";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOwnDetailService ownDetailService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAmortizationApi amortizationApi;
    @Autowired
    private IAllotOutService allotOutService;
    @Autowired
    IFlowService flowService;

    @Override
    public OwnVO saveOrUpdate(OwnVO saveorUpdateVO) {
        List detailEntityList;
        Long tenantId = InvocationInfoProxy.getTenantid();
        OwnEntity entity = null;
        String operateType = null;
        LambdaQueryWrapper lambd = new LambdaQueryWrapper();
        lambd.eq(OwnEntity::getOrgId, (Object)saveorUpdateVO.getOrgId());
        lambd.notIn(OwnEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            entity = (OwnEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OwnEntity.class));
            operateType = "edit";
            lambd.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
        } else {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)tenantId, (BaseVO)saveorUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity = (OwnEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OwnEntity.class));
            operateType = "add";
        }
        List list = super.list((Wrapper)lambd);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u4e0a\u4e0b\u6587\u7ec4\u7ec7\u6709\u672a\u751f\u6548\u7684\u644a\u9500\u5355\uff0c\u4e0d\u80fd\u65b0\u589e\u644a\u9500\u5355");
        }
        List detailList = saveorUpdateVO.getOwnDetailList();
        String categoryName = "";
        ArrayList<String> nameList = new ArrayList<String>();
        for (OwnDetailVO detailVO : detailList) {
            if (nameList.contains(detailVO.getMaterialTypeName())) continue;
            categoryName = categoryName.length() > 0 ? categoryName + "," + detailVO.getMaterialTypeName() : detailVO.getMaterialTypeName();
            nameList.add(detailVO.getMaterialTypeName());
            if (categoryName.length() <= 100) continue;
            break;
        }
        entity.setCategoryName(categoryName);
        super.saveOrUpdate((Object)entity);
        if ("edit".equals(operateType)) {
            ((OwnMapper)this.baseMapper).delByBatchId(entity.getId());
        }
        if ((detailEntityList = BeanMapper.mapList((Iterable)detailList, OwnDetailEntity.class)).size() > 0) {
            for (OwnDetailEntity detailEntity : detailEntityList) {
                detailEntity.setOwnId(entity.getId());
            }
            this.ownDetailService.saveOrUpdateBatch(detailEntityList, detailEntityList.size(), false);
        }
        return this.queryDetail(entity.getId());
    }

    @Override
    public String validateTime(OwnVO startVO, String type) {
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public OwnVO queryDetail(Long id) {
        OwnEntity batchPlanEntity = (OwnEntity)((Object)super.selectById((Serializable)id));
        OwnVO vo = (OwnVO)BeanMapper.map((Object)((Object)batchPlanEntity), OwnVO.class);
        return vo;
    }

    @Override
    public List<OwnDetailVO> refAmortizationList(QueryParam param, Long orgId, String amortizationCycle) {
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        ArrayList<Integer> inOutType = new ArrayList<Integer>();
        inOutType.add(InOutTypeEnum.\u5468\u8f6c\u6750\u6536\u6599\u5165\u5e93.getInOutType());
        inOutType.add(InOutTypeEnum.\u5468\u8f6c\u6750\u8c03\u62e8\u5165\u5e93.getInOutType());
        inOutType.add(InOutTypeEnum.\u539f\u6750\u6599\u52a0\u5de5\u5165\u5e93.getInOutType());
        inOutType.add(InOutTypeEnum.\u5176\u4ed6\u5165\u5e93.getInOutType());
        param.getParams().put("inOutType", new Parameter("in", inOutType));
        param.getParams().put("inOutFlag", new Parameter("eq", (Object)InOutTypeEnum.\u5468\u8f6c\u6750\u6536\u6599\u5165\u5e93.getInOutFlag()));
        List flowEntityList = this.flowService.queryList(param);
        List flowList = BeanMapper.mapList((Iterable)flowEntityList, FlowVO.class);
        ArrayList<OwnDetailVO> res = new ArrayList<OwnDetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        ArrayList<Long> materialIds = new ArrayList<Long>();
        for (FlowVO vo : flowList) {
            BigDecimal num = ComputeUtil.safeAdd((BigDecimal)vo.getOutLockNum(), (BigDecimal)vo.getSurplusNum());
            if (num == null) {
                num = BigDecimal.ZERO;
            }
            if (num.compareTo(BigDecimal.ZERO) <= 0 || vo.getNetTaxMny() == null || vo.getNetTaxMny().compareTo(BigDecimal.ZERO) <= 0 || (vo.getLastShareDate() != null || DateUtil.compareDateStr((String)amortizationCycle, (String)sdf.format(vo.getSourceBillDate())) < 0) && (vo.getLastShareDate() == null || DateUtil.compareDateStr((String)amortizationCycle, (String)sdf.format(vo.getLastShareDate())) <= 0)) continue;
            BigDecimal purchasePrice = vo.getPurchasePrice() == null ? BigDecimal.ZERO : vo.getPurchasePrice();
            BigDecimal purchaseTaxPrice = vo.getPurchaseTaxPrice() == null ? BigDecimal.ZERO : vo.getPurchaseTaxPrice();
            OwnDetailVO detailVO = new OwnDetailVO();
            detailVO.setId(vo.getId());
            detailVO.setSourceCode(vo.getSourceBillCode());
            detailVO.setMaterialTypeId(vo.getMaterialCategoryId());
            detailVO.setMaterialTypeCode(vo.getMaterialCategoryCode());
            detailVO.setMaterialTypeName(vo.getMaterialCategoryName());
            detailVO.setMaterialId(vo.getMaterialId());
            detailVO.setMaterialCode(vo.getMaterialCode());
            detailVO.setMaterialName(vo.getMaterialName());
            detailVO.setSpec(vo.getMaterialSpec());
            detailVO.setUnitId(vo.getMaterialUnitId());
            detailVO.setUnit(vo.getMaterialUnitName());
            detailVO.setOriginalValue(ComputeUtil.safeMultiply((BigDecimal)num, (BigDecimal)purchasePrice));
            detailVO.setOriginalValueTax(ComputeUtil.safeMultiply((BigDecimal)num, (BigDecimal)purchaseTaxPrice));
            detailVO.setNetWorth(vo.getNetMny() == null ? BigDecimal.ZERO : vo.getNetMny());
            detailVO.setNetWorthTax(vo.getNetTaxMny() == null ? BigDecimal.ZERO : vo.getNetTaxMny());
            detailVO.setResidualValue(null);
            detailVO.setResidualValueTax(null);
            detailVO.setOriginalValuePrice(purchasePrice);
            detailVO.setOriginalValuePriceTax(purchaseTaxPrice);
            BigDecimal taxRate = ComputeUtil.safeSub((BigDecimal)ComputeUtil.safeDiv((BigDecimal)detailVO.getOriginalValueTax(), (BigDecimal)detailVO.getOriginalValue()), (BigDecimal)BigDecimal.ONE);
            taxRate = taxRate.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : ComputeUtil.safeMultiply((BigDecimal)taxRate, (BigDecimal)new BigDecimal(100));
            detailVO.setTaxRate(taxRate);
            detailVO.setNum(num);
            detailVO.setLastAmortizationCycle(vo.getLastShareDate() == null ? null : sdf.format(vo.getLastShareDate()));
            detailVO.setAmortizationRate(null);
            detailVO.setAmortizationMny(null);
            detailVO.setAmortizationMnyTax(null);
            detailVO.setMemo(vo.getSourceBillDetailRemark());
            detailVO.setSourceId(vo.getId());
            int amortizationNum = 0;
            int usedAmortizationNum = 0;
            if (vo.getLastShareDate() != null) {
                amortizationNum = DateUtil.subMonth((String)sdf.format(vo.getLastShareDate()), (String)amortizationCycle, (SimpleDateFormat)sdf);
                usedAmortizationNum = DateUtil.subMonth((String)sdf.format(vo.getSourceBillDate()), (String)sdf.format(vo.getLastShareDate()), (SimpleDateFormat)sdf) + 1;
            } else {
                amortizationNum = DateUtil.subMonth((String)sdf.format(vo.getSourceBillDate()), (String)amortizationCycle, (SimpleDateFormat)sdf) + 1;
            }
            detailVO.setAmortizationNum(Integer.valueOf(amortizationNum));
            detailVO.setUsedAmortizationNum(Integer.valueOf(usedAmortizationNum));
            detailVO.setFlowSourceId(vo.getSourceId());
            detailVO.setFlowSourceDetailId(vo.getSourceDetailId());
            res.add(detailVO);
            materialIds.add(vo.getMaterialId());
        }
        if (res.size() > 0) {
            ResidualVO vo = new ResidualVO();
            vo.setOrgId(orgId);
            vo.setMaterialIds(materialIds);
            CommonResponse residualCom = this.amortizationApi.getResidualRate(vo);
            Map residualRate = new HashMap();
            if (!residualCom.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u6b8b\u503c\u7387\u5931\u8d25\uff01");
            }
            residualRate = (Map)residualCom.getData();
            if (residualRate.size() > 0) {
                for (OwnDetailVO detailVO : res) {
                    if (residualRate.containsKey(detailVO.getMaterialId())) {
                        detailVO.setUsePeriod(((AmortizationVO)residualRate.get(detailVO.getMaterialId())).getUsePeriod());
                        detailVO.setResidualValueRate(((AmortizationVO)residualRate.get(detailVO.getMaterialId())).getResidualValueRate());
                        detailVO.setResidualValue(ComputeUtil.safeMultiply((BigDecimal)detailVO.getOriginalValue(), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)detailVO.getResidualValueRate(), (BigDecimal)new BigDecimal(100))));
                        detailVO.setResidualValueTax(ComputeUtil.safeMultiply((BigDecimal)detailVO.getOriginalValueTax(), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)detailVO.getResidualValueRate(), (BigDecimal)new BigDecimal(100))));
                        continue;
                    }
                    detailVO.setResidualValue(BigDecimal.ZERO);
                    detailVO.setResidualValueTax(BigDecimal.ZERO);
                }
            }
        }
        return res;
    }

    @Override
    public String getLastAmortizationCycle(Long orgId, Long id) {
        String lastAmortizationCycle = ((OwnMapper)this.baseMapper).getLastAmortizationCycle(orgId, id);
        return lastAmortizationCycle;
    }
}

