package com.ejianc.business.assist.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.assist.material.bean.MaterialCheckDetailEntity;
import com.ejianc.business.assist.material.bean.MaterialCheckEntity;
import com.ejianc.business.assist.material.bean.MaterialDeliveryDetailEntity;
import com.ejianc.business.assist.material.bean.MaterialDeliveryEntity;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.enums.SupplierSignStatusEnum;
import com.ejianc.business.assist.material.mapper.MaterialCheckMapper;
import com.ejianc.business.assist.material.service.*;
import com.ejianc.business.assist.rmat.utils.MaterialConstant;
import com.ejianc.business.assist.rmat.utils.PushSupUtil;
import com.ejianc.business.assist.material.vo.MaterialCheckDetailVO;
import com.ejianc.business.assist.material.vo.MaterialCheckVO;
import com.ejianc.business.common.CommonConstant;
import com.ejianc.business.common.util.MathUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 验收单
 * 
 * @author generator
 * 
 */
@Service("materialCheckService")
public class MaterialCheckServiceImpl extends BaseServiceImpl<MaterialCheckMapper, MaterialCheckEntity> implements IMaterialCheckService {

    private static final String BILL_CODE = "MATERIAL_CHECK";//此处需要根据实际修改

    private static final String OPERATE = "CHECK_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.验收单.getCode();
    private static final String BILL_NAME = BillTypeEnum.验收单.getName();

    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistmaterial/check/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistmaterial/check/billDel";

    @Autowired
    private PushSupUtil pushSupUtil;

    @Autowired
    private IMaterialDeliveryDetailService deliveryDetailService;

    @Autowired
    private IMaterialCheckDetailService checkDetailService;

    @Autowired
    private IMaterialDeliveryService deliveryService;

    @Autowired
    private IBillCodeApi billCodeApi;

    /*@Autowired
    private IMaterialService materialService;


    @Autowired
    private IRmatFlowService flowService;*/

    @Override
    @Transactional
    public MaterialCheckVO saveOrUpdate(MaterialCheckVO saveOrUpdateVO) {

        //materialService.validateCheckDetail(saveOrUpdateVO);

        // 同一个合同只能存在一个自由态或审批中的单据
        //materialService.validateContract(saveOrUpdateVO.getContractId(), BILL_NAME, saveOrUpdateVO.getId(), MaterialConstant.保存);
        // 校验必须大于最大单据日期
        //this.validateTime(saveOrUpdateVO, MaterialConstant.保存);


        MaterialCheckEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialCheckEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            //保存单据制单人Id
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
        }
        if (null == entity.getSupplierSignStatus()){
            entity.setSupplierSignStatus(SupplierSignStatusEnum.乙方未签字.getCode());
        }
        super.saveOrUpdate(entity, false);


        //回写发货单数据
        if (CommonConstant.CHECK_SOURCE_YS.equals(entity.getCheckSource())) {
            String checkStatus = CommonConstant.DELIVERY_ACCEPTANCE_WAIT;
            MaterialDeliveryEntity materialDeliveryEntity = deliveryService.selectById(entity.getDeliveryId());
            //查询出所有的验收单详情,算出验收数据
            LambdaQueryWrapper<MaterialCheckDetailEntity> lambdaCheckDetail = Wrappers.<MaterialCheckDetailEntity>lambdaQuery();
            lambdaCheckDetail.eq(MaterialCheckDetailEntity::getDeliveryId,entity.getDeliveryId());
            List<MaterialCheckDetailEntity> materialCheckDetailEntityList = checkDetailService.list(lambdaCheckDetail);
            if(CollectionUtils.isNotEmpty(materialCheckDetailEntityList)){
                Map<Long, List<MaterialCheckDetailEntity>> checkMap = materialCheckDetailEntityList.stream().collect(Collectors.groupingBy(MaterialCheckDetailEntity::getDeliveryDetailId));
                LambdaQueryWrapper<MaterialDeliveryDetailEntity> lambdaDeliveryDetail = Wrappers.<MaterialDeliveryDetailEntity>lambdaQuery();
                lambdaDeliveryDetail.eq(MaterialDeliveryDetailEntity::getDeliveryId,entity.getDeliveryId());
                List<MaterialDeliveryDetailEntity> materialDeliveryDetailEntityList = deliveryDetailService.list(lambdaDeliveryDetail);

                for (MaterialDeliveryDetailEntity materialDeliveryDetailEntity : materialDeliveryDetailEntityList){
                    List<MaterialCheckDetailEntity> checkAllDetailEntityList = checkMap.get(materialDeliveryDetailEntity.getId());
                    if (CollectionUtils.isNotEmpty(checkAllDetailEntityList)){
                        BigDecimal checkNum = checkAllDetailEntityList.stream().map(MaterialCheckDetailEntity::getCheckNumsSum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        materialDeliveryDetailEntity.setCheckNumsSum(checkNum);
                    }
                    if (null == materialDeliveryDetailEntity.getCheckNumsSum()){
                        materialDeliveryDetailEntity.setCheckNumsSum(BigDecimal.ZERO);
                    }
                }
                //判断发货单的验收状态
                Boolean allCheck = materialDeliveryDetailEntityList.stream().allMatch(e -> e.getCheckNumsSum().compareTo(e.getDeliveredNumsSum()) > -1);
                Boolean anyCheck = materialDeliveryDetailEntityList.stream().anyMatch(e -> (e.getCheckNumsSum().compareTo(BigDecimal.ZERO) == 1) &&
                        (e.getCheckNumsSum().compareTo(e.getDeliveredNumsSum()) == -1));

                if (allCheck){
                    checkStatus = CommonConstant.DELIVERY_ACCEPTANCE_ALL;
                }
                if (anyCheck){
                    checkStatus = CommonConstant.DELIVERY_ACCEPTANCE_PART;
                }
                //推送供方改状态
                materialDeliveryEntity.setAcceptanceState(checkStatus);
                //更新发货验收状态和验收数量
                String msg = deliveryService.updateBillConfirmState(materialDeliveryEntity);
                if (null!=msg){
                    throw new BusinessException("推送失败");
                }
                deliveryDetailService.updateBatchById(materialDeliveryDetailEntityList);
            }
        }
        MaterialCheckVO vo = BeanMapper.map(entity, MaterialCheckVO.class);
        return vo;
    }


    @Override
    public void delete(List<MaterialCheckVO> vos) {
        //删除回写逻辑, 回写发货单子表数据
        if (vos.size() > 1){
            throw new BusinessException("验收单不允许批量删除!");
        }
        MaterialCheckVO materialCheckVO = vos.get(0);

        MaterialCheckEntity materialCheckEntity = super.selectById(materialCheckVO.getId());

        if (CommonConstant.CHECK_SOURCE_YS.equals(materialCheckEntity.getCheckSource())){
            List<MaterialCheckDetailEntity> checkDetailList = materialCheckEntity.getCheckDetailList();
            MaterialDeliveryEntity materialDeliveryEntity = deliveryService.selectById(materialCheckEntity.getDeliveryId());
            List<MaterialDeliveryDetailEntity> deliveryDetailList = materialDeliveryEntity.getDeliveryDetailList();
            Map<Long, MaterialCheckDetailEntity> checkDetailEntityMap = checkDetailList.stream().collect(Collectors.toMap(MaterialCheckDetailEntity::getDeliveryDetailId, Function.identity()));
            for (MaterialDeliveryDetailEntity materialDeliveryDetailEntity : deliveryDetailList){
                if(checkDetailEntityMap.containsKey(materialDeliveryDetailEntity.getId())){
                    MaterialCheckDetailEntity materialCheckDetailEntity = checkDetailEntityMap.get(materialDeliveryDetailEntity.getId());
                    materialDeliveryDetailEntity.setCheckNumsSum(MathUtil.safeSub(materialDeliveryDetailEntity.getCheckNumsSum(), materialCheckDetailEntity.getCheckNumsSum()));
                }
            }

            //判断发货单的验收状态
            Boolean notCheck = deliveryDetailList.stream().allMatch(e -> e.getCheckNumsSum().compareTo(BigDecimal.ZERO) < 1);
            Boolean anyCheck = deliveryDetailList.stream().anyMatch(e -> e.getCheckNumsSum().compareTo(BigDecimal.ZERO) == 1);
            String checkStatus = CommonConstant.DELIVERY_ACCEPTANCE_WAIT;
            if (notCheck){
                checkStatus = CommonConstant.DELIVERY_ACCEPTANCE_WAIT;
            }
            if (anyCheck){
                checkStatus = CommonConstant.DELIVERY_ACCEPTANCE_PART;
            }
            //更新发货验收状态和验收数量
            materialDeliveryEntity.setAcceptanceState(checkStatus);
            //更新发货验收状态和验收数量
            String msg = deliveryService.updateBillConfirmState(materialDeliveryEntity);
            if (null!=msg){
                throw new BusinessException("推送失败");
            }
            deliveryDetailService.updateBatchById(deliveryDetailList);
        }

        List<Long> ids = vos.stream().map(MaterialCheckVO::getId).collect(Collectors.toList());
        // 删除流水
        /*if(!flowService.delFlow(ids, BillTypeEnum.验收单.getCode())){
            throw new BusinessException("单据删除流水失败！");
        }*/
        super.removeByIds(ids,true);
    }

    @Override
    public boolean pushBillToSupCenter(MaterialCheckEntity entity) {
        Boolean syncFlag = pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON(entity), OPERATE,
                BILL_TYPE, BILL_NAME, PUSH_BILL_SERVER_URL);
        return syncFlag;
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String billId = request.getParameter("billId");
        MaterialCheckEntity entity = super.selectById(billId);
        String msg = pushSupUtil.updateBillSupSignSyncInfo(request, (JSONObject) JSONObject.toJSON(entity),
                MaterialCheckEntity.class, OPERATE, BILL_TYPE, BILL_NAME);
        return msg;
    }

    @Override
    public boolean delPushBill(MaterialCheckEntity entity) {
        Boolean delSuc = pushSupUtil.delPushBill((JSONObject) JSONObject.toJSON(entity), OPERATE,
                BILL_TYPE, BILL_NAME, DEL_SUP_BILL_SERVER_URL);
        return delSuc;
    }





    @Override
    public void submitChangeCheckNums(List<MaterialCheckDetailEntity> checkDetailList){
        for (MaterialCheckDetailEntity detailEntity:checkDetailList){
            MaterialDeliveryDetailEntity materialDeliveryDetailEntity = deliveryDetailService.selectById(detailEntity.getDeliveryDetailId());
            BigDecimal checkNumsSum = MathUtil.safeAdd(materialDeliveryDetailEntity.getCheckNumsSum(),detailEntity.getCheckNumsSum());
            LambdaUpdateWrapper<MaterialDeliveryDetailEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(MaterialDeliveryDetailEntity::getId,detailEntity.getDeliveryDetailId());
            wrapper.set(MaterialDeliveryDetailEntity::getCheckNumsSum,checkNumsSum);
            deliveryDetailService.update(wrapper);
        }
    }

    @Override
    public void backChangeCheckNums(List<MaterialCheckDetailEntity> checkDetailList){
        for (MaterialCheckDetailEntity detailEntity:checkDetailList){
            MaterialDeliveryDetailEntity materialDeliveryDetailEntity = deliveryDetailService.selectById(detailEntity.getDeliveryDetailId());
            BigDecimal checkNumsSum = MathUtil.safeSub(materialDeliveryDetailEntity.getCheckNumsSum(),detailEntity.getCheckNumsSum());
            LambdaUpdateWrapper<MaterialDeliveryDetailEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(MaterialDeliveryDetailEntity::getId,detailEntity.getDeliveryDetailId());
            wrapper.set(MaterialDeliveryDetailEntity::getCheckNumsSum,checkNumsSum);
            deliveryDetailService.update(wrapper);
        }
    }

    @Override
    public void submitChangeCheckState(Long deliveryId,List<MaterialCheckDetailEntity> detailEntities){
        Map<Long, MaterialCheckDetailEntity> collect = detailEntities.stream().collect(Collectors.toMap(MaterialCheckDetailEntity::getDeliveryDetailId, Function.identity(), (k1, k2) -> k2));
        MaterialDeliveryEntity materialDeliveryEntity = deliveryService.selectById(deliveryId);
        Boolean allCheck = true;
        for (MaterialDeliveryDetailEntity materialDeliveryDetailEntity : materialDeliveryEntity.getDeliveryDetailList()){
           /* BigDecimal checkNumsSum = BigDecimal.ZERO;
            if (null!=collect.get(deliveryDetailEntity.getId())){
                CheckDetailEntity detailEntity = collect.get(deliveryDetailEntity.getId());
                checkNumsSum = MathUtil.safeAdd(deliveryDetailEntity.getCheckNumsSum(),detailEntity.getCheckNumsSum());
            }else{
                checkNumsSum = deliveryDetailEntity.getCheckNumsSum();
            }*/
            BigDecimal checkNumsSum = BigDecimal.ZERO;
            checkNumsSum = materialDeliveryDetailEntity.getCheckNumsSum();
            if (null==checkNumsSum||checkNumsSum.compareTo(materialDeliveryDetailEntity.getDeliveredNumsSum()) == -1){
                allCheck = false;
            }
        }
        if (allCheck){
            LambdaUpdateWrapper<MaterialDeliveryEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(MaterialDeliveryEntity::getId,deliveryId);
            wrapper.set(MaterialDeliveryEntity::getAcceptanceState, CommonConstant.DELIVERY_ACCEPTANCE_ALL);
            deliveryService.update(wrapper);
        }else{
            LambdaUpdateWrapper<MaterialDeliveryEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(MaterialDeliveryEntity::getId,deliveryId);
            wrapper.set(MaterialDeliveryEntity::getAcceptanceState, CommonConstant.DELIVERY_ACCEPTANCE_PART);
            deliveryService.update(wrapper);
        }
    }

    @Override
    public void backChangeCheckState(Long deliveryId,List<MaterialCheckDetailEntity> detailEntities){
        Map<Long, MaterialCheckDetailEntity> collect = detailEntities.stream().collect(Collectors.toMap(MaterialCheckDetailEntity::getDeliveryDetailId, Function.identity(), (k1, k2) -> k2));
        MaterialDeliveryEntity materialDeliveryEntity = deliveryService.selectById(deliveryId);
        Boolean waitCheck = true;
        for (MaterialDeliveryDetailEntity materialDeliveryDetailEntity : materialDeliveryEntity.getDeliveryDetailList()){
            /*BigDecimal checkNumsSum = BigDecimal.ZERO;
            if (null!=collect.get(deliveryDetailEntity.getId())){
                CheckDetailEntity detailEntity = collect.get(deliveryDetailEntity.getId());
                checkNumsSum = MathUtil.safeSub(deliveryDetailEntity.getCheckNumsSum(),detailEntity.getCheckNumsSum());
            }else{
                checkNumsSum = deliveryDetailEntity.getCheckNumsSum();
            }*/
            BigDecimal checkNumsSum = BigDecimal.ZERO;
            checkNumsSum = materialDeliveryDetailEntity.getCheckNumsSum();
            if (null==checkNumsSum||checkNumsSum.compareTo(BigDecimal.ZERO) == 1){
                waitCheck = false;
            }
        }
        if (waitCheck){
            LambdaUpdateWrapper<MaterialDeliveryEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(MaterialDeliveryEntity::getId,deliveryId);
            wrapper.set(MaterialDeliveryEntity::getAcceptanceState, CommonConstant.DELIVERY_ACCEPTANCE_WAIT);
            deliveryService.update(wrapper);
        }else{
            LambdaUpdateWrapper<MaterialDeliveryEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(MaterialDeliveryEntity::getId,deliveryId);
            wrapper.set(MaterialDeliveryEntity::getAcceptanceState, CommonConstant.DELIVERY_ACCEPTANCE_PART);
            deliveryService.update(wrapper);
        }
    }

    /**
     * 校验必须大于最大单据日期
     * @param materialCheckVO
     * @param type
     * @return
     */
    public String validateTime(MaterialCheckVO materialCheckVO, String type) {

        if (materialCheckVO.getRmatDate().getTime()< materialCheckVO.getCheckDate().getTime()){
            throw new BusinessException("计租日期必须大于等于验收日期！");
        }
        if (CollectionUtils.isNotEmpty(materialCheckVO.getCheckDetailList())){
            for (MaterialCheckDetailVO detailVO : materialCheckVO.getCheckDetailList()){
                if (!"del".equals(detailVO.getRowState())&&detailVO.getRmatDate().getTime()< materialCheckVO.getCheckDate().getTime()){
                    throw new BusinessException("【"+detailVO.getMaterialName()+"】计租日期必须大于等于验收日期！");
                }
            }
        }

        Map<String, Object> params = new HashMap<>();
        params.put("contractId", materialCheckVO.getContractId());
        if(materialCheckVO.getId() != null){
            params.put("billType", MaterialConstant.验收单);
            params.put("billId", materialCheckVO.getId());
        }
        /*Date lastDate = materialService.getLastDate(params);
        Map<Date, Date> maxTimeMap = materialService.getMaxTime(params);

        if (lastDate == null) return "未获取最大单据日期！";
        if(ValidateUtil.compareDate(checkVO.getCheckDate(), lastDate, maxTimeMap, checkVO.getCreateTime())){
            throw new BusinessException(DateUtil.formatDate(checkVO.getCheckDate())
                    + "验收日期小于最大单据日期【" + DateUtil.formatDate(lastDate) + "】，不允许" + type + "!");
        }*/

        return "校验通过！";
    }


}
