package com.ejianc.business.assist.store.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.assist.store.bean.StoreCheckDetailEntity;
import com.ejianc.business.assist.store.bean.StoreCheckEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.consts.StoreCommonConsts;
import com.ejianc.business.assist.store.controller.FlowController;
import com.ejianc.business.assist.store.mapper.StoreCheckDetailMapper;
import com.ejianc.business.assist.store.mapper.StoreCheckMapper;
import com.ejianc.business.assist.store.service.IStoreCheckService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.util.StoreManageUtil;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.business.assist.store.vo.UseMaterialPriceVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 仓库盘点表
 * 
 * @author generator
 * 
 */
@Service("storeCheckService")
public class StoreCheckServiceImpl extends BaseServiceImpl<StoreCheckMapper, StoreCheckEntity> implements IStoreCheckService {

    @Autowired
    private StoreCheckDetailMapper storeCheckDetailMapper;

    @Autowired
    private StoreCheckMapper storeCheckMapper;

    @Autowired
    private StoreManageService storeManageService;

    @Autowired
    private FlowController flowHandle;

    @Override
    public CommonResponse saveCheckStore(StoreCheckEntity entity) {
        Long orgId = entity.getOrgId();
        Long storeId = entity.getStoreId();

        QueryWrapper<StoreCheckEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("org_id",orgId);
        wrapper.eq("store_id",storeId);
        wrapper.eq("bill_state",StoreCommonConsts.ZERO);
        List<StoreCheckEntity> list = super.list(wrapper);
        Integer checkCount = list.size();
        if(null == entity.getId()){
            if(checkCount > 0) {
                return CommonResponse.error("该仓库已下存在自由态盘点单！");
            }
        }else{
            if(checkCount > 1) {
                return CommonResponse.error("该仓库已下存在自由态盘点单！");
            }
        }
        //更新子表信息
        if(null != entity.getId()) {
            storeCheckDetailMapper.delByCheckId(entity.getId());
        }
        super.saveOrUpdate(entity, false);
        List<StoreCheckDetailEntity> checkSubList = entity.getCheckSubList();
        List<StoreCheckDetailEntity> subList = new ArrayList<>();
        checkSubList.forEach(item->{
            if(item.getInventory() != null && item.getInventory().compareTo(BigDecimal.ZERO) < 0){
                subList.add(item);
            }
        });

        // 校验提交时数量是否足够
        Map<Long,FlowVO> checkMap = new HashMap<>();
        String materialIds = "[";
        for (StoreCheckDetailEntity item:subList
             ) {
            materialIds = materialIds + item.getMaterialId()+",";
        }
        materialIds = materialIds.substring(0,materialIds.length()-1)+"]";
        String condition = "{orgId:"+entity.getOrgId()+",storeId:"+entity.getStoreId()+",materialIds:"+materialIds+"}";
        // 本次盘点包含出库单时进行校验。
        if(subList.size() > 0){
            CommonResponse<IPage<FlowVO>> iPageCommonResponse = flowHandle.refInstoreFlowData(1, 1000, condition, "", "");
            if(!iPageCommonResponse.isSuccess() || null == iPageCommonResponse.getData()){
                return CommonResponse.error("获取最新数量失败！");
            }
            List<FlowVO> records = iPageCommonResponse.getData().getRecords();
            records.forEach(item->{
                checkMap.put(item.getMaterialId(),item);
            });
            for (StoreCheckDetailEntity item:subList
                 ) {
                FlowVO flowVO = checkMap.get(item.getMaterialId());
                // 库存可用为0时
                if(null == flowVO){
                    return CommonResponse.error("【"+item.getMaterialName()+"_"+item.getSpec()+"】库存可用数量不足，无法形成盘亏出库单；  不可保存");
                }
                // 校验库存是否足够出库单使用
                if(item.getInventory().add(flowVO.getSurplusNum()).compareTo(BigDecimal.ZERO) < 0){
                    return CommonResponse.error("【"+item.getMaterialName()+"_"+item.getSpec()+"】库存可用数量不足，无法形成盘亏出库单；  不可保存");
                }
            }
        }

        if(subList.size() > 0){
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.盘亏出库);
            ArrayList<FlowVO> flowVOS = new ArrayList<>();
            subList.forEach(item->{
                if(item.getInventory() == null) item.setInventory(BigDecimal.ZERO);
                FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.盘亏出库,0);
                flowVO.setStoreId(entity.getStoreId());
                flowVO.setStoreName(entity.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgCode(entity.getParentOrgCode());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setMaterialCategoryId(item.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(item.getMaterialCategoryName());
                flowVO.setMaterialId(item.getMaterialId());
                flowVO.setMaterialName(item.getMaterialName());
                flowVO.setMaterialSpec(item.getSpec());
                flowVO.setNum(BigDecimal.ZERO.subtract(item.getInventory()));
                if(null != item.getPrice()){
                    flowVO.setTaxPrice(item.getPrice());
                    flowVO.setTaxMny(item.getPrice().multiply(flowVO.getNum()));
                }
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(item.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getCheckDate());
                flowVOS.add(flowVO);
            });
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setFlowVOList(flowVOS);
            CommonResponse<StoreManageVO> commonResponse = storeManageService.surplusMaterialPrice(storeManageVO);
            if(!commonResponse.isSuccess()){
                return commonResponse;
            }
            List<UseMaterialPriceVO> useMaterialPriceVOList = new ArrayList<>();
            if(null != commonResponse.getData()){
                useMaterialPriceVOList = commonResponse.getData().getUseMaterialPriceVOList();
            }
            Map<Long, UseMaterialPriceVO> priceMap = useMaterialPriceVOList.stream().collect(Collectors.toMap(k -> k.getMaterialId(), (k) -> k));

            flowVOS.forEach(item->{
                item.setTaxPrice(priceMap.get(item.getMaterialId()).getTaxPrice());
                item.setTaxMny(priceMap.get(item.getMaterialId()).getTaxMny());
            });
            storeManageVO.setFlowVOList(flowVOS);
            CommonResponse<StoreManageVO> storeManageVOCommonResponse = storeManageService.inOutStore(storeManageVO);
            if(!storeManageVOCommonResponse.isSuccess()){
                return storeManageVOCommonResponse;
            }
        }
        return CommonResponse.success(entity);
    }

    @Override
    public CommonResponse myRemoveByIds(List<Long> ids) {
        CommonResponse commonResponse = checkRollback(ids);
        if(!commonResponse.isSuccess()){
            return commonResponse;
        }
        super.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }
    @Override
    public CommonResponse checkRollback(List<Long> ids){
        StoreManageVO storeManageVO = new StoreManageVO();
        List<Long> SourceIds = new ArrayList<>();
        for (Long item:ids
             ) {
            StoreCheckEntity entity = super.selectById(item);
            List<StoreCheckDetailEntity> checkSubList = entity.getCheckSubList();
            Boolean checkFalg = false;
            for (StoreCheckDetailEntity t:checkSubList) {
                if(t.getInventory().compareTo(BigDecimal.ZERO) < 0){
                    checkFalg = true;
                    break;
                }
            }
            // 包含出库单，才需要此操作。
            if(checkFalg){
                SourceIds.clear();
                SourceIds.add(item);
                storeManageVO.setSourceId(item);
                storeManageVO.setStoreId(entity.getStoreId());
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.盘亏出库);
                storeManageVO.setSourceIdsForRollBack(SourceIds);
                CommonResponse<StoreManageVO> rollbackCommonResponse = storeManageService.inOutStoreRollback(storeManageVO);
                if(!rollbackCommonResponse.isSuccess()){
                    return rollbackCommonResponse;
                }
            }
        }
        return CommonResponse.success();
    };
    @Override
    public CommonResponse checkOut(List<Long> ids){
        StoreManageVO storeManageVO = new StoreManageVO();
        List<Long> SourceIds = new ArrayList<>();
        for (Long item:ids
        ) {
            StoreCheckEntity entity = super.selectById(item);
            SourceIds.clear();
            SourceIds.add(item);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.盘亏出库);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            storeManageVO.setSourceId(item);
            storeManageVO.setOutEffectiveON(true);
            CommonResponse<StoreManageVO> rollbackCommonResponse = storeManageService.inOutStore(storeManageVO);
            if(!rollbackCommonResponse.isSuccess()){
                return rollbackCommonResponse;
            }
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse checkByDate(Long storeId, String checkDate) {
        List<StoreCheckEntity> checkEntities = storeCheckMapper.queryByDate(storeId, checkDate);
        if(checkEntities.size()>0){
            return CommonResponse.error("该时间点后已发生仓库盘点单");
        }
        return CommonResponse.success();
    }

}
