package com.ejianc.business.assist.store.controller.api;

import com.ejianc.business.assist.store.bean.FlowEntity;
import com.ejianc.business.assist.store.consts.StoreCommonConsts;
import com.ejianc.business.assist.store.service.IFlowService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.assist.store.vo.OutFlowVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/storeManage/")
@Api(value = "仓库管理公共API接口", tags = {"仓库管理公共API接口"})
public class StoreManageApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    StoreManageService storeManageService;
    @Autowired
    IFlowService flowService;

    /**
     * @param storeManageVO 数据
     * @description: 入库
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2022/1/18
     */
    @ApiOperation("出入库正向操作")
    @RequestMapping(value = "/inOutStore", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<StoreManageVO> inOutStore(@RequestBody StoreManageVO storeManageVO) {
        return storeManageService.inOutStore(storeManageVO);
    }


    /**
     * @param storeManageVO 数据
     * @description: 出入库逆向操作
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2022/1/17
     */
    @ApiOperation("出入库逆向操作")
    @RequestMapping(value = "/inOutStoreRollback", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<StoreManageVO> inOutStoreRollback(@RequestBody StoreManageVO storeManageVO) {
        return storeManageService.inOutStoreRollback(storeManageVO);
    }

    /**
     * @param storeManageVO
     * @description: 查询物资库存现存量库存均价
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.assist.store.vo.StoreManageVO>
     * @author songlx
     * @date: 2022/2/9
     */
    @ApiOperation("现存量库存均价")
    @RequestMapping(value = "/surplusMaterialPrice", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<StoreManageVO> surplusMaterialPrice(@RequestBody StoreManageVO storeManageVO) {
        return storeManageService.surplusMaterialPrice(storeManageVO);
    }


    /**
     * @param storeManageVO
     * @description: 更新摊销金额
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.assist.store.vo.StoreManageVO>
     * @author songlx
     * @date: 2022/3/2
     */
    @ApiOperation("更新摊销金额")
    @RequestMapping(value = "/updateShareMny", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<StoreManageVO> updateShareMny(@RequestBody StoreManageVO storeManageVO) {
        return storeManageService.updateShareMny(storeManageVO);
    }

    /**
     * @description:  周转材库存现存量库存均价
     *
     * @param storeManageVO
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.assist.store.vo.StoreManageVO>
     * @author songlx
     * @date: 2022/3/3
     */
    @ApiOperation("周转材库存现存量库存均价")
    @RequestMapping(value = "/turnSurplusMaterialPrice", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<StoreManageVO> turnSurplusMaterialPrice(@RequestBody StoreManageVO storeManageVO) {
        return storeManageService.turnSurplusMaterialPrice(storeManageVO);
    }
    /**
     * @param
     * @description: 根据合同id 出入库类型 查询明细
     * @author 姜轶凯
     * @date: 2022/3/4
     */
    @PostMapping(value = "getFlowListByContractId")
    @ResponseBody
    CommonResponse<List<FlowVO>> getFlowListByContractId(@RequestBody OutFlowVO outFlowVO){
        QueryParam param = new QueryParam();
        param.getParams().put("inOutType", new Parameter(QueryParam.IN, outFlowVO.getInOutTypeList()));
        param.getParams().put("pickContractId", new Parameter(QueryParam.EQ, outFlowVO.getContractId()));
        param.getParams().put("effectiveState", new Parameter(QueryParam.EQ, StoreCommonConsts.YES));
        param.getParams().put("settleFlag", new Parameter(QueryParam.EQ, StoreCommonConsts.NO));
        List<FlowEntity> flowEntities = flowService.queryList(param, false);
        List<FlowVO> list = BeanMapper.mapList(flowEntities, FlowVO.class);
        return CommonResponse.success("查询成功",list);
    }
}
