package com.ejianc.business.assist.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.material.bean.MaterialCheckDetailEntity;
import com.ejianc.business.assist.material.bean.MaterialCheckEntity;
import com.ejianc.business.assist.material.bean.MaterialDeliveryEntity;
import com.ejianc.business.assist.rmat.enums.BillPushStatusEnum;
import com.ejianc.business.assist.material.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.enums.SupplierSignStatusEnum;
import com.ejianc.business.assist.material.service.IMaterialCheckService;
import com.ejianc.business.assist.material.service.IMaterialDeliveryService;
import com.ejianc.business.assist.rmat.utils.MaterialConstant;
import com.ejianc.business.assist.material.vo.MaterialCheckVO;
import com.ejianc.business.common.CommonConstant;
import com.ejianc.business.assist.store.api.IStoreManageApi;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.util.StoreManageUtil;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("materialCheck")
public class MaterialCheckBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IMaterialCheckService service;

	@Autowired
	private IMaterialDeliveryService deliveryService;

	@Autowired
	private IStoreManageApi storeManageApi;

	/*@Autowired
	private IMaterialService materialService;

	@Autowired
	private IRmatFlowService flowService;
*/
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		MaterialCheckEntity materialCheckEntity = service.selectById(billId);
		if (CommonConstant.CHECK_SOURCE_YS.equals(materialCheckEntity.getCheckSource())){
			MaterialDeliveryEntity materialDeliveryEntity = deliveryService.selectById(materialCheckEntity.getDeliveryId());
			if (null!= materialDeliveryEntity.getDisableState()&& CommonConstant.ORDER_DISABLE_YES.equals(materialDeliveryEntity.getDisableState())){
				return CommonResponse.error("待验收单已经关闭，当前单据无法提交。");
			}
		}
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		MaterialCheckEntity materialCheckEntity = service.selectById(billId);
		// 推送流水生效
		/*if(!flowService.insertCheckFlow(checkEntity, billTypeCode, RmatCommonConsts.YES)){
			return CommonResponse.error("审批回调失败，单据推送流水失败！");
		}*/

		//入库方式，0-收料入库，1-直入直出
		if (CommonConstant.CHECK_TYPE_SLRK.equals(materialCheckEntity.getCheckType())){
			//调用库存逻辑
			StoreManageVO storeManageVO = new StoreManageVO();
			storeManageVO.setInOutTypeEnum(InOutTypeEnum.周转材收料入库);
			storeManageVO.setStoreId(materialCheckEntity.getStoreId());
			storeManageVO.setOutEffectiveON(true);
			storeManageVO.setSourceId(materialCheckEntity.getId());
			ArrayList<FlowVO> flowVOS = new ArrayList<>();
			materialCheckEntity.getCheckDetailList().forEach(t->{
				FlowVO flowVO = new FlowVO();
				flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.周转材收料入库, 0);
				getFlow(materialCheckEntity, t, flowVO);
				flowVOS.add(flowVO);
			});
			storeManageVO.setFlowVOList(flowVOS);
			String stringInfo = JSONObject.toJSONString(storeManageVO);
			logger.info("周转材采购验收入库参数：" +stringInfo);
			CommonResponse<StoreManageVO> response = storeManageApi.inOutStore(storeManageVO);
			if(!response.isSuccess()) {
				throw new BusinessException("调用库存管理失败,错误信息" +response.getMsg());
			}
		}
		//入库方式，0-收料入库，1-直入直出
		/*if (materialCheckEntity.getStoreType() == 1){
			//调用库存逻辑
			StoreManageVO storeManageVO = new StoreManageVO();
			storeManageVO.setStoreId(materialCheckEntity.getStoreId());
			storeManageVO.setInOutTypeEnum(InOutTypeEnum.直入直出入库);
			storeManageVO.setOutEffectiveON(true);
			storeManageVO.setSourceId(checkEntity.getId());
			ArrayList<FlowVO> flowVOS = new ArrayList<>();
			checkEntity.getCheckDetailList().forEach(t->{
				FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.直入直出入库, 0);
				getFlow(checkEntity, t, flowVO);
				flowVOS.add(flowVO);
			});
			storeManageVO.setFlowVOList(flowVOS);
			ArrayList<FlowVO> flowOutS = new ArrayList<>();
			checkEntity.getCheckDetailList().forEach(t->{
				FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.直入直出出库, 0);
				getFlow(checkEntity, t, flowVO);
				flowOutS.add(flowVO);
			});
			storeManageVO.setStraightOutFlowVOList(flowOutS);
			String stringInfo = JSONObject.toJSONString(storeManageVO);
			logger.info("消耗材直入直出参数：" +stringInfo);
			CommonResponse<StoreManageVO> response = storeManageApi.inOutStore(storeManageVO);
			if(!response.isSuccess()) {
				throw new BusinessException("调用库存管理失败,错误信息" +response.getMsg());
			}
		}*/

		//单据协同推送
		boolean pushResult = service.pushBillToSupCenter(materialCheckEntity);
		if(pushResult) {
			materialCheckEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
		}else {
			logger.error("单据-{}id-{}推送供应商服务失败", BillTypeEnum.验收单.getName(), billId);
			materialCheckEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		}
		service.saveOrUpdate(materialCheckEntity, false);
		return CommonResponse.success("审批回调成功！");
	}

	private void getFlow(MaterialCheckEntity checkEntity, MaterialCheckDetailEntity t, FlowVO flowVO) {
		flowVO.setProjectId(checkEntity.getProjectId());
		flowVO.setTaxRate(t.getTaxRate());
		flowVO.setProjectName(checkEntity.getProjectName());
		flowVO.setParentOrgId(checkEntity.getParentOrgId());
		flowVO.setParentOrgName(checkEntity.getParentOrgName());
		flowVO.setOrgId(checkEntity.getOrgId());
		flowVO.setOrgName(checkEntity.getOrgName());
		flowVO.setStoreId(checkEntity.getStoreId());
		flowVO.setStoreName(checkEntity.getStoreName());
		flowVO.setEmployeeId(checkEntity.getEmployeeId());
		flowVO.setEmployeeName(checkEntity.getEmployeeName());

		flowVO.setMaterialType(checkEntity.getCheckType());
		flowVO.setMaterialTypeName(checkEntity.getCheckType());

		flowVO.setSupplierId(checkEntity.getSupplierId());
		flowVO.setSupplierName(checkEntity.getSupplierName());
		flowVO.setPurchaseContractId(checkEntity.getContractId());
		flowVO.setPurchaseContractName(checkEntity.getContractName());
		flowVO.setMaterialCategoryId(t.getMaterialTypeId());
		flowVO.setMaterialCategoryName(t.getMaterialTypeName());
		flowVO.setMaterialId(t.getMaterialId());
		flowVO.setMaterialName(t.getMaterialName());
		flowVO.setMaterialCode(t.getMaterialCode());
		flowVO.setMaterialSpec(t.getSpec());
		flowVO.setMaterialUnitId(t.getUnitId());
		flowVO.setMaterialUnitName(t.getUnitName());
		flowVO.setTaxPrice(t.getUnitTaxPrice());
		flowVO.setPrice(t.getUnitPrice());
		flowVO.setNum(t.getCheckNumsSum());
		flowVO.setTaxMny(t.getTaxMny());
		flowVO.setMny(t.getMny());
		flowVO.setTax(t.getTaxMny());
		flowVO.setPickUnitId(checkEntity.getSupplierId());
		flowVO.setPickUnitName(checkEntity.getSupplierName());
		flowVO.setPickContractId(checkEntity.getContractId());
		flowVO.setPickContractName(checkEntity.getContractName());
		flowVO.setSourceId(checkEntity.getId());
		flowVO.setSourceDetailId(t.getId());
		flowVO.setSourceBillCode(checkEntity.getBillCode());
		flowVO.setSourceBillDate(checkEntity.getCheckDate());
		flowVO.setSourceBillRemark(checkEntity.getMemo());
		flowVO.setSourceBillDetailRemark(t.getMemo());
		flowVO.setRowState(t.getRowState());
	}


	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {

		MaterialCheckEntity entity = service.selectById(billId);
		//检测单据是否供应商已签字，
		if(SupplierSignStatusEnum.乙方已签字.getCode().equals(entity.getSupplierSignStatus())) {
			return CommonResponse.error("供应商已签字，无法执行此操作！");
		}
		// 同一个合同只能存在一个自由态或审批中的单据
		//materialService.validateContract(entity.getContractId(), null, null, MaterialConstant.弃审);
		// 校验必须大于最大单据日期
		//service.validateTime(BeanMapper.map(entity, MaterialCheckVO.class), MaterialConstant.弃审);

		// 是否被其他单据引用
		CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(!res.isSuccess()) {//单据未被下游单据引用
			return CommonResponse.error(res.getMsg());
		}
		// 推送流水未生效
		/*if(!flowService.insertCheckFlow(entity, billTypeCode, RmatCommonConsts.NO)){
			return CommonResponse.error("弃审前回调失败，单据推送流水失败！");
		}*/
		//将推送至供方的单据作废
		if (BillPushStatusEnum.推送成功.getStatus().equals(entity.getBillPushFlag())) {
			boolean pushResult = service.delPushBill(entity);
			if (!pushResult) {
				return CommonResponse.error("弃审前回调失败，单据作废协同服务失败！");
			} else {
				entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
				service.saveOrUpdate(entity, false);
			}
		}

		//入库方式，0-收料入库，1-直入直出
		if (CommonConstant.CHECK_TYPE_SLRK.equals(entity.getCheckType())){
			List<Long> ids = new ArrayList<>();
			ids.add(billId);
			StoreManageVO storeManageVO = new StoreManageVO();
			storeManageVO.setSourceId(entity.getId());
			storeManageVO.setInOutTypeEnum(InOutTypeEnum.周转材收料入库);
			storeManageVO.setStoreId(entity.getStoreId());
			storeManageVO.setOutEffectiveON(true);
			String stringInfo = JSONObject.toJSONString(storeManageVO);
			logger.info("周转材撤回参数：" +stringInfo);
			CommonResponse<StoreManageVO> response = storeManageApi.inOutStoreRollback(storeManageVO);
			if(!response.isSuccess()) {
				return CommonResponse.error(response.getMsg());
//				throw new BusinessException();
			}
		}
		/*if (checkEntity.getStoreType() == 1){
			List<Long> ids = new ArrayList<>();
			ids.add(billId);
			com.ejianc.business.store.vo.StoreManageVO storeManageVO = new com.ejianc.business.store.vo.StoreManageVO();
			storeManageVO.setStoreId(checkEntity.getStoreId());
			storeManageVO.setSourceId(checkEntity.getId());
			storeManageVO.setSourceIdsForRollBack(ids);
			storeManageVO.setInOutTypeEnum(com.ejianc.business.store.consts.InOutTypeEnum.直入直出入库);
			storeManageVO.setOutEffectiveON(true);
			String stringInfo = JSONObject.toJSONString(storeManageVO);
			logger.info("消耗材撤回参数：" +stringInfo);
			CommonResponse<com.ejianc.business.store.vo.StoreManageVO> response = storeManageApi.inOutStoreRollback(storeManageVO);
			if(!response.isSuccess()) {
				return CommonResponse.error(response.getMsg());
//				throw new BusinessException(response.getMsg());
			}
		}*/


		return CommonResponse.success("弃审前回调成功！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}


}
