/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.store.service.impl;

import com.ejianc.business.assist.store.bean.ProcessEntity;
import com.ejianc.business.assist.store.bean.ProcessProductEntity;
import com.ejianc.business.assist.store.bean.ProcessRawEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.service.IProcessService;
import com.ejianc.business.assist.store.service.IStoreCheckService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="process")
public class ProcessBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IProcessService service;
    @Autowired
    private IStoreCheckService checkService;
    @Autowired
    private StoreManageService storeManageService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ArrayList<Long> longs = new ArrayList<Long>();
        longs.add(billId);
        this.service.processInOut(longs, true);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ProcessEntity processEntity = (ProcessEntity)((Object)this.service.selectById(billId));
        if (processEntity != null) {
            CommonResponse commonResponse = this.checkService.checkByDate(processEntity.getStoreId(), DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)processEntity.getProcessDate()));
            return commonResponse;
        }
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> SourceIds = new ArrayList<Long>();
        ProcessEntity entity = (ProcessEntity)((Object)this.service.selectById(billId));
        Boolean checkFlag = false;
        List<ProcessProductEntity> processProductList = entity.getProcessProductList();
        for (Object item : processProductList) {
            if (item.getProcessNum().compareTo(BigDecimal.ZERO) <= 0) continue;
            checkFlag = true;
            break;
        }
        if (checkFlag.booleanValue()) {
            SourceIds.add(billId);
            storeManageVO.setSourceId(billId);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u539f\u6750\u6599\u52a0\u5de5\u5165\u5e93);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            CommonResponse<StoreManageVO> storeManageVOCommonResponse = this.storeManageService.inOutStoreRollback(storeManageVO);
            if (!storeManageVOCommonResponse.isSuccess()) {
                return CommonResponse.error((String)storeManageVOCommonResponse.getMsg());
            }
        }
        List<ProcessRawEntity> processRawList = entity.getProcessRawList();
        for (ProcessRawEntity item : processRawList) {
            if (item.getRawNum().compareTo(BigDecimal.ZERO) <= 0) continue;
            checkFlag = true;
            break;
        }
        if (checkFlag.booleanValue()) {
            SourceIds.add(billId);
            storeManageVO.setSourceId(billId);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u539f\u6750\u6599\u52a0\u5de5\u51fa\u5e93);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            CommonResponse<StoreManageVO> storeManageVOCommonResponse = this.storeManageService.inOutStoreRollback(storeManageVO);
            if (!storeManageVOCommonResponse.isSuccess()) {
                return CommonResponse.error((String)storeManageVOCommonResponse.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

