/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.store.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.store.bean.ProcessEntity;
import com.ejianc.business.assist.store.service.IProcessService;
import com.ejianc.business.assist.store.service.ISurplusService;
import com.ejianc.business.assist.store.vo.ProcessVO;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.store.vo.UseMaterialPriceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"process"})
public class ProcessController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "STORE_PROCESS";
    @Autowired
    private IProcessService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISurplusService surplusService;
    @Autowired
    private IStoreManageApi storeManageApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProcessVO> saveOrUpdate(@RequestBody ProcessVO saveOrUpdateVO) {
        ProcessEntity entity = (ProcessEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProcessEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getCostTaxMny() != null && entity.getProcessCostTaxMny() != null && entity.getCostTaxMny().compareTo(entity.getProcessCostTaxMny()) == -1) {
            return CommonResponse.error((String)"\u6210\u54c1\u91d1\u989d\u5c0f\u4e8e\u52a0\u5de5\u6210\u672c\u91d1\u989d\u4e0d\u53ef\u4fdd\u5b58\u5355\u636e\uff01");
        }
        List detailList = saveOrUpdateVO.getProcessRawList();
        String outStoreNames = detailList.stream().filter(x -> !"del".equals(x.getRowState()) && StringUtils.isNotEmpty((CharSequence)x.getStoreName())).map(x -> x.getStoreName()).distinct().collect(Collectors.joining(","));
        entity.setOutStoreNames(outStoreNames);
        CommonResponse commonResponse = this.service.saveCheckProcess(entity);
        if (!commonResponse.isSuccess()) {
            return commonResponse;
        }
        ProcessVO vo = (ProcessVO)BeanMapper.map((Object)((Object)entity), ProcessVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProcessVO> queryDetail(Long id) {
        ProcessEntity entity = (ProcessEntity)((Object)this.service.selectById(id));
        ProcessVO vo = (ProcessVO)BeanMapper.map((Object)((Object)entity), ProcessVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProcessVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProcessVO processVO : vos) {
            }
        }
        this.service.myRemoveByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProcessVO>> queryList(@RequestBody QueryParam param) {
        param.setFuzzyFields(Arrays.asList("billCode", "storeName", "orgName", "employeeName", "outStoreNames"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        } else if (((Parameter)param.getParams().get("orgId")).getValue() != null) {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProcessVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List processVOS = BeanMapper.mapList((Iterable)list, ProcessVO.class);
        processVOS.forEach(e -> e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription()));
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", processVOS);
        ExcelExport.getInstance().export("processExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProcessData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProcessVO>> refProcessData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProcessVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getMaterialPrice"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<UseMaterialPriceVO>> getMaterialPrice(@RequestBody ProcessVO vo) {
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList flowVOS = new ArrayList();
        storeManageVO.setStoreId(vo.getStoreId());
        if (vo.getId() != null) {
            storeManageVO.setSourceId(vo.getId());
        }
        vo.getProcessRawList().forEach(e -> {
            FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u6750\u6599\u5904\u7f6e, (Integer)0);
            flowVO.setStoreId(vo.getStoreId());
            flowVO.setStoreName(vo.getStoreName());
            flowVO.setOrgId(vo.getOrgId());
            flowVO.setOrgName(vo.getOrgName());
            flowVO.setParentOrgId(vo.getParentOrgId());
            flowVO.setParentOrgName(vo.getParentOrgName());
            flowVO.setEmployeeId(vo.getEmployeeId());
            flowVO.setEmployeeName(vo.getEmployeeName());
            flowVO.setMaterialCategoryId(e.getMaterialTypeId());
            flowVO.setMaterialCategoryName(e.getMaterialTypeName());
            flowVO.setMaterialId(e.getMaterialId());
            flowVO.setMaterialName(e.getMaterialName());
            flowVO.setMaterialSpec(e.getSpec());
            flowVO.setMaterialUnitId(e.getUnitId());
            flowVO.setMaterialUnitName(e.getUnitName());
            flowVO.setNum(e.getRawNum());
            flowVO.setSourceDetailId(e.getId());
            flowVO.setSourceBillCode(vo.getBillCode());
            flowVO.setSourceBillDate(vo.getProcessDate());
            flowVO.setRowState(e.getRowState());
            flowVOS.add(flowVO);
        });
        storeManageVO.setFlowVOList(flowVOS);
        List list = new ArrayList();
        CommonResponse response = this.storeManageApi.turnSurplusMaterialPrice(storeManageVO);
        if (response.getData() != null) {
            list = ((StoreManageVO)response.getData()).getUseMaterialPriceVOList();
            return CommonResponse.success((String)"\u539f\u503c\u5355\u4ef7/\u51c0\u503c\u83b7\u53d6\u6210\u529f", list);
        }
        return CommonResponse.success((String)response.getMsg());
    }
}

