package com.ejianc.business.assist.store.service.impl;

import com.ejianc.business.assist.store.bean.ProcessEntity;
import com.ejianc.business.assist.store.bean.ProcessProductEntity;
import com.ejianc.business.assist.store.bean.ProcessRawEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.service.IProcessService;
import com.ejianc.business.assist.store.service.IStoreCheckService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Service("process") 
public class ProcessBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IProcessService service;

	@Autowired
	private IStoreCheckService checkService;

	@Autowired
	private StoreManageService storeManageService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ArrayList<Long> longs = new ArrayList<>();
		longs.add(billId);
		service.processInOut(longs,true);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		ProcessEntity processEntity = service.selectById(billId);
		if(processEntity != null){
			CommonResponse commonResponse = checkService.checkByDate(processEntity.getStoreId(), DateFormatUtil.formatDate("yyyy-MM-dd", processEntity.getProcessDate()));
			return commonResponse;
		}
		StoreManageVO storeManageVO = new StoreManageVO();
		List<Long> SourceIds = new ArrayList<>();
		ProcessEntity entity = service.selectById(billId);
		Boolean checkFlag = false;
		List<ProcessProductEntity> processProductList = entity.getProcessProductList();
		for (ProcessProductEntity item: processProductList
		) {
			if(item.getProcessNum().compareTo(BigDecimal.ZERO) > 0){
				checkFlag = true;
				break;
			}
		}
		if(checkFlag){
			SourceIds.add(billId);
			storeManageVO.setSourceId(billId);
			storeManageVO.setStoreId(entity.getStoreId());
			storeManageVO.setInOutTypeEnum(InOutTypeEnum.原材料加工入库);
			storeManageVO.setSourceIdsForRollBack(SourceIds);
			storeManageVO.setOutEffectiveON(true);
			CommonResponse<StoreManageVO> storeManageVOCommonResponse = storeManageService.inOutStoreRollback(storeManageVO);
			if(!storeManageVOCommonResponse.isSuccess()) return CommonResponse.error(storeManageVOCommonResponse.getMsg());
		}
		List<ProcessRawEntity> processRawList = entity.getProcessRawList();
		for (ProcessRawEntity item: processRawList
		) {
			if(item.getRawNum().compareTo(BigDecimal.ZERO) > 0){
				checkFlag = true;
				break;
			}
		}
		if(checkFlag){
			SourceIds.add(billId);
			storeManageVO.setSourceId(billId);
			storeManageVO.setStoreId(entity.getStoreId());
			storeManageVO.setInOutTypeEnum(InOutTypeEnum.原材料加工出库);
			storeManageVO.setSourceIdsForRollBack(SourceIds);
			storeManageVO.setOutEffectiveON(true);
			CommonResponse<StoreManageVO> storeManageVOCommonResponse = storeManageService.inOutStoreRollback(storeManageVO);
			if(!storeManageVOCommonResponse.isSuccess()) return CommonResponse.error(storeManageVOCommonResponse.getMsg());
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
