/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.store.service.impl;

import com.ejianc.business.assist.store.bean.OtherInDetailEntity;
import com.ejianc.business.assist.store.bean.OtherInEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.service.IOtherInService;
import com.ejianc.business.assist.store.service.IStoreCheckService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="otherIn")
public class OtherInBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOtherInService service;
    @Autowired
    private IStoreCheckService checkService;
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private JedisPool jedisPool;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        OtherInEntity otherInEntity = (OtherInEntity)((Object)this.service.selectById(billId));
        if (otherInEntity.getRequirFlag() == 0) {
            return CommonResponse.error((String)"\u662f\u5426\u7b26\u5408\u8981\u6c42\u5fc5\u987b\u4e3a\u662f\u624d\u53ef\u4ee5\u63d0\u4ea4\u5355\u636e!");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        block7: {
            Jedis jedis = this.jedisPool.getResource();
            boolean locked = false;
            locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(billId), (String)"generateOtherIn", (int)1000);
            this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
            try {
                if (locked) {
                    ArrayList<Long> longs = new ArrayList<Long>();
                    longs.add(billId);
                    this.service.otherInOut(longs, true);
                    break block7;
                }
                CommonResponse longs = CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                return longs;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (locked) {
                    RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(billId), (String)"generateOtherIn");
                }
                jedis.close();
                this.logger.info("\u8f85\u6599\u4e2d\u5fc3\u91c7\u8d2d\u5176\u4ed6\u5165\u5e93\u5ba1\u6279\u901a\u8fc7finally\u65b9\u6cd5");
            }
        }
        this.logger.info("\u8f85\u6599\u4e2d\u5fc3\u91c7\u8d2d\u5176\u4ed6\u5165\u5e93\u5ba1\u6279\u901a\u8fc7------billTypeCode-{},state-{}", (Object)billTypeCode, (Object)state);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OtherInEntity otherInEntity = (OtherInEntity)((Object)this.service.selectById(billId));
        if (otherInEntity != null) {
            CommonResponse commonResponse = this.checkService.checkByDate(otherInEntity.getStoreId(), DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)otherInEntity.getCheckDate()));
            return commonResponse;
        }
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> SourceIds = new ArrayList<Long>();
        OtherInEntity entity = (OtherInEntity)((Object)this.service.selectById(billId));
        List<OtherInDetailEntity> otherInList = entity.getOtherInDetailList();
        Boolean checkFlag = false;
        for (OtherInDetailEntity item : otherInList) {
            if (item.getInStoreNum().compareTo(BigDecimal.ZERO) <= 0) continue;
            checkFlag = true;
            break;
        }
        if (checkFlag.booleanValue()) {
            SourceIds.add(billId);
            storeManageVO.setSourceId(billId);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u5176\u4ed6\u5165\u5e93);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            CommonResponse<StoreManageVO> storeManageVOCommonResponse = this.storeManageService.inOutStoreRollback(storeManageVO);
            if (!storeManageVOCommonResponse.isSuccess()) {
                return CommonResponse.error((String)storeManageVOCommonResponse.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

