package com.ejianc.business.assist.store.service.impl;

import com.ejianc.business.assist.store.bean.*;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.service.IOtherInService;
import com.ejianc.business.assist.store.service.IStoreCheckService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.util.StoreManageUtil;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Service("otherIn") 
public class OtherInBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IOtherInService service;

	@Autowired
	private IStoreCheckService checkService;

	@Autowired
	private StoreManageService storeManageService;

	@Autowired
	private JedisPool jedisPool;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OtherInEntity otherInEntity = service.selectById(billId);
		if (otherInEntity.getRequirFlag() == 0){
			return CommonResponse.error("是否符合要求必须为是才可以提交单据!");
		}else {
			return CommonResponse.success();
		}
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//入库
		Jedis jedis = jedisPool.getResource();
		boolean locked = false;
		locked = RedisTool.tryLock(jedis, String.valueOf(billId), "generateOtherIn", 1000);
		logger.info("判断单据单据锁结果------"+locked);
		try{
			if (locked){
				ArrayList<Long> longs = new ArrayList<>();
				longs.add(billId);
				service.otherInOut(longs,true);
			}
			else{
				return CommonResponse.error("出现并发操作,请稍后重试！");
			}
		}catch (Exception e){
			e.printStackTrace();
		} finally {
			if(locked) {
				RedisTool.releaseLock(jedis, String.valueOf(billId), "generateOtherIn");
			}
			jedis.close();
			logger.info("辅料中心采购其他入库审批通过finally方法");
		}
		logger.info("辅料中心采购其他入库审批通过------billTypeCode-{},state-{}",billTypeCode,state);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OtherInEntity otherInEntity = service.selectById(billId);
		if(otherInEntity != null){
			CommonResponse commonResponse = checkService.checkByDate(otherInEntity.getStoreId(), DateFormatUtil.formatDate("yyyy-MM-dd", otherInEntity.getCheckDate()));
			return commonResponse;
		}
		StoreManageVO storeManageVO = new StoreManageVO();
		List<Long> SourceIds = new ArrayList<>();
		OtherInEntity entity = service.selectById(billId);
		List<OtherInDetailEntity> otherInList = entity.getOtherInDetailList();
		Boolean checkFlag = false;
		for (OtherInDetailEntity item: otherInList
		) {
			if(item.getInStoreNum().compareTo(BigDecimal.ZERO) > 0){
				checkFlag = true;
				break;
			}
		}
		if(checkFlag){
			SourceIds.add(billId);
			storeManageVO.setSourceId(billId);
			storeManageVO.setStoreId(entity.getStoreId());
			storeManageVO.setInOutTypeEnum(InOutTypeEnum.其他入库);
			storeManageVO.setSourceIdsForRollBack(SourceIds);
			storeManageVO.setOutEffectiveON(true);
			ArrayList<FlowVO> flowVOS = new ArrayList<>();
			otherInList.forEach(item -> {
				FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.其他入库, 0);
				flowVO.setStoreId(entity.getStoreId());
				flowVO.setStoreName(entity.getStoreName());
				flowVO.setOrgId(entity.getOrgId());
				flowVO.setOrgName(entity.getOrgName());
				flowVO.setParentOrgId(entity.getParentOrgId());
				flowVO.setParentOrgCode(entity.getParentOrgCode());
				flowVO.setParentOrgName(entity.getParentOrgName());
				flowVO.setEmployeeId(entity.getEmployeeId());
				flowVO.setEmployeeName(entity.getEmployeeName());
				flowVO.setMaterialCategoryId(item.getMaterialCategoryId());
				flowVO.setMaterialCategoryName(item.getMaterialCategoryName());
				flowVO.setMaterialId(item.getMaterialId());
				flowVO.setMaterialName(item.getMaterialName());
				flowVO.setMaterialSpec(item.getSpec());
				flowVO.setNum(item.getInStoreNum());
				flowVO.setTaxPrice(item.getTaxPrice());
				flowVO.setTaxMny(item.getInstoreTaxMny());
				flowVO.setMaterialUnitName(item.getUnitName());
				flowVO.setMaterialUnitId(item.getUnit());
				flowVO.setPrice(item.getPrice() != null ? item.getPrice() : item.getTaxPrice() );
				flowVO.setMny(item.getInstoreMny() != null ? item.getInstoreMny() : item.getInstoreTaxMny());
				flowVO.setTax(item.getInstoreTax() != null ? item.getInstoreTax() : BigDecimal.ZERO);
				flowVO.setTaxRate(item.getTaxRate());
				flowVO.setSourceId(entity.getId());
				flowVO.setSourceDetailId(item.getId());
				flowVO.setSourceBillCode(entity.getBillCode());
				flowVO.setSourceBillDate(entity.getCheckDate());
				flowVOS.add(flowVO);
			});
			storeManageVO.setFlowVOList(flowVOS);
			CommonResponse<StoreManageVO> storeManageVOCommonResponse = storeManageService.inOutStoreRollback(storeManageVO);
			if(!storeManageVOCommonResponse.isSuccess()) return CommonResponse.error(storeManageVOCommonResponse.getMsg());
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
