package com.ejianc.business.assist.store.service.impl;

import com.ejianc.business.assist.store.bean.OtherInDetailEntity;
import com.ejianc.business.assist.store.bean.OtherInEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.mapper.OtherInDetailMapper;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.util.StoreManageUtil;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.assist.store.mapper.OtherInMapper;
import com.ejianc.business.assist.store.service.IOtherInService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 其他入库
 * 
 * @author generator
 * 
 */
@Service("otherInService")
public class OtherInServiceImpl extends BaseServiceImpl<OtherInMapper, OtherInEntity> implements IOtherInService{

    @Autowired
    private OtherInDetailMapper otherInDetailMapper;

    @Autowired
    private StoreManageService storeManageService;


    @Override
    public CommonResponse saveCheckOtherIn(OtherInEntity entity) {
        //更新子表信息
        if(null != entity.getId()) {
            otherInDetailMapper.delByInId(entity.getId());
        }
        List<OtherInDetailEntity> otherInList = new ArrayList<>();
        List<OtherInDetailEntity> otherInDetailList = entity.getOtherInDetailList();
        for (OtherInDetailEntity detailEntity:otherInDetailList
        ) {
            if(detailEntity.getInStoreNum() != null && detailEntity.getInStoreNum().compareTo(BigDecimal.ZERO) > 0){
                otherInList.add(detailEntity);
            }
        }
        super.saveOrUpdate(entity, false);
        return CommonResponse.success(entity);
    }

    @Override
    public CommonResponse myRemoveByIds(List<Long> ids) {
        super.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public CommonResponse otherInOut(List<Long> ids,Boolean outEffectiveON){
        StoreManageVO storeManageVO = new StoreManageVO();
        List<Long> SourceIds = new ArrayList<>();
        for (Long item:ids
        ) {
            OtherInEntity entity = super.selectById(item);
            List<OtherInDetailEntity> otherInDetailList = entity.getOtherInDetailList();
            Boolean checkFlag = false;
            for (OtherInDetailEntity t : otherInDetailList
            ) {
                if (t.getInStoreNum().compareTo(BigDecimal.ZERO) > 0) {
                    checkFlag = true;
                    break;
                }
            }
            if(checkFlag){
                SourceIds.clear();
                SourceIds.add(item);
                storeManageVO.setSourceId(item);
                storeManageVO.setStoreId(entity.getStoreId());
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.其他入库);
                storeManageVO.setSourceIdsForRollBack(SourceIds);
                storeManageVO.setOutEffectiveON(outEffectiveON);
                CommonResponse<StoreManageVO> commonResponse;
                if(outEffectiveON){
                    ArrayList<FlowVO> flowVOS = new ArrayList<>();
                    otherInDetailList.forEach(e->{
                        FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.其他入库,0);
                        flowVO.setStoreId(entity.getStoreId());
                        flowVO.setStoreName(entity.getStoreName());
                        flowVO.setOrgId(entity.getOrgId());
                        flowVO.setOrgName(entity.getOrgName());
                        flowVO.setParentOrgId(entity.getParentOrgId());
                        flowVO.setParentOrgCode(entity.getParentOrgCode());
                        flowVO.setParentOrgName(entity.getParentOrgName());
                        flowVO.setEmployeeId(entity.getEmployeeId());
                        flowVO.setEmployeeName(entity.getEmployeeName());
                        flowVO.setMaterialCategoryId(e.getMaterialCategoryId());
                        flowVO.setMaterialCategoryName(e.getMaterialCategoryName());
                        flowVO.setMaterialId(e.getMaterialId());
                        flowVO.setMaterialName(e.getMaterialName());
                        flowVO.setMaterialSpec(e.getSpec());
                        flowVO.setNum(e.getInStoreNum());
                        flowVO.setTaxPrice(e.getTaxPrice());
                        flowVO.setTaxMny(e.getInstoreTaxMny());
                        flowVO.setMaterialUnitName(e.getUnitName());
                        flowVO.setMaterialUnitId(e.getUnit());
                        flowVO.setPrice(e.getPrice() != null ? e.getPrice() : e.getTaxPrice() );
                        flowVO.setMny(e.getInstoreMny() != null ? e.getInstoreMny() : e.getInstoreTaxMny());
                        flowVO.setTax(e.getInstoreTax() != null ? e.getInstoreTax() : BigDecimal.ZERO);
                        flowVO.setTaxRate(e.getTaxRate());
                        flowVO.setSourceId(entity.getId());
                        flowVO.setSourceDetailId(e.getId());
                        flowVO.setSourceBillCode(entity.getBillCode());
                        flowVO.setSourceBillDate(entity.getCheckDate());
                        flowVOS.add(flowVO);
                    });
                    storeManageVO.setFlowVOList(flowVOS);
                    commonResponse = storeManageService.inOutStore(storeManageVO);
                }else{
                    commonResponse = storeManageService.inOutStoreRollback(storeManageVO);
                }
                if(!commonResponse.isSuccess()){
                    return CommonResponse.error(commonResponse.getMsg());
                }
            }
        }
        return CommonResponse.success();
    };
}
