package com.ejianc.business.assist.material.service;

import com.ejianc.business.assist.material.bean.MaterialCheckDetailEntity;
import com.ejianc.business.assist.material.bean.MaterialCheckEntity;
import com.ejianc.business.assist.material.vo.MaterialCheckVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 验收单
 * 
 * @author generator
 * 
 */
public interface IMaterialCheckService extends IBaseService<MaterialCheckEntity> {

    MaterialCheckVO saveOrUpdate(MaterialCheckVO saveOrUpdateVO);

    void delete(List<MaterialCheckVO> vos);



    /**
     * 单据推送到供方协同服务
     *
     * @param entity 待推送单据
     * @return
     */
    boolean pushBillToSupCenter(MaterialCheckEntity entity);

    /**
     * 同步单据供应商签字信息
     *
     * @param request
     */
    String updateBillSupSignSyncInfo(HttpServletRequest request);

    /**
     * 将推送至供方的单据作废
     *
     * @param entity
     * @return
     */
    boolean delPushBill(MaterialCheckEntity entity);

    String validateTime(MaterialCheckVO materialCheckVO, String type);

    void submitChangeCheckNums(List<MaterialCheckDetailEntity> checkDetailList);

    void backChangeCheckNums(List<MaterialCheckDetailEntity> checkDetailList);

    void submitChangeCheckState(Long deliveryId, List<MaterialCheckDetailEntity> detailEntities);

    void backChangeCheckState(Long deliveryId, List<MaterialCheckDetailEntity> detailEntities);

}
