package com.ejianc.business.assist.store.service.impl;

import com.ejianc.business.assist.store.bean.ProcessEntity;
import com.ejianc.business.assist.store.bean.ProcessProductEntity;
import com.ejianc.business.assist.store.bean.ProcessRawEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.service.IProcessService;
import com.ejianc.business.assist.store.service.IStoreCheckService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.util.StoreManageUtil;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.transaction.annotation.Transactional;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Service("process") 
public class ProcessBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IProcessService service;

	@Autowired
	private IStoreCheckService checkService;

	@Autowired
	private StoreManageService storeManageService;

	@Autowired
	private JedisPool jedisPool;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Transactional(rollbackFor = Exception.class)
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//出库
		ArrayList<Long> longs = new ArrayList<>();
		longs.add(billId);
		service.processInOut(longs,true);
		//入库
		Jedis jedis = jedisPool.getResource();
		boolean locked = false;
		locked = RedisTool.tryLock(jedis, String.valueOf(billId), "generateProcessIn", 1000);
		logger.info("判断单据单据锁结果------"+locked);
		try{
			if (locked){
				ProcessEntity entity = service.selectById(billId);
				List<ProcessProductEntity> productList = new ArrayList<>();
				List<ProcessProductEntity> proceeProductList = entity.getProcessProductList();
				for (ProcessProductEntity detailEntity:proceeProductList
				) {
					if(detailEntity.getProcessNum() != null && detailEntity.getProcessNum().compareTo(BigDecimal.ZERO) > 0){
						productList.add(detailEntity);
					}
				}
				if(productList.size() > 0){
					StoreManageVO storeManageVO = new StoreManageVO();
					storeManageVO.setStoreId(entity.getStoreId());
					storeManageVO.setInOutTypeEnum(InOutTypeEnum.原材料加工入库);
					ArrayList<FlowVO> flowVOS = new ArrayList<>();
					productList.forEach(item->{
						FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.原材料加工入库,0);
						flowVO.setStoreId(entity.getStoreId());
						flowVO.setStoreName(entity.getStoreName());
						flowVO.setOrgId(entity.getOrgId());
						flowVO.setOrgName(entity.getOrgName());
						flowVO.setParentOrgId(entity.getParentOrgId());
						flowVO.setParentOrgCode(entity.getParentOrgCode());
						flowVO.setParentOrgName(entity.getParentOrgName());
						flowVO.setEmployeeId(entity.getEmployeeId());
						flowVO.setEmployeeName(entity.getEmployeeName());
						flowVO.setMaterialCategoryId(item.getMaterialTypeId());
						flowVO.setMaterialCategoryName(item.getMaterialTypeName());
						flowVO.setMaterialId(item.getMaterialId());
						flowVO.setMaterialName(item.getMaterialName());
						flowVO.setMaterialSpec(item.getSpec());
						flowVO.setMaterialUnitId(item.getUnitId());
						flowVO.setMaterialUnitName(item.getUnitName());
						flowVO.setNum(item.getProcessNum());
						flowVO.setTaxPrice(item.getTaxPrice());
						flowVO.setTaxMny(item.getTaxMny());
						flowVO.setPrice(item.getPrice());
						flowVO.setMny(item.getMny());
						flowVO.setTax(item.getTax());
						flowVO.setTaxRate(item.getTaxRate());
						flowVO.setNetMny(flowVO.getMny());
						flowVO.setNetTaxMny(flowVO.getTaxMny());
						flowVO.setPurchasePrice(flowVO.getPrice());
						flowVO.setPurchaseTaxPrice(flowVO.getTaxPrice());
						flowVO.setSourceId(entity.getId());
						flowVO.setSourceDetailId(item.getId());
						flowVO.setSourceBillCode(entity.getBillCode());
						flowVO.setSourceBillDate(entity.getProcessDate());
						flowVOS.add(flowVO);
					});
					storeManageVO.setSourceId(entity.getId());
					storeManageVO.setFlowVOList(flowVOS);
					CommonResponse<StoreManageVO> commonResponse = storeManageService.inOutStore(storeManageVO);
					if(!commonResponse.isSuccess()){
						return CommonResponse.error(commonResponse.getMsg());
					}
				}
			}
			else{
				return CommonResponse.error("出现并发操作,请稍后重试！");
			}
		}catch (Exception e){
			e.printStackTrace();
		} finally {
			if(locked) {
				RedisTool.releaseLock(jedis, String.valueOf(billId), "generateProcessIn");
			}
			jedis.close();
			logger.info("辅料中心采购原材料加工成品入库审批通过finally方法");
		}
		logger.info("辅料中心采购原材料加工审批通过------billTypeCode-{},state-{}",billTypeCode,state);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		ProcessEntity processEntity = service.selectById(billId);
		if(processEntity != null){
			CommonResponse commonResponse = checkService.checkByDate(processEntity.getStoreId(), DateFormatUtil.formatDate("yyyy-MM-dd", processEntity.getProcessDate()));
			if (!commonResponse.isSuccess()){
				return commonResponse;
			}
		}
		StoreManageVO storeManageVO = new StoreManageVO();
		List<Long> SourceIds = new ArrayList<>();
		ProcessEntity entity = service.selectById(billId);
		Boolean checkFlag = false;
		List<ProcessProductEntity> processProductList = entity.getProcessProductList();
		for (ProcessProductEntity item: processProductList
		) {
			if(item.getProcessNum().compareTo(BigDecimal.ZERO) > 0){
				checkFlag = true;
				break;
			}
		}
		if(checkFlag){
			SourceIds.add(billId);
			storeManageVO.setSourceId(billId);
			storeManageVO.setStoreId(entity.getStoreId());
			storeManageVO.setInOutTypeEnum(InOutTypeEnum.原材料加工入库);
			storeManageVO.setSourceIdsForRollBack(SourceIds);
			storeManageVO.setOutEffectiveON(true);
			CommonResponse<StoreManageVO> storeManageVOCommonResponse = storeManageService.inOutStoreRollback(storeManageVO);
			if(!storeManageVOCommonResponse.isSuccess()) return CommonResponse.error(storeManageVOCommonResponse.getMsg());
		}
		List<ProcessRawEntity> processRawList = entity.getProcessRawList();
		for (ProcessRawEntity item: processRawList
		) {
			if(item.getRawNum().compareTo(BigDecimal.ZERO) > 0){
				checkFlag = true;
				break;
			}
		}
		if(checkFlag){
			SourceIds.add(billId);
			storeManageVO.setSourceId(billId);
			storeManageVO.setStoreId(entity.getStoreId());
			storeManageVO.setInOutTypeEnum(InOutTypeEnum.原材料加工出库);
			storeManageVO.setSourceIdsForRollBack(SourceIds);
			storeManageVO.setOutEffectiveON(true);
			CommonResponse<StoreManageVO> storeManageVOCommonResponse = storeManageService.inOutStoreRollback(storeManageVO);
			if(!storeManageVOCommonResponse.isSuccess()) return CommonResponse.error(storeManageVOCommonResponse.getMsg());
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
