package com.ejianc.business.assist.store.service.impl;

import com.ejianc.business.assist.store.bean.ProcessProductEntity;
import com.ejianc.business.assist.store.bean.ProcessRawEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.mapper.ProcessProductMapper;
import com.ejianc.business.assist.store.mapper.ProcessRawMapper;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.util.StoreManageUtil;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.assist.store.mapper.ProcessMapper;
import com.ejianc.business.assist.store.bean.ProcessEntity;
import com.ejianc.business.assist.store.service.IProcessService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 原材料加工
 * 
 * @author generator
 * 
 */
@Service("processService")
public class ProcessServiceImpl extends BaseServiceImpl<ProcessMapper, ProcessEntity> implements IProcessService{
    @Autowired
    private ProcessRawMapper processRawMapper;

    @Autowired
    private StoreManageService storeManageService;

    @Autowired
    private ProcessProductMapper processProductMapper;

    @Override
    public CommonResponse saveCheckProcess(ProcessEntity entity) {
        //更新子表信息
        if(null != entity.getId()) {
            processRawMapper.delByProcessId(entity.getId());
//            processProductMapper.delByProcessId(entity.getId());
        }
        super.saveOrUpdate(entity, false);
        List<ProcessRawEntity> rawList = new ArrayList<>();
        List<ProcessRawEntity> proceeRawList = entity.getProcessRawList();
        for (ProcessRawEntity detailEntity:proceeRawList
        ) {
            if(detailEntity.getRawNum() != null && detailEntity.getRawNum().compareTo(BigDecimal.ZERO) > 0){
                rawList.add(detailEntity);
            }
        }
        if(rawList.size() > 0){
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.原材料加工出库);
            ArrayList<FlowVO> flowVOS = new ArrayList<>();
            rawList.forEach(item->{
                FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.原材料加工出库,0);
                flowVO.setStoreId(item.getStoreId());
                flowVO.setStoreName(item.getStoreName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgCode(entity.getParentOrgCode());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setMaterialCategoryId(item.getMaterialTypeId());
                flowVO.setMaterialCategoryName(item.getMaterialTypeName());
                flowVO.setMaterialId(item.getMaterialId());
                flowVO.setMaterialName(item.getMaterialName());
                flowVO.setMaterialSpec(item.getSpec());
                flowVO.setMaterialUnitId(item.getUnitId());
                flowVO.setMaterialUnitName(item.getUnitName());
                flowVO.setOutNetMny(item.getNetWorthMny());
                flowVO.setOutNetTaxMny(item.getNetWorthTaxMny());
                flowVO.setPurchasePrice(item.getOriginalValuePrice());
                flowVO.setPurchaseTaxPrice(item.getOriginalValueTaxPrice());
                flowVO.setNum(item.getRawNum());
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(item.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getProcessDate());
                flowVOS.add(flowVO);
            });
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setFlowVOList(flowVOS);
            CommonResponse<StoreManageVO> commonResponse = storeManageService.inOutStore(storeManageVO);
            if(!commonResponse.isSuccess()){
                return commonResponse;
            }
        }
        return CommonResponse.success(entity);
    }

    @Override
    public CommonResponse myRemoveByIds(List<Long> ids) {
        CommonResponse commonResponse = processInOut(ids,false);
        if(!commonResponse.isSuccess()){
            return commonResponse;
        }
        super.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public CommonResponse processInOut(List<Long> ids,Boolean outEffectiveON){
        StoreManageVO storeManageVO = new StoreManageVO();
        List<Long> SourceIds = new ArrayList<>();
        for (Long item:ids
        ) {
            ProcessEntity entity = super.selectById(item);
            Boolean checkFlag = false;
            List<ProcessRawEntity> processRawList = entity.getProcessRawList();
            for (ProcessRawEntity t:processRawList
            ) {
                if(t.getRawNum().compareTo(BigDecimal.ZERO) > 0){
                    checkFlag = true;
                    break;
                }
            }
            if(checkFlag){
                SourceIds.clear();
                SourceIds.add(item);
                storeManageVO.setSourceId(item);
                storeManageVO.setStoreId(entity.getStoreId());
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.原材料加工出库);
                storeManageVO.setSourceIdsForRollBack(SourceIds);
                storeManageVO.setOutEffectiveON(outEffectiveON);
                CommonResponse<StoreManageVO> commonResponse;
                if(outEffectiveON){
                    commonResponse = storeManageService.inOutStore(storeManageVO);
                }else{
                    commonResponse = storeManageService.inOutStoreRollback(storeManageVO);
                }
                if(!commonResponse.isSuccess()){
                    return commonResponse;
                }
            }
        }
        return CommonResponse.success();
    };
}
