/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.store.service.impl;

import com.ejianc.business.assist.store.bean.OtherInDetailEntity;
import com.ejianc.business.assist.store.bean.OtherInEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.mapper.OtherInDetailMapper;
import com.ejianc.business.assist.store.mapper.OtherInMapper;
import com.ejianc.business.assist.store.service.IOtherInService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.util.StoreManageUtil;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="otherInService")
public class OtherInServiceImpl
extends BaseServiceImpl<OtherInMapper, OtherInEntity>
implements IOtherInService {
    @Autowired
    private OtherInDetailMapper otherInDetailMapper;
    @Autowired
    private StoreManageService storeManageService;

    @Override
    public CommonResponse saveCheckOtherIn(OtherInEntity entity) {
        if (null != entity.getId()) {
            this.otherInDetailMapper.delByInId(entity.getId());
        }
        ArrayList<OtherInDetailEntity> otherInList = new ArrayList<OtherInDetailEntity>();
        List<OtherInDetailEntity> otherInDetailList = entity.getOtherInDetailList();
        for (OtherInDetailEntity detailEntity : otherInDetailList) {
            if (detailEntity.getInStoreNum() == null || detailEntity.getInStoreNum().compareTo(BigDecimal.ZERO) <= 0) continue;
            otherInList.add(detailEntity);
        }
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)((Object)entity));
    }

    @Override
    public CommonResponse myRemoveByIds(List<Long> ids) {
        super.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse otherInOut(List<Long> ids, Boolean outEffectiveON) {
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> SourceIds = new ArrayList<Long>();
        for (Long item : ids) {
            CommonResponse<StoreManageVO> commonResponse;
            OtherInEntity entity = (OtherInEntity)((Object)super.selectById((Serializable)item));
            List<OtherInDetailEntity> otherInDetailList = entity.getOtherInDetailList();
            Boolean checkFlag = false;
            for (OtherInDetailEntity t : otherInDetailList) {
                if (t.getInStoreNum().compareTo(BigDecimal.ZERO) <= 0) continue;
                checkFlag = true;
                break;
            }
            if (!checkFlag.booleanValue()) continue;
            SourceIds.clear();
            SourceIds.add(item);
            storeManageVO.setSourceId(item);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u5176\u4ed6\u5165\u5e93);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            storeManageVO.setOutEffectiveON(outEffectiveON);
            if (outEffectiveON.booleanValue()) {
                ArrayList flowVOS = new ArrayList();
                otherInDetailList.forEach(e -> {
                    FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u5176\u4ed6\u5165\u5e93, (Integer)0);
                    flowVO.setStoreId(entity.getStoreId());
                    flowVO.setStoreName(entity.getStoreName());
                    flowVO.setOrgId(entity.getOrgId());
                    flowVO.setOrgName(entity.getOrgName());
                    flowVO.setParentOrgId(entity.getParentOrgId());
                    flowVO.setParentOrgCode(entity.getParentOrgCode());
                    flowVO.setParentOrgName(entity.getParentOrgName());
                    flowVO.setEmployeeId(entity.getEmployeeId());
                    flowVO.setEmployeeName(entity.getEmployeeName());
                    flowVO.setMaterialCategoryId(e.getMaterialCategoryId());
                    flowVO.setMaterialCategoryName(e.getMaterialCategoryName());
                    flowVO.setMaterialId(e.getMaterialId());
                    flowVO.setMaterialName(e.getMaterialName());
                    flowVO.setMaterialSpec(e.getSpec());
                    flowVO.setNum(e.getInStoreNum());
                    flowVO.setTaxPrice(e.getTaxPrice());
                    flowVO.setTaxMny(e.getInstoreTaxMny());
                    flowVO.setMaterialUnitName(e.getUnitName());
                    flowVO.setMaterialUnitId(e.getUnit());
                    flowVO.setPrice(e.getPrice() != null ? e.getPrice() : e.getTaxPrice());
                    flowVO.setMny(e.getInstoreMny() != null ? e.getInstoreMny() : e.getInstoreTaxMny());
                    flowVO.setTax(e.getInstoreTax() != null ? e.getInstoreTax() : BigDecimal.ZERO);
                    flowVO.setTaxRate(e.getTaxRate());
                    flowVO.setNetMny(flowVO.getMny());
                    flowVO.setNetTaxMny(flowVO.getTaxMny());
                    flowVO.setPurchasePrice(flowVO.getPrice());
                    flowVO.setPurchaseTaxPrice(flowVO.getTaxPrice());
                    flowVO.setSourceId(entity.getId());
                    flowVO.setSourceDetailId(e.getId());
                    flowVO.setSourceBillCode(entity.getBillCode());
                    flowVO.setSourceBillDate(entity.getCheckDate());
                    flowVOS.add(flowVO);
                });
                storeManageVO.setFlowVOList(flowVOS);
                commonResponse = this.storeManageService.inOutStore(storeManageVO);
            } else {
                commonResponse = this.storeManageService.inOutStoreRollback(storeManageVO);
            }
            if (commonResponse.isSuccess()) continue;
            return CommonResponse.error((String)commonResponse.getMsg());
        }
        return CommonResponse.success();
    }
}

