/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.store.service.impl;

import com.ejianc.business.assist.store.bean.ProcessEntity;
import com.ejianc.business.assist.store.bean.ProcessProductEntity;
import com.ejianc.business.assist.store.bean.ProcessRawEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.service.IProcessService;
import com.ejianc.business.assist.store.service.IStoreCheckService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.util.StoreManageUtil;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="process")
public class ProcessBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProcessService service;
    @Autowired
    private IStoreCheckService checkService;
    @Autowired
    private StoreManageService storeManageService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ArrayList<Long> longs = new ArrayList<Long>();
        longs.add(billId);
        this.service.processInOut(longs, true);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ProcessEntity entity = (ProcessEntity)((Object)this.service.selectById(billId));
        ArrayList<ProcessProductEntity> productList = new ArrayList<ProcessProductEntity>();
        List<ProcessProductEntity> proceeProductList = entity.getProcessProductList();
        for (ProcessProductEntity detailEntity : proceeProductList) {
            if (detailEntity.getProcessNum() == null || detailEntity.getProcessNum().compareTo(BigDecimal.ZERO) <= 0) continue;
            productList.add(detailEntity);
        }
        if (productList.size() > 0) {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u539f\u6750\u6599\u52a0\u5de5\u5165\u5e93);
            ArrayList flowVOS = new ArrayList();
            productList.forEach(item -> {
                FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u539f\u6750\u6599\u52a0\u5de5\u5165\u5e93, (Integer)0);
                flowVO.setStoreId(entity.getStoreId());
                flowVO.setStoreName(entity.getStoreName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgCode(entity.getParentOrgCode());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setMaterialCategoryId(item.getMaterialTypeId());
                flowVO.setMaterialCategoryName(item.getMaterialTypeName());
                flowVO.setMaterialId(item.getMaterialId());
                flowVO.setMaterialCode(item.getMaterialCode());
                flowVO.setMaterialName(item.getMaterialName());
                flowVO.setMaterialSpec(item.getSpec());
                flowVO.setMaterialUnitId(item.getUnitId());
                flowVO.setMaterialUnitName(item.getUnitName());
                flowVO.setNum(item.getProcessNum());
                flowVO.setTaxPrice(item.getTaxPrice());
                flowVO.setTaxMny(item.getTaxMny());
                flowVO.setPrice(item.getPrice());
                flowVO.setMny(item.getMny());
                flowVO.setTax(item.getTax());
                flowVO.setTaxRate(item.getTaxRate());
                flowVO.setNetMny(flowVO.getMny());
                flowVO.setNetTaxMny(flowVO.getTaxMny());
                flowVO.setPurchasePrice(flowVO.getPrice());
                flowVO.setPurchaseTaxPrice(flowVO.getTaxPrice());
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(item.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getProcessDate());
                flowVOS.add(flowVO);
            });
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setFlowVOList(flowVOS);
            CommonResponse<StoreManageVO> commonResponse = this.storeManageService.inOutStore(storeManageVO);
            if (!commonResponse.isSuccess()) {
                return CommonResponse.error((String)commonResponse.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse commonResponse;
        ProcessEntity processEntity = (ProcessEntity)((Object)this.service.selectById(billId));
        if (processEntity != null && !(commonResponse = this.checkService.checkByDate(processEntity.getStoreId(), DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)processEntity.getProcessDate()))).isSuccess()) {
            return commonResponse;
        }
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> SourceIds = new ArrayList<Long>();
        ProcessEntity entity = (ProcessEntity)((Object)this.service.selectById(billId));
        Boolean checkFlag = false;
        List<ProcessProductEntity> processProductList = entity.getProcessProductList();
        for (Object item : processProductList) {
            if (item.getProcessNum().compareTo(BigDecimal.ZERO) <= 0) continue;
            checkFlag = true;
            break;
        }
        if (checkFlag.booleanValue()) {
            SourceIds.add(billId);
            storeManageVO.setSourceId(billId);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u539f\u6750\u6599\u52a0\u5de5\u5165\u5e93);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            CommonResponse<StoreManageVO> storeManageVOCommonResponse = this.storeManageService.inOutStoreRollback(storeManageVO);
            if (!storeManageVOCommonResponse.isSuccess()) {
                return CommonResponse.error((String)storeManageVOCommonResponse.getMsg());
            }
        }
        List<ProcessRawEntity> processRawList = entity.getProcessRawList();
        for (ProcessRawEntity item : processRawList) {
            if (item.getRawNum().compareTo(BigDecimal.ZERO) <= 0) continue;
            checkFlag = true;
            break;
        }
        if (checkFlag.booleanValue()) {
            SourceIds.add(billId);
            storeManageVO.setSourceId(billId);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u539f\u6750\u6599\u52a0\u5de5\u51fa\u5e93);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            CommonResponse<StoreManageVO> storeManageVOCommonResponse = this.storeManageService.inOutStoreRollback(storeManageVO);
            if (!storeManageVOCommonResponse.isSuccess()) {
                return CommonResponse.error((String)storeManageVOCommonResponse.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

