package com.ejianc.business.assist.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.material.bean.MaterialContractEntity;
import com.ejianc.business.assist.material.enums.BillTypeEnum;
import com.ejianc.business.assist.material.service.IMaterialContractAsyncService;
import com.ejianc.business.assist.material.service.IMaterialContractService;
import com.ejianc.business.assist.material.vo.MaterialContractVO;
import com.ejianc.business.assist.rmat.enums.*;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Service("materialContract") 
public class MaterialContractBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";

	@Autowired
    private IBillTypeApi billTypeApi;

	@Autowired
	private IMaterialContractService service;

	@Autowired
	private IMaterialContractAsyncService contractAsyncService;

	@Autowired
	private ISignatureCommonApi signatureCommonApi;

	@Autowired
	private IParamConfigApi paramConfigApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		
		/*
			起草方式为线下签订则不需要签章
			当不使用电子签章时：创建时默认为未签章，单据审批通过后自动更改为【已签章】
			当签章状态变为【已签章】时，合同状态变为【履约中】
		 */
		MaterialContractEntity entity = service.selectById(billId);
		if (entity != null){
//			if((DraftTypeEnum.线下签订.getCode().toString()).equals(entity.getDraftType())) {
//				// 线下签订合同无需进行签章操作，则审批通过后直接置为已生效状态
//				entity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
//				entity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
//			}

			if((DraftTypeEnum.线上起草.getCode().toString()).equals(entity.getDraftType()) && (null == entity.getContractFileId())) {
				// 确保线上起草方式时，用户已编辑合同文件
				return CommonResponse.error("请编辑合同文件并保存后再执行此操作！");
			}
		}
		
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		MaterialContractEntity e = service.selectById(billId);
		logger.info("审批节点审批中时节点审批前回调:  当前数据-{}", JSONObject.toJSONString(e));
		//线上起草且文件未同步
		if((DraftTypeEnum.线上起草.getCode().toString().equals(e.getDraftType()) || DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(e.getDraftType())) && !e.getContractFileSyncFlag()) {
			return CommonResponse.error("请重新进行合同编辑，同步单据信息到合同文件！");
		}


		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		
		/*
			起草方式为线下签订则不需要签章
			当不使用电子签章时：创建时默认为未签章，单据审批通过后自动更改为【已签章】
			当签章状态变为【已签章】时，合同状态变为【履约中】
		 */
		MaterialContractEntity entity = service.selectById(billId);
		if (entity != null){
			if((DraftTypeEnum.线下签订.getCode().toString()).equals(entity.getDraftType())) {
				// 线下签订合同无需进行签章操作，则审批通过后直接置为已生效状态
				entity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
				entity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
			}

			if((DraftTypeEnum.线上起草.getCode().toString()).equals(entity.getDraftType()) && (null == entity.getContractFileId())) {
				// 确保线上起草方式时，用户已编辑合同文件
				return CommonResponse.error("请编辑合同文件并保存后再执行此操作！");
			}

			if(DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType()) || DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(entity.getDraftType())) {
				if(null == entity.getContractFileId()) {
					//确保线上起草方式时，用户已编辑合同文件
					return CommonResponse.error("请编辑合同文件并保存后再执行此操作！");
				}
				if(!entity.getContractFileSyncFlag()) {
					return CommonResponse.error("请重新进行合同编辑，同步单据信息到合同文件！");
				}
			}

		}

		// 推送合同池
		Boolean pushResult = service.pushContract(BeanMapper.map(entity, MaterialContractVO.class));
		if(pushResult) {
			entity.setPushPoolFlag(BillPushStatusEnum.推送成功.getStatus());
		} else {
			entity.setPushPoolFlag(BillPushStatusEnum.未成功推送.getStatus());
		}

		// 水印系统参数
		CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
		if (!response.isSuccess() || response.getData() == null) {
			throw new BusinessException("获取水印系统参数请求失败，失败原因：" + response.getMsg());
		}
		String valueData = response.getData().getValueData();
		Assert.hasText(valueData, "获取的水印系统参数不能为空!");

		// 是否限制： 0:不限制，1:限制
		if ("0".equals(valueData)) {
			// 转换水印参数配置：默认规则
			WatermarkVO watermarkVO = signatureCommonApi.fetchWatermarkConfig(entity.getContractFileId(), entity.getId(),
					entity.getBillCode(), BillTypeEnum.辅料中心采购合同.getCode(), "amContract");
			Assert.notNull(watermarkVO, "获取水印系统参数失败!");
			// 获取上下文并异步调用添加水印
			HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
			HashMap<String, String> headers = new HashMap<>();
			headers.put("authority", request.getHeader("authority"));
			headers.put("ejc-token", request.getHeader("ejc-token"));
			contractAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
		}

		service.saveOrUpdate(entity);

		return CommonResponse.success();
		
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /*
			弃审逻辑：
			1、审批过程中，支持后台弃审；
			2、当审批通过，且没有走签章流程且没有下游业务时，支持后台弃审；
		 */
		MaterialContractEntity entity = service.selectById(billId);

		// 审批可以撤回的签章状态集合
		List<Integer> statusList = new ArrayList<>();
		statusList.add(SignatureStatusEnum.未签章.getCode());
		statusList.add(SignatureStatusEnum.已退回.getCode());
		statusList.add(SignatureStatusEnum.已撤回.getCode());
		statusList.add(SignatureStatusEnum.已过期.getCode());

		//使用电子签章且已有签章流程则不允许撤回
		if(DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType()) || DraftTypeEnum.上传合同.getCode().toString().equals(entity.getDraftType())) {
			if (!statusList.contains(entity.getSignatureStatus())){
				return CommonResponse.error("当前单据已有签章流程，不能撤回！");
			}
		}else if(SignatureStatusEnum.已签章.getCode().equals(entity.getSignatureStatus())) {
			entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
		}

		if(PerformanceStatusEnum.履约中.getCode().equals(entity.getPerformanceStatus())) {
			entity.setPerformanceStatus(PerformanceStatusEnum.未签订.getCode());
		}

		// 合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());

		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}
		
		// 从合同池删除数据
		boolean delResult = service.delContractFromPool(entity.getId());
		if(delResult) {
			entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());

		}

		// 删除文件中心水印文件
		if(entity.getWatermarkContractFileId() != null) {
			boolean delWatermarkflag = service.delWatermarkContractFile(entity.getWatermarkContractFileId());
			if (delWatermarkflag) {
				entity.setWatermarkContractFileId(null);
			}
		}

		service.saveOrUpdate(entity, false);

		return CommonResponse.success("弃审/撤回前校验回调成功！");
	}

}
