package com.ejianc.business.assist.store.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.store.bean.AllotOutEntity;
import com.ejianc.business.assist.store.consts.AllocationState;
import com.ejianc.business.assist.store.service.IAllotOutService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.vo.AllotOutVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.business.pro.ownrmat.api.IAllotOutApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.util.Objects;

@Service("allotOut")
public class AllotOutBpmServiceImpl implements ICommonBusinessService {


	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IAllotOutService service;
	@Autowired
	private JedisPool jedisPool;
	@Autowired
	private StoreManageService storeManageService;
	@Autowired
	private IAllotOutApi allotOutApi;


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO

		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//加锁防止生成多个调拨入库
		Jedis jedis = jedisPool.getResource();
		boolean locked = false;
		locked = RedisTool.tryLock(jedis, String.valueOf(billId), "generateAllotIn", 1000);
		if(locked) {
			RedisTool.releaseLock(jedis, String.valueOf(billId), "generateAllotIn");
		}
		locked = RedisTool.tryLock(jedis, String.valueOf(billId), "generateAllotIn", 1000);
		logger.info("判断单据单据锁结果------"+locked);
		try{
			if (locked){
				//更新流水
				AllotOutEntity allotOutEntity = service.selectById(billId);
				AllotOutVO allotoutvo = BeanMapper.map(allotOutEntity, AllotOutVO.class);
				StoreManageVO storeManageVO = allotoutvo.getStoreManageVO(allotoutvo);
				storeManageVO.setOutEffectiveON(true);
				CommonResponse<StoreManageVO> response = storeManageService.inOutStore(storeManageVO);
				if(!response.isSuccess()) {
					throw new BusinessException("调用库存管理失败,错误信息：" + response.getMsg());
				}
				if (!Objects.isNull(allotOutEntity)){
					//提交 收料状态设置带收清空退回原因
					LambdaUpdateWrapper<AllotOutEntity> allotOutWrapper = new LambdaUpdateWrapper<>();
					allotOutWrapper.eq(AllotOutEntity::getId, billId);
					allotOutWrapper.set(AllotOutEntity::getReceiveState, Integer.parseInt(AllocationState.TO_RECEIVING.getCode()));
					allotOutWrapper.set(AllotOutEntity::getReturnReason,null);
					allotOutWrapper.set(AllotOutEntity::getReceiverPersonId,null);
					allotOutWrapper.set(AllotOutEntity::getReceiverPerson,null);
					service.update(allotOutWrapper);

					if ("1".equals(allotOutEntity.getInAllocaScope())){
						AllotOutVO vo = BeanMapper.map(allotOutEntity, AllotOutVO.class);
						String msg = service.createAllotInBill(vo);
						if (null != msg){
							throw new BusinessException(msg);
						}
					}else{
						com.ejianc.business.pro.ownrmat.vo.AllotOutVO vo = BeanMapper.map(allotOutEntity, com.ejianc.business.pro.ownrmat.vo.AllotOutVO.class);
						CommonResponse<String> resp = allotOutApi.createAllotIn(vo);
						if (!resp.isSuccess()&&resp.getData()!=null){
							throw new BusinessException("生成调出单失败！");
						}
					}

					return CommonResponse.success();
				}else{
					throw new BusinessException("该单据不存在！");
				}
			}else{
				throw new BusinessException("出现并发操作,请稍后重试！");
			}
		}catch (Exception e){
			e.printStackTrace();
			return CommonResponse.error(e.getMessage());
		} finally {
			if(locked) {
				RedisTool.releaseLock(jedis, String.valueOf(billId), "generateAllotIn");
			}
			jedis.close();
		}
	}


	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		AllotOutEntity entity = service.selectById(billId);
		if (BillStateEnum.COMMITED_STATE.getBillStateCode() == entity.getBillState()|| BillStateEnum.PASSED_STATE.getBillStateCode() == entity.getBillState()){
			return CommonResponse.error("该单据已推送给调入方，不允许撤回！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
