/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.store.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.store.bean.FlowEntity;
import com.ejianc.business.assist.store.bean.SurplusEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.consts.StoreCommonConsts;
import com.ejianc.business.assist.store.mapper.FlowMapper;
import com.ejianc.business.assist.store.service.IFlowService;
import com.ejianc.business.assist.store.service.ISurplusService;
import com.ejianc.business.assist.store.vo.ComputeStoreVO;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.assist.store.vo.StoreApiVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.business.assist.store.vo.SurplusVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="flowService")
public class FlowServiceImpl
extends BaseServiceImpl<FlowMapper, FlowEntity>
implements IFlowService {
    @Autowired
    ISurplusService surplusService;

    @Override
    public CommonResponse<List<FlowEntity>> validateIsUse(Long sourceId, Long storeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"store_id", (Object)storeId);
        queryWrapper.eq((Object)"source_id", (Object)sourceId);
        queryWrapper.eq((Object)"in_out_flag", (Object)StoreCommonConsts.IN_OUT_TYPE_IN);
        List instoreList = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)instoreList)) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8be5\u5165\u5e93\u5355\u6d41\u6c34\u4fe1\u606f\uff01");
        }
        for (FlowEntity flow : instoreList) {
            Integer outUseFlag = flow.getOutUseFlag();
            if (!InOutTypeEnum.\u76f4\u5165\u76f4\u51fa\u5165\u5e93.getInOutType().equals(flow.getInOutType()) && (StoreCommonConsts.UseOutFlag.USEING.equals(outUseFlag) || StoreCommonConsts.UseOutFlag.USE_FINISH.equals(outUseFlag))) {
                return CommonResponse.error((String)("\u7269\u8d44[\u540d\u79f0\uff1a" + flow.getMaterialName() + "\uff0c\u89c4\u683c\uff1a" + StrUtil.emptyToDefault((CharSequence)flow.getMaterialSpec(), (String)"\u65e0") + "]\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de\uff01"));
            }
            Integer accountFlag = flow.getAccountFlag();
            if (StoreCommonConsts.ONE.equals(accountFlag)) {
                return CommonResponse.error((String)"\u5355\u636e\u5df2\u5bf9\u8d26\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de\uff01");
            }
            Integer settleFlag = flow.getSettleFlag();
            if (!StoreCommonConsts.ONE.equals(settleFlag)) continue;
            return CommonResponse.error((String)"\u5355\u636e\u5df2\u7ed3\u7b97\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de\uff01");
        }
        return CommonResponse.success((Object)instoreList);
    }

    @Override
    public List<FlowVO> queryInstoreFlowData(IPage<FlowVO> page, QueryWrapper wrapper) {
        return ((FlowMapper)this.baseMapper).queryInstoreFlowData(page, wrapper);
    }

    @Override
    public List<SurplusVO> computeStore(ComputeStoreVO computeStoreVO) {
        Long storeId = computeStoreVO.getStoreId();
        List materialIds = computeStoreVO.getMaterialIds();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"store_id", (Object)storeId);
        wrapper.in(CollectionUtils.isNotEmpty((Collection)materialIds), (Object)"material_id", (Collection)materialIds);
        List oldList = this.surplusService.list((Wrapper)wrapper);
        boolean updateFlag = computeStoreVO.getUpdateFlag();
        List<SurplusVO> newSurplusVOList = ((FlowMapper)this.baseMapper).computeStore(storeId, materialIds);
        Map<Long, List<SurplusVO>> newSurplusVOMap = newSurplusVOList.stream().collect(Collectors.groupingBy(SurplusVO::getMaterialId));
        ArrayList<Long> delIds = new ArrayList<Long>();
        Iterator it = oldList.iterator();
        while (it.hasNext()) {
            SurplusEntity t = (SurplusEntity)((Object)it.next());
            Long materialId = t.getMaterialId();
            List<SurplusVO> surplusVOS = newSurplusVOMap.get(materialId);
            if (CollectionUtils.isNotEmpty(surplusVOS)) {
                SurplusVO newSurplus = surplusVOS.get(0);
                t.setOutLockNum(newSurplus.getOutLockNum());
                t.setOutLockMny(newSurplus.getOutLockMny());
                t.setOutLockTaxMny(newSurplus.getOutLockTaxMny());
                t.setSurplusMny(newSurplus.getSurplusMny());
                t.setSurplusTaxMny(newSurplus.getSurplusTaxMny());
                t.setSurplusNum(newSurplus.getSurplusNum());
                t.setInstoreMny(newSurplus.getInstoreMny());
                t.setInstoreTaxMny(newSurplus.getInstoreTaxMny());
                t.setInstoreNum(newSurplus.getInstoreNum());
                t.setReturnGoodsNum(newSurplus.getReturnGoodsNum());
                continue;
            }
            delIds.add(t.getId());
            it.remove();
        }
        if (updateFlag) {
            this.surplusService.saveOrUpdateBatch(oldList);
            if (CollectionUtils.isNotEmpty(delIds)) {
                this.surplusService.removeByIds(delIds);
            }
        }
        List oldSurplusList = BeanMapper.mapList((Iterable)oldList, SurplusVO.class);
        return oldSurplusList;
    }

    @Override
    public StoreManageVO updateShareMny(StoreManageVO storeManageVO) {
        Long storeId = storeManageVO.getStoreId();
        List flowVOList = storeManageVO.getFlowVOList();
        if (CollectionUtils.isNotEmpty((Collection)flowVOList)) {
            Map<Long, List<FlowVO>> inFlowMap = flowVOList.stream().collect(Collectors.groupingBy(FlowVO::getSourceDetailId));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"store_id", (Object)storeId);
            queryWrapper.in((Object)"source_detail_id", new ArrayList<Long>(inFlowMap.keySet()));
            List list = this.list((Wrapper)queryWrapper);
            list.forEach(t -> {
                List flowVOS = (List)inFlowMap.get(t.getSourceDetailId());
                FlowVO flowVO = (FlowVO)flowVOS.get(0);
                BigDecimal shareMny = flowVO.getShareMny();
                BigDecimal shareTaxMny = flowVO.getShareTaxMny();
                Date lastShareDate = flowVO.getLastShareDate();
                t.setLastShareDate(lastShareDate);
                if (storeManageVO.getOutEffectiveON().booleanValue()) {
                    t.setShareMny(ComputeUtil.safeAdd((BigDecimal)t.getShareMny(), (BigDecimal)shareMny));
                    t.setShareTaxMny(ComputeUtil.safeAdd((BigDecimal)t.getShareTaxMny(), (BigDecimal)shareTaxMny));
                    t.setNetMny(ComputeUtil.safeSub((BigDecimal)t.getNetMny(), (BigDecimal)shareMny));
                    t.setNetTaxMny(ComputeUtil.safeSub((BigDecimal)t.getNetTaxMny(), (BigDecimal)shareTaxMny));
                } else {
                    t.setShareMny(ComputeUtil.safeSub((BigDecimal)t.getShareMny(), (BigDecimal)shareMny));
                    t.setShareTaxMny(ComputeUtil.safeSub((BigDecimal)t.getShareTaxMny(), (BigDecimal)shareTaxMny));
                    t.setNetMny(ComputeUtil.safeAdd((BigDecimal)t.getNetMny(), (BigDecimal)shareMny));
                    t.setNetTaxMny(ComputeUtil.safeAdd((BigDecimal)t.getNetTaxMny(), (BigDecimal)shareTaxMny));
                }
            });
            this.saveOrUpdateBatch(list);
            List flowVOS = BeanMapper.mapList((Iterable)list, FlowVO.class);
            storeManageVO.setFlowVOList(flowVOS);
        }
        return storeManageVO;
    }

    @Override
    public CommonResponse<JSONObject> validateTurnIsUseOutFlag(Long sourceId, Long storeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_id", (Object)sourceId);
        queryWrapper.and(wrapper -> (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.in((Object)"out_use_flag", Arrays.asList(StoreCommonConsts.UseOutFlag.USEING, StoreCommonConsts.UseOutFlag.USE_FINISH))).or()).gt((Object)"share_tax_mny", (Object)BigDecimal.ZERO));
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            FlowEntity flowEntity = (FlowEntity)((Object)list.get(0));
            return CommonResponse.error((String)("\u6750\u6599[\u540d\u79f0:" + flowEntity.getMaterialName() + ",\u89c4\u683c:" + StrUtil.emptyToDefault((CharSequence)flowEntity.getMaterialSpec(), (String)"\u65e0") + "]\u5df2\u51fa\u5e93\u6216\u644a\u9500,\u4e0d\u5141\u8bb8\u64a4\u56de!"));
        }
        queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_id", (Object)sourceId);
        queryWrapper.eq((Object)"in_out_flag", (Object)StoreCommonConsts.ONE);
        queryWrapper.eq((Object)"account_flag", (Object)StoreCommonConsts.ONE);
        list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u5165\u5e93\u5355\u636e\u5df2\u5bf9\u8d26,\u4e0d\u5141\u8bb8\u64a4\u56de!");
        }
        queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_id", (Object)sourceId);
        queryWrapper.eq((Object)"in_out_flag", (Object)StoreCommonConsts.ONE);
        queryWrapper.eq((Object)"settle_flag", (Object)StoreCommonConsts.ONE);
        list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u5165\u5e93\u5355\u636e\u5df2\u7ed3\u7b97,\u4e0d\u5141\u8bb8\u64a4\u56de!");
        }
        return CommonResponse.success();
    }

    @Override
    public List<StoreApiVO> queryStoreInstoreData(Page<StoreApiVO> page, QueryWrapper wrapper) {
        return ((FlowMapper)this.baseMapper).queryStoreInstoreData(page, wrapper);
    }

    @Override
    public List<FlowVO> queryTurnInstoreFlowData(Page<FlowVO> page, QueryWrapper wrapper) {
        return ((FlowMapper)this.baseMapper).queryTurnInstoreFlowData(page, wrapper);
    }

    @Override
    public Integer settleCount(HashMap<String, Object> map) {
        return ((FlowMapper)this.baseMapper).settleCount(map);
    }

    @Override
    public void changeSettleFlag(HashMap<String, Object> map) {
        ((FlowMapper)this.baseMapper).changeSettleFlag(map);
    }

    @Override
    public List<SurplusVO> computeStoreList(Page<SurplusVO> page, QueryWrapper wrapper) {
        return ((FlowMapper)this.baseMapper).computeStoreList(page, wrapper);
    }
}

