package com.ejianc.business.outrmat.contract.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 周转材租赁合同变更表
 *
 * @author generator
 */
@TableName("ejc_outrmat_contract_change")
public class OutRmatContractChangeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;


    @TableField(value = "contract_id")
    private Long contractId; // 合同id
    @TableField(value = "bill_code")
    private String billCode; // 单据编号
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态
    @TableField(value = "project_id")
    private Long projectId; // 项目ID
    @TableField(value = "project_code")
    private String projectCode; // 项目编码
    @TableField(value = "project_name")
    private String projectName; // 项目名称
    @TableField(value = "org_id")
    private Long orgId; // 项目组织ID
    @TableField(value = "org_code")
    private String orgCode; // 项目组织编码
    @TableField(value = "org_name")
    private String orgName; // 项目组织名称
    @TableField(value = "parent_org_id")
    private Long parentOrgId; // 父级组织ID
    @TableField(value = "parent_org_code")
    private String parentOrgCode; // 父级组织编码ID
    @TableField(value = "parent_org_name")
    private String parentOrgName; // 父级组织名称ID
    @TableField(value = "add_type")
    private Integer addType; // 合同新增方式：0-参照定标结果新增，1-直接新增
    @TableField(value = "rent_type")
    private String rentType; // 租赁方式：0-外租，1-内租
    @TableField(value = "target_result_id")
    private Long targetResultId; // 定标结果Id
    @TableField(value = "target_result_name")
    private String targetResultName; // 定标结果名称
    @TableField(value = "contract_name")
    private String contractName; // 合同名称
    @TableField(value = "project_address")
    private String projectAddress; // 项目地址
    @TableField(value = "contract_category_id")
    private Long contractCategoryId; // 合同类别Id
    @TableField(value = "contract_category_name")
    private String contractCategoryName; // 合同类别名称
    @TableField(value = "first_party_id")
    private Long firstPartyId; // 甲方Id
    @TableField(value = "first_party_name")
    private String firstPartyName; // 甲方名称
    @TableField(value = "first_party_project_manager_id")
    private Long firstPartyProjectManagerId; // 甲方项目负责人Id
    @TableField(value = "first_party_project_manager_name")
    private String firstPartyProjectManagerName; // 甲方项目负责人名称
    @TableField(value = "first_party_employee_id")
    private Long firstPartyEmployeeId; // 甲方经办人id
    @TableField(value = "first_party_employee_name")
    private String firstPartyEmployeeName; // 甲方经办人名称
    @TableField(value = "first_party_phone")
    private String firstPartyPhone; // 甲方电话
    @TableField(value = "supplier_id")
    private Long supplierId; // 乙方Id
    @TableField(value = "supplier_name")
    private String supplierName; // 乙方名称
    @TableField(value = "supplier_employee_id")
    private Long supplierEmployeeId; // 乙方经办人id
    @TableField(value = "supplier_employee_name")
    private String supplierEmployeeName; // 乙方经办人名称
    @TableField(value = "supplier_phone")
    private String supplierPhone; // 乙方电话
    @TableField(value = "supplier_address")
    private String supplierAddress; // 乙方地址
    @TableField(value = "sign_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签订日期
    @TableField(value = "rent_calculation_type")
    private String rentCalculationType; // 计租方式：0-日租，1-月租，2-工程量租
    @TableField(value = "month_settlement_day")
    private Integer monthSettlementDay; // 月结算日
    @TableField(value = "rent_calculation_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date rentCalculationDate; // 计租日期
    @TableField(value = "end_rent_calculation_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endRentCalculationDate; // 止租日期
    @TableField(value = "contract_mny")
    private BigDecimal contractMny; // 合同金额(不含税)
    @TableField(value = "contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value = "tax_rate")
    private BigDecimal taxRate; // 合同税率
    @TableField(value = "tax")
    private BigDecimal tax; // 合同税额
    @TableField(value = "supply_address")
    private String supplyAddress; // 供货地点
    @TableField(value = "performance_status")
    private String performanceStatus; // 合同履约状态：1-未签订，2-履约中，3-已终止，4-已作废，5-已冻结，6-已结束
    @TableField(value = "draft_type")
    private String draftType; // 起草方式：0-在线起草，1-上传合同，2-线下签订
    @TableField(value = "signature_status")
    private Integer signatureStatus; // 签章状态：0-未签章，2-待乙方签章，3-待甲方签章，4-已签章
    @TableField(value = "contract_file_path")
    private String contractFilePath; // 合同附件路径
    @TableField(value = "contract_file_id")
    private Long contractFileId; // 合同附件Id
    @TableField(value = "contract_template_id")
    private Long contractTemplateId; // 合同模板Id
    @TableField(value = "contract_template_name")
    private String contractTemplateName; // 合同模板名称
    @TableField(value = "contract_file_version_id")
    private Long contractFileVersionId; // 合同附件版本Id
    @TableField(value = "contract_file_version")
    private Long contractFileVersion; // 合同附件版本
    @TableField(value = "contract_file_highlight_path")
    private String contractFileHighlightPath; // 合同高亮附件路径
    @TableField(value = "contract_file_highlight_id")
    private Long contractFileHighlightId; // 合同高亮附件Id
    @TableField(value = "base_mny")
    private BigDecimal baseMny; // 初始版本金额(不含税)
    @TableField(value = "base_tax_mny")
    private BigDecimal baseTaxMny; // 初始版本金额
    @TableField(value = "before_change_mny")
    private BigDecimal beforeChangeMny; // 变更前金额(不含税)
    @TableField(value = "before_change_tax_mny")
    private BigDecimal beforeChangeTaxMny; // 变更前金额
    @TableField(value = "change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value = "change_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate; // 变更日期
    @TableField(value = "change_items")
    private String changeItems; // 变更项：用、号隔开。如：数量、单价、税率、甲方、乙方；
    @TableField(value = "change_employee_id")
    private Long changeEmployeeId; // 变更经办人id
    @TableField(value = "change_employee_name")
    private String changeEmployeeName; // 变更经办人名称
    @TableField(value = "change_mny")
    private BigDecimal changeMny; // 本次变更金额
    @TableField(value = "change_scale")
    private BigDecimal changeScale; // 本次变更比例
    @TableField(value = "change_tax")
    private BigDecimal changeTax; // 本次变更税率
    @TableField(value = "change_reason")
    private String changeReason; // 变更原因描述
    @TableField(value = "before_contract_name")
    private String beforeContractName; // 变更前合同名称
    @TableField(value = "change_draft_type")
    private String changeDraftType; // 变更起草方式：1-上传附件，2-线下签订
    @TableField(value = "change_file_id")
    private Long changeFileId; // 变更附件Id
    @TableField(value = "change_file_path")
    private String changeFilePath; // 变更附件路径
    @TableField(value = "change_contract_name")
    private String changeContractName; // 变更合同名称
    @TableField(value = "signed_file_id")
    private Long signedFileId; // 签章完成合同文件Id
    @TableField(value = "main_contract_id")
    private Long mainContractId; // 主合同Id
    @TableField(value = "main_contract_code")
    private String mainContractCode; // 主合同编码
    @TableField(value = "main_contract_name")
    private String mainContractName; // 主合同名称
    @TableField(value = "supplement_describe")
    private String supplementDescribe; // 补充项描述
    @TableField(value = "supplement_flag")
    private Integer supplementFlag; // 是否补充协议：0-否，1-是
    @TableField(value = "main_contract_create_date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date mainContractCreateDate; // 主合同创建日期(用于合同、补充协议排序)
    @TableField(value = "department_id")
    private Long departmentId; // 经办部门
    @TableField(value = "department_name")
    private String departmentName; // 经办部门名称
    @TableField(value = "memo")
    private String memo; // 备注

    @TableField("commit_date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commitDate; // 提交日期
    @TableField(value = "project_new_type")
    private String projectNewType; // 项目类型分类

    @TableField(value = "first_party_entrusted_agent_id")
    private Long firstPartyEntrustedAgentId; // 甲方委托代理人id
    @TableField(value = "first_party_entrusted_agent_name")
    private String firstPartyEntrustedAgentName; // 甲方委托代理人名称
    @TableField(value = "first_party_principal_id")
    private Long firstPartyPrincipalId; // 甲方负责人id
    @TableField(value = "first_party_principal_name")
    private String firstPartyPrincipalName; // 甲方负责人名称
    @TableField(value = "first_party_address")
    private String firstPartyAddress; // 甲方地址
    @TableField(value = "supplier_principal_id")
    private Long supplierPrincipalId; // 乙方单位负责人id
    @TableField(value = "supplier_principal_name")
    private String supplierPrincipalName; // 乙方单位负责人名称
    @TableField(value = "material_clerk_one_id")
    private Long materialClerkOneId; // 材料员一id
    @TableField(value = "material_clerk_one_name")
    private String materialClerkOneName; // 材料员一名称
    @TableField(value = "material_clerk_one_phone")
    private String materialClerkOnePhone; // 材料员一联系方式
    @TableField(value = "material_clerk_two_id")
    private Long materialClerkTwoId; // 材料员二id
    @TableField(value = "material_clerk_two_name")
    private String materialClerkTwoName; // 材料员二名称
    @TableField(value = "material_clerk_two_phone")
    private String materialClerkTwoPhone; // 材料员二联系方式

    @TableField("watermark_contract_change_file_id")
    private Long watermarkContractChangeFileId; // 水印合同附件Id
    @TableField("signed_change_file_id")
    private Long signedChangeFileId; // 签章完成合同变更文件Id


    @TableField(exist = false)
    @SubEntity(serviceName = "changeDailyRentService", pidName = "changeId")
    private List<OutRmatContractChangeDailyRentEntity> dailyRentList = new ArrayList<>(); // 周转材租赁合同-日租明细变更表
    @TableField(exist = false)
    @SubEntity(serviceName = "changeMonthRentService", pidName = "changeId")
    private List<OutRmatContractChangeMonthRentEntity> monthRentList = new ArrayList<>(); // 周转材租赁合同-月租明细变更表
    @TableField(exist = false)
    @SubEntity(serviceName = "changeNumRentService", pidName = "changeId")
    private List<OutRmatContractChangeNumRentEntity> numRentList = new ArrayList<>(); // 周转材租赁合同-工程量租明细表更表
    @TableField(exist = false)
    @SubEntity(serviceName = "changeRepairService", pidName = "changeId")
    private List<OutRmatContractChangeRepairEntity> repairList = new ArrayList<>(); // 周转材租赁合同-维修标准变更表
    @TableField(exist = false)
    @SubEntity(serviceName = "changeScrapService", pidName = "changeId")
    private List<OutRmatContractChangeScrapEntity> scrapList = new ArrayList<>(); // 周转材租赁合同-报废标准变更表
    @TableField(exist = false)
    @SubEntity(serviceName = "changeOtherService", pidName = "changeId")
    private List<OutRmatContractChangeOtherEntity> otherList = new ArrayList<>(); // 周转材租赁合同-其他费用变更表
    @TableField(exist = false)
    @SubEntity(serviceName = "changePaymentService", pidName = "changeId")
    private List<OutRmatContractChangePaymentEntity> paymentList = new ArrayList<>(); // 周转材租赁合同-付款阶段变更表
    @TableField(exist = false)
    @SubEntity(serviceName = "changeClauseService", pidName = "changeId")
    private List<OutRmatContractChangeClauseEntity> clauseList = new ArrayList<>(); // 周转材租赁合同-合同条款变更表


    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Integer getAddType() {
        return addType;
    }

    public void setAddType(Integer addType) {
        this.addType = addType;
    }

    public String getRentType() {
        return rentType;
    }

    public void setRentType(String rentType) {
        this.rentType = rentType;
    }

    public Long getTargetResultId() {
        return targetResultId;
    }

    public void setTargetResultId(Long targetResultId) {
        this.targetResultId = targetResultId;
    }

    public String getTargetResultName() {
        return targetResultName;
    }

    public void setTargetResultName(String targetResultName) {
        this.targetResultName = targetResultName;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }

    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }

    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }

    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    public Long getFirstPartyProjectManagerId() {
        return firstPartyProjectManagerId;
    }

    public void setFirstPartyProjectManagerId(Long firstPartyProjectManagerId) {
        this.firstPartyProjectManagerId = firstPartyProjectManagerId;
    }

    public String getFirstPartyProjectManagerName() {
        return firstPartyProjectManagerName;
    }

    public void setFirstPartyProjectManagerName(String firstPartyProjectManagerName) {
        this.firstPartyProjectManagerName = firstPartyProjectManagerName;
    }

    public Long getFirstPartyEmployeeId() {
        return firstPartyEmployeeId;
    }

    public void setFirstPartyEmployeeId(Long firstPartyEmployeeId) {
        this.firstPartyEmployeeId = firstPartyEmployeeId;
    }

    public String getFirstPartyEmployeeName() {
        return firstPartyEmployeeName;
    }

    public void setFirstPartyEmployeeName(String firstPartyEmployeeName) {
        this.firstPartyEmployeeName = firstPartyEmployeeName;
    }

    public String getFirstPartyPhone() {
        return firstPartyPhone;
    }

    public void setFirstPartyPhone(String firstPartyPhone) {
        this.firstPartyPhone = firstPartyPhone;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Long getSupplierEmployeeId() {
        return supplierEmployeeId;
    }

    public void setSupplierEmployeeId(Long supplierEmployeeId) {
        this.supplierEmployeeId = supplierEmployeeId;
    }

    public String getSupplierEmployeeName() {
        return supplierEmployeeName;
    }

    public void setSupplierEmployeeName(String supplierEmployeeName) {
        this.supplierEmployeeName = supplierEmployeeName;
    }

    public String getSupplierPhone() {
        return supplierPhone;
    }

    public void setSupplierPhone(String supplierPhone) {
        this.supplierPhone = supplierPhone;
    }

    public String getSupplierAddress() {
        return supplierAddress;
    }

    public void setSupplierAddress(String supplierAddress) {
        this.supplierAddress = supplierAddress;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public String getRentCalculationType() {
        return rentCalculationType;
    }

    public void setRentCalculationType(String rentCalculationType) {
        this.rentCalculationType = rentCalculationType;
    }

    public Integer getMonthSettlementDay() {
        return monthSettlementDay;
    }

    public void setMonthSettlementDay(Integer monthSettlementDay) {
        this.monthSettlementDay = monthSettlementDay;
    }

    public Date getRentCalculationDate() {
        return rentCalculationDate;
    }

    public void setRentCalculationDate(Date rentCalculationDate) {
        this.rentCalculationDate = rentCalculationDate;
    }

    public Date getEndRentCalculationDate() {
        return endRentCalculationDate;
    }

    public void setEndRentCalculationDate(Date endRentCalculationDate) {
        this.endRentCalculationDate = endRentCalculationDate;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public String getSupplyAddress() {
        return supplyAddress;
    }

    public void setSupplyAddress(String supplyAddress) {
        this.supplyAddress = supplyAddress;
    }

    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }

    public String getDraftType() {
        return draftType;
    }

    public void setDraftType(String draftType) {
        this.draftType = draftType;
    }

    public Integer getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(Integer signatureStatus) {
        this.signatureStatus = signatureStatus;
    }

    public String getContractFilePath() {
        return contractFilePath;
    }

    public void setContractFilePath(String contractFilePath) {
        this.contractFilePath = contractFilePath;
    }

    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }

    public Long getContractTemplateId() {
        return contractTemplateId;
    }

    public void setContractTemplateId(Long contractTemplateId) {
        this.contractTemplateId = contractTemplateId;
    }

    public String getContractTemplateName() {
        return contractTemplateName;
    }

    public void setContractTemplateName(String contractTemplateName) {
        this.contractTemplateName = contractTemplateName;
    }

    public Long getContractFileVersionId() {
        return contractFileVersionId;
    }

    public void setContractFileVersionId(Long contractFileVersionId) {
        this.contractFileVersionId = contractFileVersionId;
    }

    public Long getContractFileVersion() {
        return contractFileVersion;
    }

    public void setContractFileVersion(Long contractFileVersion) {
        this.contractFileVersion = contractFileVersion;
    }

    public String getContractFileHighlightPath() {
        return contractFileHighlightPath;
    }

    public void setContractFileHighlightPath(String contractFileHighlightPath) {
        this.contractFileHighlightPath = contractFileHighlightPath;
    }

    public Long getContractFileHighlightId() {
        return contractFileHighlightId;
    }

    public void setContractFileHighlightId(Long contractFileHighlightId) {
        this.contractFileHighlightId = contractFileHighlightId;
    }

    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }

    public BigDecimal getBaseTaxMny() {
        return baseTaxMny;
    }

    public void setBaseTaxMny(BigDecimal baseTaxMny) {
        this.baseTaxMny = baseTaxMny;
    }

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public String getChangeItems() {
        return changeItems;
    }

    public void setChangeItems(String changeItems) {
        this.changeItems = changeItems;
    }

    public Long getChangeEmployeeId() {
        return changeEmployeeId;
    }

    public void setChangeEmployeeId(Long changeEmployeeId) {
        this.changeEmployeeId = changeEmployeeId;
    }

    public String getChangeEmployeeName() {
        return changeEmployeeName;
    }

    public void setChangeEmployeeName(String changeEmployeeName) {
        this.changeEmployeeName = changeEmployeeName;
    }

    public BigDecimal getChangeMny() {
        return changeMny;
    }

    public void setChangeMny(BigDecimal changeMny) {
        this.changeMny = changeMny;
    }

    public BigDecimal getChangeScale() {
        return changeScale;
    }

    public void setChangeScale(BigDecimal changeScale) {
        this.changeScale = changeScale;
    }

    public BigDecimal getChangeTax() {
        return changeTax;
    }

    public void setChangeTax(BigDecimal changeTax) {
        this.changeTax = changeTax;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public String getBeforeContractName() {
        return beforeContractName;
    }

    public void setBeforeContractName(String beforeContractName) {
        this.beforeContractName = beforeContractName;
    }

    public String getChangeDraftType() {
        return changeDraftType;
    }

    public void setChangeDraftType(String changeDraftType) {
        this.changeDraftType = changeDraftType;
    }

    public Long getChangeFileId() {
        return changeFileId;
    }

    public void setChangeFileId(Long changeFileId) {
        this.changeFileId = changeFileId;
    }

    public String getChangeFilePath() {
        return changeFilePath;
    }

    public void setChangeFilePath(String changeFilePath) {
        this.changeFilePath = changeFilePath;
    }

    public String getChangeContractName() {
        return changeContractName;
    }

    public void setChangeContractName(String changeContractName) {
        this.changeContractName = changeContractName;
    }

    public Long getSignedFileId() {
        return signedFileId;
    }

    public void setSignedFileId(Long signedFileId) {
        this.signedFileId = signedFileId;
    }

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }

    public String getSupplementDescribe() {
        return supplementDescribe;
    }

    public void setSupplementDescribe(String supplementDescribe) {
        this.supplementDescribe = supplementDescribe;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public Date getMainContractCreateDate() {
        return mainContractCreateDate;
    }

    public void setMainContractCreateDate(Date mainContractCreateDate) {
        this.mainContractCreateDate = mainContractCreateDate;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getProjectNewType() {
        return projectNewType;
    }

    public void setProjectNewType(String projectNewType) {
        this.projectNewType = projectNewType;
    }

    public Long getFirstPartyEntrustedAgentId() {
        return firstPartyEntrustedAgentId;
    }

    public void setFirstPartyEntrustedAgentId(Long firstPartyEntrustedAgentId) {
        this.firstPartyEntrustedAgentId = firstPartyEntrustedAgentId;
    }

    public String getFirstPartyEntrustedAgentName() {
        return firstPartyEntrustedAgentName;
    }

    public void setFirstPartyEntrustedAgentName(String firstPartyEntrustedAgentName) {
        this.firstPartyEntrustedAgentName = firstPartyEntrustedAgentName;
    }

    public Long getFirstPartyPrincipalId() {
        return firstPartyPrincipalId;
    }

    public void setFirstPartyPrincipalId(Long firstPartyPrincipalId) {
        this.firstPartyPrincipalId = firstPartyPrincipalId;
    }

    public String getFirstPartyPrincipalName() {
        return firstPartyPrincipalName;
    }

    public void setFirstPartyPrincipalName(String firstPartyPrincipalName) {
        this.firstPartyPrincipalName = firstPartyPrincipalName;
    }

    public String getFirstPartyAddress() {
        return firstPartyAddress;
    }

    public void setFirstPartyAddress(String firstPartyAddress) {
        this.firstPartyAddress = firstPartyAddress;
    }

    public Long getSupplierPrincipalId() {
        return supplierPrincipalId;
    }

    public void setSupplierPrincipalId(Long supplierPrincipalId) {
        this.supplierPrincipalId = supplierPrincipalId;
    }

    public String getSupplierPrincipalName() {
        return supplierPrincipalName;
    }

    public void setSupplierPrincipalName(String supplierPrincipalName) {
        this.supplierPrincipalName = supplierPrincipalName;
    }

    public Long getMaterialClerkOneId() {
        return materialClerkOneId;
    }

    public void setMaterialClerkOneId(Long materialClerkOneId) {
        this.materialClerkOneId = materialClerkOneId;
    }

    public String getMaterialClerkOneName() {
        return materialClerkOneName;
    }

    public void setMaterialClerkOneName(String materialClerkOneName) {
        this.materialClerkOneName = materialClerkOneName;
    }

    public String getMaterialClerkOnePhone() {
        return materialClerkOnePhone;
    }

    public void setMaterialClerkOnePhone(String materialClerkOnePhone) {
        this.materialClerkOnePhone = materialClerkOnePhone;
    }

    public Long getMaterialClerkTwoId() {
        return materialClerkTwoId;
    }

    public void setMaterialClerkTwoId(Long materialClerkTwoId) {
        this.materialClerkTwoId = materialClerkTwoId;
    }

    public String getMaterialClerkTwoName() {
        return materialClerkTwoName;
    }

    public void setMaterialClerkTwoName(String materialClerkTwoName) {
        this.materialClerkTwoName = materialClerkTwoName;
    }

    public String getMaterialClerkTwoPhone() {
        return materialClerkTwoPhone;
    }

    public void setMaterialClerkTwoPhone(String materialClerkTwoPhone) {
        this.materialClerkTwoPhone = materialClerkTwoPhone;
    }

    public Long getWatermarkContractChangeFileId() {
        return watermarkContractChangeFileId;
    }

    public void setWatermarkContractChangeFileId(Long watermarkContractChangeFileId) {
        this.watermarkContractChangeFileId = watermarkContractChangeFileId;
    }

    public Long getSignedChangeFileId() {
        return signedChangeFileId;
    }

    public void setSignedChangeFileId(Long signedChangeFileId) {
        this.signedChangeFileId = signedChangeFileId;
    }

    public List<OutRmatContractChangeDailyRentEntity> getDailyRentList() {
        return dailyRentList;
    }

    public void setDailyRentList(List<OutRmatContractChangeDailyRentEntity> dailyRentList) {
        this.dailyRentList = dailyRentList;
    }

    public List<OutRmatContractChangeMonthRentEntity> getMonthRentList() {
        return monthRentList;
    }

    public void setMonthRentList(List<OutRmatContractChangeMonthRentEntity> monthRentList) {
        this.monthRentList = monthRentList;
    }

    public List<OutRmatContractChangeNumRentEntity> getNumRentList() {
        return numRentList;
    }

    public void setNumRentList(List<OutRmatContractChangeNumRentEntity> numRentList) {
        this.numRentList = numRentList;
    }

    public List<OutRmatContractChangeRepairEntity> getRepairList() {
        return repairList;
    }

    public void setRepairList(List<OutRmatContractChangeRepairEntity> repairList) {
        this.repairList = repairList;
    }

    public List<OutRmatContractChangeScrapEntity> getScrapList() {
        return scrapList;
    }

    public void setScrapList(List<OutRmatContractChangeScrapEntity> scrapList) {
        this.scrapList = scrapList;
    }

    public List<OutRmatContractChangeOtherEntity> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<OutRmatContractChangeOtherEntity> otherList) {
        this.otherList = otherList;
    }

    public List<OutRmatContractChangePaymentEntity> getPaymentList() {
        return paymentList;
    }

    public void setPaymentList(List<OutRmatContractChangePaymentEntity> paymentList) {
        this.paymentList = paymentList;
    }

    public List<OutRmatContractChangeClauseEntity> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<OutRmatContractChangeClauseEntity> clauseList) {
        this.clauseList = clauseList;
    }
}
