package com.ejianc.business.outrmat.contract.service;

import com.ejianc.business.outrmat.contract.bean.OutRmatContractChangeEntity;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractChangeVO;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractRecordVO;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractVO;
import com.ejianc.business.outrmat.contract.vo.record.OutRmatContractChangeRecordVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * 周转材租赁合同变更表
 * 
 * @author generator
 * 
 */
public interface IOutRmatContractChangeService extends IBaseService<OutRmatContractChangeEntity> {

    OutRmatContractChangeVO saveOrUpdate(@RequestBody OutRmatContractChangeVO saveOrUpdateVO);

    OutRmatContractChangeRecordVO queryChangeRecord(Long id);

    OutRmatContractChangeVO queryContractRecordDetail(Long id);
    
    CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState);


    void deleteByIds(List<OutRmatContractChangeVO> vos);

    Map<String, Object> queryChangeCompare(Long id);

    /**
     * 推送(更新)合同池
     * @param vo
     * @param updateLevel
     * @return
     */
    Boolean pushContract(OutRmatContractVO vo, String updateLevel);


}
