/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.rmat.bean.ChangeEntity;
import com.ejianc.business.assist.rmat.bean.ContractEntity;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.service.IChangeService;
import com.ejianc.business.assist.rmat.service.IContractFileService;
import com.ejianc.business.assist.rmat.service.IContractService;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractFileService")
public class ContractFileServiceImpl
implements IContractFileService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;

    @Override
    public JSONObject getSignedFileInfo(Long billId, String billType) {
        BaseEntity entity;
        JSONObject resp = new JSONObject();
        ArrayList<ContractVO> voList = new ArrayList<ContractVO>();
        ContractVO vo = new ContractVO();
        if (Objects.equals("contract", billType)) {
            entity = (ContractEntity)((Object)this.contractService.selectById(billId));
            vo.setContractId(entity.getId());
            vo.setContractName(entity.getContractName());
            vo.setBillType(BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u5165\u5408\u540c.getCode());
            vo.setSourceType(billType);
        } else {
            entity = (ChangeEntity)((Object)this.changeService.selectById(billId));
            vo.setContractId(entity.getId());
            vo.setContractName(entity.getContractName());
            vo.setBillType(BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u5165\u5408\u540c\u53d8\u66f4.getCode());
            vo.setSourceType(billType);
        }
        voList.add(vo);
        CommonResponse signResp = this.signatureCommonApi.fetchSignedContract(voList);
        if (!signResp.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5355\u636eid-{}\uff0cbillType-{}\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\u5931\u8d25: {}", new Object[]{billId, billType, signResp.getMsg()});
            throw new BusinessException("\u83b7\u53d6\u5408\u540c\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\u5931\u8d25!");
        }
        List fileList = (List)signResp.getData();
        if (CollectionUtils.isEmpty((Collection)fileList)) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u5408\u540c\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\uff01");
        }
        SignMgrPreviewVO signedFileInfo = (SignMgrPreviewVO)((List)signResp.getData()).get(0);
        if ("contract".equals(billType)) {
            ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(billId));
            if (Objects.equals(contract.getSignedFileId(), null)) {
                contract.setSignedFileId(signedFileInfo.getFileId());
                this.contractService.saveOrUpdate((Object)contract, false);
            }
        } else {
            ChangeEntity contractChange = (ChangeEntity)((Object)this.changeService.selectById(billId));
            if (Objects.equals(contractChange.getSignedChangeFileId(), null)) {
                contractChange.setSignedChangeFileId(signedFileInfo.getFileId());
                this.changeService.saveOrUpdate((Object)contractChange, false);
            }
        }
        resp.put("fileId", (Object)signedFileInfo.getFileId());
        resp.put("filePath", (Object)signedFileInfo.getFilePath());
        resp.put("fileTruePath", (Object)signedFileInfo.getTruePath());
        return resp;
    }
}

