/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outrmat.order.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.rmat.bean.ConvertEntity;
import com.ejianc.business.assist.rmat.service.IConvertService;
import com.ejianc.business.assist.rmat.vo.ConvertIdVO;
import com.ejianc.business.assist.rmat.vo.ConvertRequest;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractService;
import com.ejianc.business.outrmat.order.bean.OutRmatOrderDetailEntity;
import com.ejianc.business.outrmat.order.service.IOutRmatOrderDetailService;
import com.ejianc.business.outrmat.order.vo.OutRmatOrderDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"outRmatOrderDetail"})
public class OutRmatOrderDetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IConvertService convertService;
    @Autowired
    private IOutRmatContractService outRmatContractService;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IOutRmatOrderDetailService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutRmatOrderDetailVO> saveOrUpdate(@RequestBody OutRmatOrderDetailVO saveOrUpdateVO) {
        BillCodeParam billCodeParam;
        CommonResponse billCode;
        OutRmatOrderDetailEntity entity = (OutRmatOrderDetailEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OutRmatOrderDetailEntity.class));
        if (!(entity.getId() != null && entity.getId() != 0L || (billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess())) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.service.saveOrUpdate((Object)entity, false);
        OutRmatOrderDetailVO vo = (OutRmatOrderDetailVO)BeanMapper.map((Object)((Object)entity), OutRmatOrderDetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutRmatOrderDetailVO> queryDetail(Long id) {
        OutRmatOrderDetailEntity entity = (OutRmatOrderDetailEntity)((Object)this.service.selectById(id));
        OutRmatOrderDetailVO vo = (OutRmatOrderDetailVO)BeanMapper.map((Object)((Object)entity), OutRmatOrderDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutRmatOrderDetailVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (OutRmatOrderDetailVO outRmatOrderDetailVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OutRmatOrderDetailVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutRmatOrderDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("OutRmatOrderDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refOutRmatOrderDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutRmatOrderDetailVO>> refOutRmatOrderDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        Map conditionMap;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("spec");
        Long contractId = null;
        Long orgId = null;
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null == conditionMap.get("contractId")) {
                return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u5408\u540cid\u4e3a\u7a7a\uff01");
            }
        } else {
            return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)new Page(page.getCurrent(), page.getSize(), page.getTotal()));
        }
        contractId = Long.valueOf(conditionMap.get("contractId").toString());
        orgId = 1495943087871991809L;
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<OutRmatOrderDetailVO> list = this.service.geOutRmatOrderDetail(wrapper, contractId);
        ConvertRequest convertRequest = new ConvertRequest();
        ConvertRequest convertRequest2 = new ConvertRequest();
        convertRequest.setOrgId(orgId);
        convertRequest2.setOrgId(orgId);
        ArrayList<Object> detailCon = new ArrayList<Object>();
        ArrayList<ConvertIdVO> detailCon2 = new ArrayList<ConvertIdVO>();
        for (OutRmatOrderDetailVO outRmatOrderDetailVO : list) {
            ConvertIdVO detailIdVO = new ConvertIdVO();
            detailIdVO.setMaterialId(outRmatOrderDetailVO.getMaterialId());
            detailIdVO.setUnitId(outRmatOrderDetailVO.getUnitId());
            detailIdVO.setUnitMId(outRmatOrderDetailVO.getUnitMId());
            detailCon.add(detailIdVO);
            ConvertIdVO detailIdVO2 = new ConvertIdVO();
            detailIdVO2.setMaterialId(outRmatOrderDetailVO.getMaterialId());
            detailIdVO2.setUnitId(outRmatOrderDetailVO.getUnitMId());
            detailIdVO2.setUnitMId(outRmatOrderDetailVO.getUnitId());
            detailCon2.add(detailIdVO2);
        }
        convertRequest.setConvertIds(detailCon);
        convertRequest2.setConvertIds(detailCon2);
        Map<String, ConvertEntity> residualRate = this.convertService.getResidualRate(convertRequest);
        Map<String, ConvertEntity> residualRate2 = this.convertService.getResidualRate(convertRequest2);
        for (OutRmatOrderDetailVO outRmatOrderDetailVO : list) {
            String key = outRmatOrderDetailVO.getMaterialId() + "," + outRmatOrderDetailVO.getUnitMId() + "," + outRmatOrderDetailVO.getUnitId();
            ConvertEntity convertEntity = residualRate.get(key);
            String key2 = outRmatOrderDetailVO.getMaterialId() + "," + outRmatOrderDetailVO.getUnitId() + "," + outRmatOrderDetailVO.getUnitMId();
            ConvertEntity convertEntity2 = residualRate2.get(key2);
            if (null != convertEntity) {
                outRmatOrderDetailVO.setTransScale(convertEntity.getTransScale());
                outRmatOrderDetailVO.setDeviationRate(convertEntity.getDeviationRate());
            } else if (null != convertEntity2) {
                outRmatOrderDetailVO.setTransScale(convertEntity2.getTransScale());
                outRmatOrderDetailVO.setDeviationRate(convertEntity2.getDeviationRate());
            }
            if (!outRmatOrderDetailVO.getUnitId().equals(outRmatOrderDetailVO.getUnitMId())) continue;
            outRmatOrderDetailVO.setTransScale(new BigDecimal("1"));
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

