/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outrmat.settle.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.rmat.bean.RentCalculateEntity;
import com.ejianc.business.assist.rmat.service.IRentCalculateService;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractEntity;
import com.ejianc.business.outrmat.contract.enums.BillPushStatusEnum;
import com.ejianc.business.outrmat.contract.enums.BillTypeEnum;
import com.ejianc.business.outrmat.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractService;
import com.ejianc.business.outrmat.lose.bean.OutRmatLoseEntity;
import com.ejianc.business.outrmat.lose.service.IOutRmatLoseService;
import com.ejianc.business.outrmat.restitute.bean.OutRmatRestituteEntity;
import com.ejianc.business.outrmat.restitute.service.IOutRmatRestituteService;
import com.ejianc.business.outrmat.settle.bean.OutRmatSettleEntity;
import com.ejianc.business.outrmat.settle.bean.OutRmatSettleLeaseEntity;
import com.ejianc.business.outrmat.settle.bean.OutRmatSettleLoseEntity;
import com.ejianc.business.outrmat.settle.bean.OutRmatSettleRepairEntity;
import com.ejianc.business.outrmat.settle.bean.OutRmatSettleScrapEntity;
import com.ejianc.business.outrmat.settle.service.IOutRmatSettleService;
import com.ejianc.business.outrmat.settle.vo.OutRmatSettleVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outRmatSettle")
public class OutRmatSettleBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOutRmatSettleService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRentCalculateService calculateService;
    @Autowired
    private IOutRmatRestituteService outRmatRestituteService;
    @Autowired
    private IOutRmatLoseService outRmatLoseService;
    @Autowired
    private IOutRmatContractService outRmatContractService;
    @Autowired
    private IExecutionApi executionApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OutRmatSettleEntity outRmatSettleEntity = (OutRmatSettleEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(OutRmatSettleEntity::getCommitDate, (Object)new Date());
        wrapper.set(OutRmatSettleEntity::getCommitUserCode, (Object)userContext.getUserCode());
        wrapper.set(OutRmatSettleEntity::getCommitUserName, (Object)userContext.getUserName());
        OutRmatContractEntity outRmatContractEntity = (OutRmatContractEntity)((Object)this.outRmatContractService.getById(outRmatSettleEntity.getContractId()));
        if (Objects.equals(outRmatSettleEntity.getSettleType(), "1")) {
            outRmatContractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u7ec8\u6b62.getCode());
            this.outRmatContractService.saveOrUpdate((Object)outRmatContractEntity);
        }
        this.writeSettleFlag(outRmatSettleEntity, 1);
        Boolean poolRes = this.service.pushSettleToPool((OutRmatSettleVO)BeanMapper.map((Object)((Object)outRmatSettleEntity), OutRmatSettleVO.class));
        wrapper.set(OutRmatSettleEntity::getPushPoolFlag, (Object)(poolRes != false ? BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus() : BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus()));
        Boolean pushResult = this.service.pushBillToSupCenter(outRmatSettleEntity);
        if (pushResult.booleanValue()) {
            wrapper.set(OutRmatSettleEntity::getBillPushFlag, (Object)BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        } else {
            this.logger.error("\u5355\u636e-{}id-{}\u63a8\u9001\u4f9b\u5e94\u5546\u670d\u52a1\u5931\u8d25", (Object)BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u5408\u540c\u7ed3\u7b97\u5355.getName(), (Object)billId);
            wrapper.set(OutRmatSettleEntity::getBillPushFlag, (Object)BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        this.service.update((Wrapper)wrapper);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OutRmatSettleEntity entity = (OutRmatSettleEntity)((Object)this.service.selectById(billId));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OutRmatSettleEntity::getContractId, (Object)entity.getContractId());
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.service.list((Wrapper)wrapper);
        long count = list.stream().filter(e -> e.getBillState() != 1 && e.getBillState() != 3).count();
        if (count > 0L) {
            throw new BusinessException("\u5f53\u524d\u5355\u636e\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u7684\u5355\u636e\uff0c\u4e0d\u80fd\u64a4\u56de/\u5f03\u5ba1\uff01");
        }
        if (ListUtil.isNotEmpty((List)list) && !Objects.equals(((OutRmatSettleEntity)((Object)list.get(0))).getId(), billId)) {
            throw new BusinessException("\u53ea\u80fd\u64a4\u56de/\u5f03\u5ba1\u6700\u65b0\u4e00\u671f\u7684\u7ed3\u7b97\u5355\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        OutRmatSettleEntity entity = (OutRmatSettleEntity)((Object)this.service.selectById(billId));
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(OutRmatContractEntity::getPerformanceStatus, (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getContractId());
        this.outRmatContractService.update((Wrapper)updateWrapper);
        this.writeSettleFlag(entity, 0);
        boolean unPushRes = this.service.delSettleFromPool(entity.getId());
        if (!unPushRes) {
            entity.setPushPoolFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(entity.getBillPushFlag())) {
            boolean pushResult = this.service.delPushBill(entity);
            if (!pushResult) {
                return CommonResponse.error((String)"\u5f03\u5ba1\u524d\u56de\u8c03\u5931\u8d25\uff0c\u5355\u636e\u4f5c\u5e9f\u534f\u540c\u670d\u52a1\u5931\u8d25\uff01");
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            this.service.saveOrUpdate((Object)entity, false);
        }
        this.service.saveOrUpdate((Object)entity);
        return CommonResponse.success();
    }

    public void writeSettleFlag(OutRmatSettleEntity entity, Integer settleFlag) {
        List<OutRmatSettleScrapEntity> scrapList;
        ArrayList leaseIdsList = new ArrayList();
        List<OutRmatSettleLeaseEntity> leaseList = entity.getLeaseList();
        if (ListUtil.isNotEmpty(leaseList)) {
            leaseIdsList.addAll(leaseList.stream().map(OutRmatSettleLeaseEntity::getSourceId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty(leaseIdsList)) {
            LambdaUpdateWrapper leaseWrapper = new LambdaUpdateWrapper();
            leaseWrapper.set(RentCalculateEntity::getSettleFlag, (Object)settleFlag);
            leaseWrapper.in(BaseEntity::getId, leaseIdsList);
            this.calculateService.update((Wrapper)leaseWrapper);
        }
        ArrayList restituteIdsList = new ArrayList();
        List<OutRmatSettleRepairEntity> repairList = entity.getRepairList();
        if (ListUtil.isNotEmpty(repairList)) {
            restituteIdsList.addAll(repairList.stream().map(OutRmatSettleRepairEntity::getSourceId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty(scrapList = entity.getScrapList())) {
            restituteIdsList.addAll(scrapList.stream().map(OutRmatSettleScrapEntity::getSourceId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty(restituteIdsList)) {
            LambdaUpdateWrapper restituteWrapper = new LambdaUpdateWrapper();
            restituteWrapper.set(OutRmatRestituteEntity::getSettleFlag, (Object)settleFlag);
            restituteWrapper.in(BaseEntity::getId, restituteIdsList);
            this.outRmatRestituteService.update((Wrapper)restituteWrapper);
        }
        List<OutRmatSettleLoseEntity> loseList = entity.getLoseList();
        ArrayList loseIdsList = new ArrayList();
        if (ListUtil.isNotEmpty(loseList)) {
            loseIdsList.addAll(loseList.stream().map(OutRmatSettleLoseEntity::getSourceId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty(loseIdsList)) {
            LambdaUpdateWrapper loseWrapper = new LambdaUpdateWrapper();
            loseWrapper.set(OutRmatLoseEntity::getSettleFlag, (Object)settleFlag);
            loseWrapper.in(BaseEntity::getId, loseIdsList);
            this.outRmatLoseService.update((Wrapper)loseWrapper);
        }
    }
}

