package com.ejianc.business.outrmat.order.service.impl;

import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.assist.rmat.bean.DeliveryDetailEntity;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.service.IDeliveryDetailService;
import com.ejianc.business.common.CommonConstant;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractEntity;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractService;
import com.ejianc.business.outrmat.delivery.bean.OutRmatDeliveryDetailEntity;
import com.ejianc.business.outrmat.delivery.bean.OutRmatDeliveryEntity;
import com.ejianc.business.outrmat.delivery.service.IOutRmatDeliveryDetailService;
import com.ejianc.business.outrmat.delivery.service.IOutRmatDeliveryService;
import com.ejianc.business.outrmat.delivery.service.impl.OutRmatDeliveryDetailServiceImpl;
import com.ejianc.business.outrmat.delivery.vo.OutRmatDeliveryDetailVO;
import com.ejianc.business.outrmat.delivery.vo.OutRmatDeliveryVO;
import com.ejianc.business.outrmat.order.bean.OutRmatOrderDeliveryEntity;
import com.ejianc.business.outrmat.order.bean.OutRmatOrderDetailEntity;
import com.ejianc.business.outrmat.order.bean.OutRmatOrderEntity;
import com.ejianc.business.outrmat.order.mapper.OutRmatOrderMapper;
import com.ejianc.business.outrmat.order.service.IOutRmatOrderDetailService;
import com.ejianc.business.outrmat.order.service.IOutRmatOrderService;
import com.ejianc.business.outrmat.order.vo.OutRmatOrderDetailVO;
import com.ejianc.business.outrmat.order.vo.OutRmatOrderVO;
import com.ejianc.business.promaterial.order.vo.OrderDetailVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.vo.*;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 租赁订单
 *
 * @author generator
 *
 */
@Service("outRmatOrderService")
public class OutRmatOrderServiceImpl extends BaseServiceImpl<OutRmatOrderMapper, OutRmatOrderEntity> implements IOutRmatOrderService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOutRmatOrderDetailService detailService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IOutRmatContractService outRmatContractService;
    @Autowired
    private IOutRmatDeliveryDetailService outRmatDeliveryDetailService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;


    private final String FILE_TYPE = "outRmatOrder";


    private static final String OPERATE = "ORDER_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.租赁订单.getCode();
    private static final String BILL_NAME = BillTypeEnum.租赁订单.getName();

    /**
     * 保存施工方推送的订单数据
     * @return 保存结果
     */
    @Override
    public boolean saveOrder(OutRmatOrderVO saveOrUpdateVO) {
        logger.info("进入订单保存接口>>>>>>>>>>>>>>>>>>>>>>>>");
        logger.info("接收到数据：{}", saveOrUpdateVO);
        OutRmatOrderEntity entity = BeanMapper.map(saveOrUpdateVO, OutRmatOrderEntity.class);
        if (CollectionUtils.isEmpty(entity.getOrderDetailList())) {
            throw new BusinessException("明细列表不能为空！");
        }
        OutRmatOrderEntity orderEntity = super.selectById(saveOrUpdateVO.getId());
        // 同一个订单重复推送，则是抛出异常
        if (null != orderEntity) {
            logger.info("存在相同sourceID的数据，原数据:{}", JSONObject.toJSONString(orderEntity));
        }
        entity.setDisableState(CommonConstant.ORDER_DISABLE_NO);
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setReceiveState(CommonConstant.ORDER_RECEIVE_WAIT);
        // 处理附件
        CommonResponse copyContractFileResp = attachmentApi.copyFilesFromSourceBillToTargetBill(saveOrUpdateVO.getId().toString(), saveOrUpdateVO.getSourceBillCode(), saveOrUpdateVO.getSourceFileType(),
                saveOrUpdateVO.getId().toString(), BILL_TYPE, FILE_TYPE);
        if (!copyContractFileResp.isSuccess()) {
            logger.info("同步附件失败--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},：{}"
                    , saveOrUpdateVO.getId(), saveOrUpdateVO.getSourceBillCode(), saveOrUpdateVO.getSourceFileType(), saveOrUpdateVO.getId(), BILL_TYPE, FILE_TYPE, copyContractFileResp.getMsg());
            logger.info("同步附件失败，错误信息：" + copyContractFileResp.getMsg());
        }
        OutRmatContractEntity outRmatContractEntity = outRmatContractService.selectById(entity.getContractId());
        if(null==outRmatContractEntity){
            throw new BusinessException("查询合同失败！");
        }
        entity.setOutOrgId(outRmatContractEntity.getOutOrgId());
        entity.setOutOrgCode(outRmatContractEntity.getOutOrgCode());
        entity.setOutOrgName(outRmatContractEntity.getOutOrgName());
        List<Long> collect = entity.getOrderDetailList().stream().map(item -> item.getMaterialId()).collect(Collectors.toList());
        CommonResponse<List<MaterialVO>> listCommonResponse = shareMaterialApi.queryMaterialByIds(collect);
        if(!listCommonResponse.isSuccess()){
            throw new BusinessException("查询物资档案失败！");
        }
        Map<Long, MaterialVO> data = listCommonResponse.getData().stream().collect(Collectors.toMap(MaterialVO::getId, Function.identity(), (v1, v2) -> v2));
        for (OutRmatOrderDetailEntity outRmatOrderDetailEntity : entity.getOrderDetailList()) {
            if(data.containsKey(outRmatOrderDetailEntity.getMaterialId())){
                outRmatOrderDetailEntity.setUnitMId(data.get(outRmatOrderDetailEntity.getMaterialId()).getUnitId());
            }
        }
        boolean flag = super.saveOrUpdate(entity, false);
        logger.info("保存成功，订单保存结束<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return flag;
    }

    /**
     * 施工方撤回时删除订单
     *
     * @param vo 需要删除的订单
     * @return 删除结果
     */
    @Override
    public boolean deleteOrder(OutRmatOrderVO vo) {
        logger.info("进入施工方撤回订单接口>>>>>>>>>>>>>>>>>>>");
        logger.info("接收到数据：{}", JSONObject.toJSONString(vo));
        if (null == vo.getId()) {
            throw new BusinessException("订单信息不存在");
        }
        OutRmatOrderEntity orderEntity = super.selectById(vo.getId());
        if (null == orderEntity) {
            throw new BusinessException("订单信息不存在");
        }
        if (!CommonConstant.ORDER_RECEIVE_WAIT.equals(orderEntity.getReceiveState())) {
            throw new BusinessException("订单已被处理，无法删除！");
        }
        CommonResponse<List<AttachmentVO>> fileResp = attachmentApi
                .queryListBySourceId(orderEntity.getId(), BILL_TYPE, FILE_TYPE, null);
        // 查询成功并有相应的文件
        if (fileResp.isSuccess() && CollectionUtils.isNotEmpty(fileResp.getData())) {
            logger.info("删除文件信息：{}", JSONObject.toJSONString(fileResp.getData()));
            String ids = fileResp.getData().stream().map(AttachmentVO::getId).map(String::valueOf)
                    .collect(Collectors.joining(","));
            attachmentApi.delete(ids);
        }
        boolean flag = baseMapper.deleteOrder(vo.getId()) && detailService.deleteOrderDetailByOrderId(vo.getId());
        logger.info("施工方撤回订单成功<<<<<<<<<<<<<<<<<<<<<<<");
        return flag;
    }

    /**
     * 施工方关闭订单
     *
     * @param vo 需要关闭订单
     * @return 关闭订单
     */
    @Override
    public boolean updateOrderCloseFlag(OutRmatOrderVO vo) {
        logger.info("进入施工方关闭订单接口>>>>>>>>>>>>>>>>>>>");
        logger.info("接收到数据：{}", JSONObject.toJSONString(vo));
        if (null == vo.getId()) {
            throw new BusinessException("订单信息不存在");
        }
        OutRmatOrderEntity orderEntity = super.selectById(vo.getId());
        if (CommonConstant.ORDER_DISABLE_YES.equals(orderEntity.getDeliverState())) {
            throw new BusinessException("订单已被关闭！");
        }
        // 查询是否存在未生效的送货单
        // 查询是否存在审批未通过或审批通过待验收的送货单，
//        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("orderId", new Parameter(QueryParam.EQ, orderEntity.getId()));
//        // 修改为只查询审批通过待验收未关闭的送货单
//        queryParam.getParams().put("checkStatus", new Parameter(QueryParam.EQ, DeliverCheckStateEnum.WAIT_CHECK.getCode()));
//        queryParam.getParams().put("billState", new Parameter(QueryParam.IN,
//                Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
//                        BillStateEnum.PASSED_STATE.getBillStateCode())));
//        queryParam.getParams().put("closeFlag", new Parameter(QueryParam.EQ, CloseFlagEnum.NORMAL.getCode()));
//        List<MaterialDeliveryEntity> deliveryEntityList = deliveryService.queryList(queryParam);
//        if (CollectionUtils.isNotEmpty(deliveryEntityList)) {
//            logger.error("存在未生效的送货单，送货单信息：{}", JSONObject.toJSONString(deliveryEntityList));
//            StringBuilder errorBillCode = new StringBuilder("发货单[");
//            for (MaterialDeliveryEntity deliveryEntity : deliveryEntityList) {
//                errorBillCode.append(deliveryEntity.getBillCode()).append(",");
//            }
//            errorBillCode.delete(errorBillCode.length() - 1,errorBillCode.length());
//            errorBillCode.append("]未完成验收，不能关闭订单");
//            throw new BusinessException(errorBillCode.toString());
//        }
        // 校验都通过，则修改为已关闭
        orderEntity.setDeliverState(CommonConstant.ORDER_DISABLE_NO);
        boolean flag = super.saveOrUpdate(orderEntity, false);
        logger.info("施工方关闭订单成功>>>>>>>>>>>>>>>>>>>");
        return flag;
    }



    /**
     * 接收、拒收订单
     *
     * @param saveOrUpdateVO 订单详情
     * @return 保存结果
     */
    @Override
    public OutRmatOrderVO saveOrUpdate(OutRmatOrderVO saveOrUpdateVO) {
        if (saveOrUpdateVO.getId() == null) {
            throw new BusinessException("订单信息不存在");
        }
        if (saveOrUpdateVO.getReceiveState() == null
                || CommonConstant.ORDER_RECEIVE_STATE.get(saveOrUpdateVO.getReceiveState()) == null) {
            throw new BusinessException("接收类型不正确");
        }
        // 重新查询订单数据，页面上只需要传入少量数据即可
        OutRmatOrderEntity entity = super.selectById(saveOrUpdateVO.getId());
        entity.setDenialReason(saveOrUpdateVO.getDenialReason()); // 不予接收原因
        entity.setReceiveState(saveOrUpdateVO.getReceiveState());
        // 如果不是不予接收，则清单列表不能为空
        if (!CommonConstant.ORDER_RECEIVE_NOT.equals(saveOrUpdateVO.getReceiveState())
                && CollectionUtils.isEmpty(saveOrUpdateVO.getOrderDetailList())) {
            throw new BusinessException("清单列表不能为空！");
        }
        // 页面上传入的接收数量
        Map<Long, BigDecimal> voReceiveMap = new HashMap<>();
        for (OutRmatOrderDetailVO detailVO : saveOrUpdateVO.getOrderDetailList()) {
            voReceiveMap.put(detailVO.getId(),detailVO.getReceiveNumsSum());
        }
        // 对材料清单进行处理，赋默认值
        if (CollectionUtils.isNotEmpty(entity.getOrderDetailList())) {
            for (OutRmatOrderDetailEntity detail : entity.getOrderDetailList()) {
                // 全部接收，接收数量等于订单数量
                if (CommonConstant.ORDER_RECEIVE_ALL.equals(saveOrUpdateVO.getReceiveState())) {
                    detail.setReceiveNumsSum(detail.getPlanNumsSum());
                }
                // 部分接收，接收数量取传入的接收数量
                else if (CommonConstant.ORDER_RECEIVE_PART.equals(saveOrUpdateVO.getReceiveState())) {
                    detail.setReceiveNumsSum(ComputeUtil.safeAdd(voReceiveMap.get(detail.getId()),BigDecimal.ZERO));
                }
                // 不予接收默认值0
                else if (CommonConstant.ORDER_RECEIVE_NOT.equals(saveOrUpdateVO.getReceiveState())) {
                    detail.setReceiveNumsSum(BigDecimal.ZERO);
                }
                // 未发货数量等于接收数量
                detail.setNotDeliveredNumsSum(detail.getReceiveNumsSum());
                // 发货数量等于0
                detail.setDeliveredNumsSum(BigDecimal.ZERO);
            }
            entity.setDeliverState(CommonConstant.ORDER_DELIVER_WAIT);
        }

        // 通知项目方订单接收状态
        logger.info("开始通知施工方订单信息>>>>>>>>>>>>>>>>>>>");
        OutRmatOrderVO vo = new OutRmatOrderVO();
        vo.setId(entity.getId());
        vo.setReceiveState(entity.getReceiveState());
        List<OutRmatOrderDetailVO> detailList = new ArrayList<>();
        for (OutRmatOrderDetailEntity detail : entity.getOrderDetailList()) {
            OutRmatOrderDetailVO detailVO = new OutRmatOrderDetailVO();
            detailVO.setId(detail.getId());
            detailVO.setOrderId(detail.getOrderId());
            detailVO.setReceiveNumsSum(detail.getReceiveNumsSum());
            detailList.add(detailVO);
        }
        vo.setOrderDetailList(detailList);
        logger.info("通知施工方订单信息结束<<<<<<<<<<<<<<<<<<<<<<");
        super.saveOrUpdate(entity, false);
        OutRmatOrderVO orderVO = BeanMapper.map(entity, OutRmatOrderVO.class);
        return orderVO;
    }
}
