package com.ejianc.business.assist.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.material.bean.MaterialChangeEntity;
import com.ejianc.business.assist.material.bean.MaterialContractEntity;
import com.ejianc.business.assist.material.enums.BillTypeEnum;
import com.ejianc.business.assist.material.service.IMaterialChangeService;
import com.ejianc.business.assist.material.service.IMaterialContractFileService;
import com.ejianc.business.assist.material.service.IMaterialContractService;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Service("materialContractFileService")
public class MaterialContractFileServiceImpl implements IMaterialContractFileService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMaterialContractService contractService;

    @Autowired
    private IMaterialChangeService changeService;

    @Autowired
    private ISignatureCommonApi signatureCommonApi;


    @Override
    public JSONObject getSignedFileInfo(Long billId, String billType) {
        JSONObject resp = new JSONObject();

        List<ContractVO> voList = new ArrayList<>();
        ContractVO vo = new ContractVO();
        if (Objects.equals("contract", billType)) {
            MaterialContractEntity entity = contractService.selectById(billId);
            vo.setContractId(entity.getId());
            vo.setContractName(entity.getContractName());
            vo.setBillType(BillTypeEnum.辅料中心采购合同.getCode());
            vo.setSourceType(billType);
        }else {
            MaterialChangeEntity entity = changeService.selectById(billId);
            vo.setContractId(entity.getId());
            vo.setContractName(entity.getContractName());
            vo.setBillType(BillTypeEnum.辅料中心采购合同变更.getCode());
            vo.setSourceType(billType);
        }
        voList.add(vo);

        CommonResponse<List<SignMgrPreviewVO>> signResp = signatureCommonApi.fetchSignedContract(voList);
        if(!signResp.isSuccess()) {
            logger.error("获取单据id-{}，billType-{}签章文件信息失败: {}", billId, billType, signResp.getMsg());
            throw new BusinessException("获取合同签章文件信息失败!");
        }

        List<SignMgrPreviewVO> fileList = signResp.getData();
        if(CollectionUtils.isEmpty(fileList)) {
            throw new BusinessException("未获取到合同签章文件信息！");
        }

        SignMgrPreviewVO signedFileInfo = signResp.getData().get(0);
        if("contract".equals(billType)) {
            MaterialContractEntity contract = contractService.selectById(billId);
            if (Objects.equals(contract.getSignedFileId(), null)) {
                contract.setSignedFileId(signedFileInfo.getFileId());
                contractService.saveOrUpdate(contract, false);
            }
        } else {
            MaterialChangeEntity contractChange = changeService.selectById(billId);
            if (Objects.equals(contractChange.getSignedChangeFileId(), null)) {
                contractChange.setSignedChangeFileId(signedFileInfo.getFileId());
                changeService.saveOrUpdate(contractChange, false);
            }
        }

        resp.put("fileId", signedFileInfo.getFileId());
        resp.put("filePath", signedFileInfo.getFilePath());
        resp.put("fileTruePath", signedFileInfo.getTruePath());

        return resp;
    }

}
