package com.ejianc.business.outrmat.order.service;

import com.ejianc.business.outrmat.delivery.vo.OutRmatDeliveryDetailVO;
import com.ejianc.business.outrmat.delivery.vo.OutRmatDeliveryVO;
import com.ejianc.business.outrmat.order.bean.OutRmatOrderEntity;
import com.ejianc.business.outrmat.order.vo.OutRmatOrderVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 租赁订单
 * 
 * @author generator
 * 
 */
public interface IOutRmatOrderService extends IBaseService<OutRmatOrderEntity> {

    /**
     * 接收项目方订单接口
     *
     * @param saveOrUpdateVO 接收数据
     * @return
     */

    boolean saveOrder(OutRmatOrderVO saveOrUpdateVO);
    /**
     * 项目方撤回时删除订单
     *
     * @param vo 需要删除的订单
     * @return 删除结果
     */
    boolean deleteOrder(OutRmatOrderVO vo);
    /**
     * 施工方关闭订单
     *
     * @param vo 需要关闭订单
     * @return 关闭订单
     */
    boolean updateOrderCloseFlag(OutRmatOrderVO vo);
    /**
     * 接收、拒收订单
     *
     * @param saveOrUpdateVO 订单详情
     * @return 保存结果
     */
    OutRmatOrderVO saveOrUpdate(OutRmatOrderVO saveOrUpdateVO);

}
