/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outrmat.settle.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.assist.rmat.vo.RentCalculateVO;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractEntity;
import com.ejianc.business.outrmat.contract.enums.BillTypeEnum;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractService;
import com.ejianc.business.outrmat.contract.vo.record.OutRmatContractSettleRecordVO;
import com.ejianc.business.outrmat.lose.bean.OutRmatLoseEntity;
import com.ejianc.business.outrmat.lose.service.IOutRmatLoseService;
import com.ejianc.business.outrmat.lose.vo.OutRmatLoseVO;
import com.ejianc.business.outrmat.restitute.bean.OutRmatRestituteEntity;
import com.ejianc.business.outrmat.restitute.service.IOutRmatRestituteService;
import com.ejianc.business.outrmat.restitute.vo.OutRmatRestituteVO;
import com.ejianc.business.outrmat.settle.bean.OutRmatSettleEntity;
import com.ejianc.business.outrmat.settle.mapper.OutRmatSettleMapper;
import com.ejianc.business.outrmat.settle.service.IOutRmatSettleService;
import com.ejianc.business.outrmat.settle.vo.OutRmatSettleVO;
import com.ejianc.business.outrmat.utils.DateUtil;
import com.ejianc.business.outrmat.utils.PushSupUtil;
import com.ejianc.business.pro.rmat.api.IReceiptsApi;
import com.ejianc.business.pro.rmat.enums.ReceiptsEnum;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outRmatSettleService")
public class OutRmatSettleServiceImpl
extends BaseServiceImpl<OutRmatSettleMapper, OutRmatSettleEntity>
implements IOutRmatSettleService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ASSIST_RMAT_RENT_IN_CONTRACT_SETTLE = "FLZX_ZCJS_CODE";
    private static final String OPERATE = "SETTLE_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u5408\u540c\u7ed3\u7b97\u5355.getCode();
    private static final String BILL_NAME = BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u5408\u540c\u7ed3\u7b97\u5355.getName();
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IReceiptsApi receiptsApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOutRmatRestituteService outRmatRestituteService;
    @Autowired
    private IOutRmatLoseService outRmatLoseService;
    @Autowired
    private IOutRmatContractService rmatContractService;
    @Autowired
    private PushSupUtil pushSupUtil;

    @Override
    public OutRmatSettleVO saveOrUpdate(OutRmatSettleVO saveOrUpdateVO) {
        int compareDate;
        OutRmatSettleEntity entity = (OutRmatSettleEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OutRmatSettleEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)ASSIST_RMAT_RENT_IN_CONTRACT_SETTLE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setSupplierSignStatus(0);
        }
        this.validateContract(entity.getContractId(), entity.getId());
        OutRmatSettleVO lastVo = this.queryLastSettleTaxMny(entity.getContractId(), entity.getId());
        if (lastVo.getId() != null && (compareDate = DateUtil.compareDate((Date)lastVo.getSettleDate(), (Date)entity.getSettleDate())) > 0) {
            throw new BusinessException("\u672c\u6b21\u7ed3\u7b97\u65e5\u671f" + DateUtil.formatDate((Date)entity.getSettleDate()) + "\u4e0d\u80fd\u5c0f\u4e8e\u4e0a\u6b21\u7ed3\u7b97\u65e5\u671f" + DateUtil.formatDate((Date)lastVo.getSettleDate()));
        }
        this.saveOrUpdate((Object)entity, false);
        return (OutRmatSettleVO)BeanMapper.map((Object)this.selectById(entity.getId()), OutRmatSettleVO.class);
    }

    @Override
    public String validateContract(Long contractId, Long billId) {
        List list;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        if (billId != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)billId));
        }
        if (ListUtil.isNotEmpty((List)(list = super.queryList(queryParam, false)))) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u7ed3\u7b97\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public List<RentCalculateVO> queryCalculateData(Long contractId, String lastSettleDate, String settleDate) {
        return new ArrayList<RentCalculateVO>();
    }

    @Override
    public List<OutRmatRestituteVO> queryRestituteData(Long contractId, String lastSettleDate, String settleDate) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OutRmatRestituteEntity::getContractId, (Object)contractId);
        wrapper.eq(OutRmatRestituteEntity::getSettleFlag, (Object)0);
        wrapper.in(OutRmatRestituteEntity::getBillState, Arrays.asList(1, 3));
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        if (StringUtils.isBlank((CharSequence)lastSettleDate)) {
            wrapper.le(OutRmatRestituteEntity::getRestituteDate, (Object)settleDate);
        } else {
            wrapper.between(OutRmatRestituteEntity::getRestituteDate, (Object)lastSettleDate, (Object)settleDate);
        }
        List list = this.outRmatRestituteService.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            return new ArrayList<OutRmatRestituteVO>();
        }
        return BeanMapper.mapList((Iterable)list, OutRmatRestituteVO.class);
    }

    @Override
    public List<OutRmatLoseVO> queryLoseData(Long contractId, String lastSettleDate, String settleDate) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OutRmatLoseEntity::getContractId, (Object)contractId);
        wrapper.eq(OutRmatLoseEntity::getSettleFlag, (Object)0);
        wrapper.in(OutRmatLoseEntity::getBillState, Arrays.asList(1, 3));
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        if (StringUtils.isBlank((CharSequence)lastSettleDate)) {
            wrapper.le(OutRmatLoseEntity::getBillDate, (Object)settleDate);
        } else {
            wrapper.between(OutRmatLoseEntity::getBillDate, (Object)lastSettleDate, (Object)settleDate);
        }
        List list = this.outRmatLoseService.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            return new ArrayList<OutRmatLoseVO>();
        }
        return BeanMapper.mapList((Iterable)list, OutRmatLoseVO.class);
    }

    @Override
    public OutRmatSettleVO queryLastSettleTaxMny(Long contractId, Long billId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OutRmatSettleEntity::getContractId, (Object)contractId);
        wrapper.in(OutRmatSettleEntity::getBillState, Arrays.asList(1, 3));
        if (billId != null) {
            wrapper.ne(BaseEntity::getId, (Object)billId);
        }
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            return new OutRmatSettleVO();
        }
        return (OutRmatSettleVO)BeanMapper.map(list.get(0), OutRmatSettleVO.class);
    }

    @Override
    public OutRmatContractSettleRecordVO querySettleRecord(Long id) {
        OutRmatContractEntity entity = (OutRmatContractEntity)((Object)this.rmatContractService.selectById(id));
        OutRmatContractSettleRecordVO vo = new OutRmatContractSettleRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractMny(entity.getContractMny());
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OutRmatSettleEntity::getContractId, (Object)id);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List settleList = super.list((Wrapper)wrapper);
        if (ListUtil.isNotEmpty((List)settleList)) {
            vo.setTotalSettleTaxMny(((OutRmatSettleEntity)((Object)settleList.get(0))).getTotalSettleTaxMny());
            vo.setTotalSettleMny(((OutRmatSettleEntity)((Object)settleList.get(0))).getTotalSettleMny());
            vo.setSettleRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getTotalSettleTaxMny(), (BigDecimal)vo.getTotalSettleMny()), (BigDecimal)new BigDecimal("100")));
        }
        vo.setDetailList(BeanMapper.mapList((Iterable)settleList, OutRmatSettleVO.class));
        return vo;
    }

    @Override
    public Boolean pushBillToSupCenter(OutRmatSettleEntity entity) {
        CommonResponse response = this.receiptsApi.receiptsSync((JSONObject)JSONObject.toJSON((Object)((Object)entity)), ReceiptsEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c\u7ed3\u7b97\u5355.getName());
        if (!response.isSuccess()) {
            throw new BusinessException(response.getMsg());
        }
        return true;
    }

    @Override
    public Boolean delPushBill(OutRmatSettleEntity entity) {
        CommonResponse response = this.receiptsApi.delReceipts(entity.getId(), ReceiptsEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c\u7ed3\u7b97\u5355.getName());
        if (!response.isSuccess()) {
            throw new BusinessException(response.getMsg());
        }
        return true;
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String billId = request.getParameter("billId");
        this.logger.info("\u8f85\u6599\u4e2d\u5fc3\u7ed3\u7b97\u5355billId:" + billId);
        OutRmatSettleEntity entity = (OutRmatSettleEntity)((Object)super.selectById((Serializable)((Object)billId)));
        this.logger.info("\u8f85\u6599\u4e2d\u5fc3\u7ed3\u7b97\u5355\u5b9e\u4f53:" + (Object)((Object)entity));
        String msg = this.pushSupUtil.updateBillSupSignSyncInfo(request, (JSONObject)JSONObject.toJSON((Object)((Object)entity)), OutRmatSettleEntity.class, OPERATE, BILL_TYPE, BILL_NAME);
        this.logger.info("\u8fd4\u56de\u6d88\u606fmsg" + msg);
        return msg;
    }
}

