package com.ejianc.business.outrmat.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.common.CommonConstant;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractRelieveEntity;
import com.ejianc.business.outrmat.contract.enums.BillPushStatusEnum;
import com.ejianc.business.outrmat.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.outrmat.contract.enums.SignatureStatusEnum;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractRelieveService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractRelieveSignatureService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractService;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Objects;

/**
 * @author baipengyan
 */
@Service("outRmatContractRelieveSignatureService")
public class OutRmatContractRelieveSignatureServiceImpl implements IOutRmatContractRelieveSignatureService {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IOutRmatContractRelieveService service;

    @Autowired
    private IOutRmatContractService contractService;

    @Autowired
    private IExecutionApi executionApi;
    
    /**
     * 更新合同解除单据签章状态和合同状态
     *
     * @param id              合同解除单据id
     * @param signatureStatus 签章状态
     * @param refCode         唯一标识
     * @return 结果数据
     */
    @Override
    public CommonResponse<String> relieveContract(Long id, Integer signatureStatus, String refCode) {
        logger.info("更新合同解除单据签章状态和合同状态，入参--id；{}，signatureStatus：{}，refCode：{}", id, signatureStatus, refCode);
        
        // signatureStatus - 1 是因为分包的签章状态是1234，签章服务传递的参数也是固定的1234，但这边是0123，需要-1
        signatureStatus = signatureStatus - 1;

        // 判断是否是合同解除标识
        if (Objects.equals(CommonConstant.CONTRACT_RECORD_RELIEVE, refCode)) {
            OutRmatContractRelieveEntity entity = service.selectById(id);
            entity.setSignatureStatus(Integer.valueOf(signatureStatus));

            // 查询合同的信息
            OutRmatContractEntity outRmatContractEntity = contractService.selectById(entity.getContractId());
            if (outRmatContractEntity == null) {
                throw new BusinessException("查询不到可修改状态的合同！");
            }
            logger.info("即将修改的合同信息--{}", JSONObject.toJSONString(outRmatContractEntity));
            // 签章状态：4-已签章，履约中允许解除（冻结及其他状态不能解除）
            if (SignatureStatusEnum.已签章.getCode().equals(signatureStatus) && PerformanceStatusEnum.履约中.getCode().equals(outRmatContractEntity.getPerformanceStatus())) {
                // 更新合同解除单据生效时间
                entity.setEffectiveDate(new Date());
                // 更新合同状态为已作废
                outRmatContractEntity.setPerformanceStatus(PerformanceStatusEnum.已作废.getCode());
                contractService.saveOrUpdate(outRmatContractEntity, false);
                logger.info("合同已作废！");

                // 推送目标成本
//                CommonResponse<String> response = executionApi.aggPush(service.targetCost(entity));
//                logger.info("推送目标成本入参：" + JSONObject.toJSONString(service.targetCost(entity)));
//                if (!response.isSuccess()){
//                    logger.error("推送目标成本失败: , {}", response.getMsg());
//                    throw new BusinessException(response.getMsg());
//                }

                // 合同推送合同池，更新解除状态
                boolean pushResult = contractService.pushContract(BeanMapper.map(outRmatContractEntity, OutRmatContractVO.class));
                if(pushResult) {
                    outRmatContractEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                } else {
                    outRmatContractEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
                }
                contractService.saveOrUpdate(outRmatContractEntity, false);
                
            }
            service.saveOrUpdate(entity, false);
            return CommonResponse.success("合同解除单据签章状态更新成功！");
        } else {
            return CommonResponse.error("合同解除单据签章状态更新失败！");
        }
    }
}
