package com.ejianc.business.outrmat.lose.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.outrmat.consts.OutRmatConstant;
import com.ejianc.business.outrmat.contract.enums.BillTypeEnum;
import com.ejianc.business.outrmat.contract.service.IOutRmatMaterialService;
import com.ejianc.business.outrmat.lose.bean.OutRmatLoseEntity;
import com.ejianc.business.outrmat.lose.mapper.OutRmatLoseMapper;
import com.ejianc.business.outrmat.lose.service.IOutRmatLoseService;
import com.ejianc.business.outrmat.lose.vo.OutRmatLoseDetailVO;
import com.ejianc.business.outrmat.lose.vo.OutRmatLoseVO;
import com.ejianc.business.outrmat.utils.DateUtil;
import com.ejianc.business.outrmat.utils.PushSupUtil;
import com.ejianc.business.outrmat.utils.ValidateUtil;
import com.ejianc.business.pro.rmat.api.IReceiptsApi;
import com.ejianc.business.pro.rmat.enums.ReceiptsEnum;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 遗失单
 * 
 * @author generator
 * 
 */
@Service("outRmatLoseService")
public class OutRmatLoseServiceImpl extends BaseServiceImpl<OutRmatLoseMapper, OutRmatLoseEntity> implements IOutRmatLoseService {
    @Autowired
    private IOutRmatMaterialService outRmatMaterialService;

    @Autowired
    private PushSupUtil pushSupUtil;
    @Autowired
    private IReceiptsApi receiptsApi;

    private static final String OPERATE = "START_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.租出遗失单.getCode();
    private static final String BILL_NAME = BillTypeEnum.租出遗失单.getName();

    @Override
    public String validateContract(Long contractId, Long billId) {
        // 同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        if(billId != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }
        List<OutRmatLoseEntity> list = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("当前合同存在非审批通过态的遗失单，不允许新增!");
        }
        return "校验通过！";
    }

    /**
     * 校验必须大于最大单据日期
     * @param  outRmatLoseVO
     * @return
     */
    @Override
    public String validateTime(OutRmatLoseVO outRmatLoseVO, String type) {
        Map<String, Object> params = new HashMap<>();
        params.put("contractId", outRmatLoseVO.getContractId());
        if(outRmatLoseVO.getId() != null){
            params.put("billType", OutRmatConstant.遗失单);
            params.put("billId", outRmatLoseVO.getId());
        }
        Date lastDate = outRmatMaterialService.getLastDate(params);
        Map<Date, Date> maxTimeMap = outRmatMaterialService.getMaxTime(params);
        if (lastDate == null) return "未获取最大单据日期！";
        if(ValidateUtil.compareDate(outRmatLoseVO.getStopDate(), lastDate, maxTimeMap,outRmatLoseVO.getCreateTime())){
            throw new BusinessException(DateUtil.formatDate(outRmatLoseVO.getStopDate())
                    + "小于最大单据日期【" + DateUtil.formatDate(lastDate) + "】，不允许" + type + "!");
        }
        for(OutRmatLoseDetailVO vo : outRmatLoseVO.getLoseDetailList()){
            if(ValidateUtil.compareDate(vo.getDate(), lastDate, maxTimeMap,vo.getCreateTime())){
                throw new BusinessException(DateUtil.formatDate(vo.getDate())
                        + "小于最大单据日期【" + DateUtil.formatDate(lastDate) + "】，不允许" + type + "!");
            }
        }
        return "校验通过！";
    }

    @Override
    public boolean pushBillToSupCenter(OutRmatLoseEntity entity) {
        CommonResponse<String> response = receiptsApi.receiptsSync((JSONObject) JSONObject.toJSON(entity), ReceiptsEnum.遗失单.getName());
        if(!response.isSuccess()){
            throw new BusinessException(response.getMsg());
        }
        return true;
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String billId = request.getParameter("billId");
        OutRmatLoseEntity entity = super.selectById(billId);
        String msg = pushSupUtil.updateBillSupSignSyncInfo(request, (JSONObject) JSONObject.toJSON(entity),
                OutRmatLoseEntity.class, OPERATE, BILL_TYPE, BILL_NAME);
        return msg;
    }

    @Override
    public boolean delPushBill(OutRmatLoseEntity entity) {
        CommonResponse<String> response = receiptsApi.delReceipts(entity.getId(), ReceiptsEnum.遗失单.getName());
        if(!response.isSuccess()){
            throw new BusinessException(response.getMsg());
        }
        return true;
    }
}
