package com.ejianc.business.outrmat.order.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.rmat.service.IBatchPlanService;
import com.ejianc.business.outrmat.order.service.IOutRmatOrderService;
import com.ejianc.business.outrmat.order.vo.OutRmatOrderVO;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/OutRmatOrder/")
@Api(value = "辅料中心租出订单API接口", tags = {"辅料中心租出订单API接口"})
public class OutRmatOrderApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOutRmatOrderService service;

    @ApiOperation("保存推送的订单数据")
    @RequestMapping(value = "/saveOrder", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveOrder(@RequestBody OutRmatOrderVO saveOrUpdateVO) {
        logger.info("订单数据--"+JSONObject.toJSONString(saveOrUpdateVO));
        service.saveOrder(saveOrUpdateVO);
        return CommonResponse.success("操作成功！");
    }
    @ApiOperation("删除推送的订单数据")
    @RequestMapping(value = "/deleteOrder", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> deleteOrder(@RequestBody OutRmatOrderVO saveOrUpdateVO) {
        logger.info("订单数据--"+JSONObject.toJSONString(saveOrUpdateVO));
        service.deleteOrder(saveOrUpdateVO);
        return CommonResponse.success("操作成功！");
    }
    @ApiOperation("订单关闭")
    @RequestMapping(value = "/updateOrderCloseFlag", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateOrderCloseFlag(@RequestBody OutRmatOrderVO saveOrUpdateVO) {
        logger.info("订单数据--"+JSONObject.toJSONString(saveOrUpdateVO));
        String s = service.updateOrderCloseFlag(saveOrUpdateVO);
        return CommonResponse.success("操作成功！",s);
    }
}
