/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outrmat.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.outrmat.delivery.bean.OutRmatDeliveryDetailEntity;
import com.ejianc.business.outrmat.order.bean.OutRmatOrderDeliveryEntity;
import com.ejianc.business.outrmat.order.bean.OutRmatOrderDetailEntity;
import com.ejianc.business.outrmat.order.mapper.OutRmatOrderDeliveryMapper;
import com.ejianc.business.outrmat.order.service.IOutRmatOrderDeliveryService;
import com.ejianc.business.outrmat.order.service.IOutRmatOrderDetailService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outRmatOrderDeliveryService")
public class OutRmatOrderDeliveryServiceImpl
extends BaseServiceImpl<OutRmatOrderDeliveryMapper, OutRmatOrderDeliveryEntity>
implements IOutRmatOrderDeliveryService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOutRmatOrderDetailService outRmatOrderDetailService;

    @Override
    public void saveOrUpdate(List<OutRmatDeliveryDetailEntity> detailVOS, Long contractId) {
        this.delOrderDetail(detailVOS);
        this.addOrderDetail(detailVOS, contractId);
    }

    @Override
    public void delete(List<OutRmatDeliveryDetailEntity> detailVOS, Long contractId) {
        this.delOrderDetail(detailVOS);
    }

    public void addOrderDetail(List<OutRmatDeliveryDetailEntity> detailVOS, Long contractId) {
        HashMap<String, OutRmatOrderDeliveryEntity> orderDeliveryDetail = new HashMap<String, OutRmatOrderDeliveryEntity>();
        HashMap<String, OutRmatOrderDetailEntity> orderDetail = new HashMap<String, OutRmatOrderDetailEntity>();
        if (CollectionUtils.isNotEmpty(detailVOS)) {
            for (OutRmatDeliveryDetailEntity outRmatDeliveryDetail : detailVOS) {
                BigDecimal orderNumsSum;
                List<OutRmatOrderDetailEntity> orderDetailEntities = this.outRmatOrderDetailService.queryMaterialDetail(contractId, outRmatDeliveryDetail.getMaterialId(), outRmatDeliveryDetail.getRentUnitId(), outRmatDeliveryDetail.getCalculateUnitId(), outRmatDeliveryDetail.getRentType().toString());
                BigDecimal bigDecimal = orderNumsSum = outRmatDeliveryDetail.getRentNum() == null ? BigDecimal.ZERO : outRmatDeliveryDetail.getRentNum();
                if (!CollectionUtils.isNotEmpty(orderDetailEntities)) continue;
                for (int i = 0; i < orderDetailEntities.size(); ++i) {
                    BigDecimal surplusNums;
                    if (orderNumsSum.compareTo(BigDecimal.ZERO) <= 0) continue;
                    BigDecimal orderNums = BigDecimal.ZERO;
                    OutRmatOrderDetailEntity entity = null;
                    entity = orderDetail.containsKey(orderDetailEntities.get(i).getId().toString()) ? (OutRmatOrderDetailEntity)((Object)orderDetail.get(orderDetailEntities.get(i).getId().toString())) : orderDetailEntities.get(i);
                    OutRmatOrderDeliveryEntity orderDelivery = (OutRmatOrderDeliveryEntity)((Object)BeanMapper.map((Object)((Object)entity), OutRmatOrderDeliveryEntity.class));
                    BigDecimal nums = entity.getReceiveNumsSum() == null ? BigDecimal.ZERO : entity.getReceiveNumsSum();
                    BigDecimal occupyNums = entity.getDeliveredNumsSum() == null ? BigDecimal.ZERO : entity.getDeliveredNumsSum();
                    BigDecimal bigDecimal2 = surplusNums = entity.getNotDeliveredNumsSum() == null ? BigDecimal.ZERO : entity.getNotDeliveredNumsSum();
                    orderNums = orderNumsSum.compareTo(surplusNums) < 0 ? orderNumsSum : (i == orderDetailEntities.size() - 1 ? orderNumsSum : surplusNums);
                    orderDelivery.setDeliveredNumsSum(orderNums);
                    orderDelivery.setId(IdWorker.getId());
                    orderDelivery.setOrderDetailId(entity.getId());
                    orderDelivery.setDeliveryId(outRmatDeliveryDetail.getDeliveryId());
                    orderDelivery.setDeliveryDetailId(outRmatDeliveryDetail.getId());
                    entity.setDeliveredNumsSum(occupyNums.add(orderDelivery.getDeliveredNumsSum()));
                    entity.setNotDeliveredNumsSum(nums.subtract(entity.getDeliveredNumsSum()));
                    orderNumsSum = orderNumsSum.subtract(orderNums);
                    orderDetail.put(entity.getId().toString(), entity);
                    orderDeliveryDetail.put("" + orderDelivery.getOrderDetailId() + orderDelivery.getDeliveryDetailId(), orderDelivery);
                }
            }
            this.logger.info("\u65b0\u589e\u4fee\u6539\u8ba2\u5355-----" + JSONObject.toJSONString(orderDetail));
            if (MapUtils.isNotEmpty(orderDetail)) {
                this.outRmatOrderDetailService.updateBatchById(orderDetail.values());
            }
            this.logger.info("\u65b0\u589e\u8ba2\u5355\u51fa\u5e93\u6d41\u6c34-----" + JSONObject.toJSONString(orderDeliveryDetail));
            if (MapUtils.isNotEmpty(orderDeliveryDetail)) {
                this.saveOrUpdateBatch(orderDeliveryDetail.values());
            }
        }
    }

    public void delOrderDetail(List<OutRmatDeliveryDetailEntity> detailVOS) {
        ArrayList<OutRmatOrderDetailEntity> orderDetailList = new ArrayList<OutRmatOrderDetailEntity>();
        ArrayList<OutRmatOrderDeliveryEntity> orderDeliveryDetailList = new ArrayList<OutRmatOrderDeliveryEntity>();
        if (CollectionUtils.isNotEmpty(detailVOS)) {
            for (OutRmatDeliveryDetailEntity outRmatDeliveryDetail : detailVOS) {
                LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
                lambda.eq(OutRmatOrderDeliveryEntity::getDeliveryDetailId, (Object)outRmatDeliveryDetail.getId());
                lambda.eq(OutRmatOrderDeliveryEntity::getDeliveryId, (Object)outRmatDeliveryDetail.getDeliveryId());
                List list = this.list((Wrapper)lambda);
                if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                for (OutRmatOrderDeliveryEntity orderDelivery : list) {
                    OutRmatOrderDetailEntity entity = (OutRmatOrderDetailEntity)((Object)this.outRmatOrderDetailService.getById(orderDelivery.getOrderDetailId()));
                    BigDecimal nums = entity.getReceiveNumsSum() == null ? BigDecimal.ZERO : entity.getReceiveNumsSum();
                    BigDecimal occupyNums = entity.getDeliveredNumsSum() == null ? BigDecimal.ZERO : entity.getDeliveredNumsSum();
                    BigDecimal orderNums = orderDelivery.getDeliveredNumsSum() == null ? BigDecimal.ZERO : orderDelivery.getDeliveredNumsSum();
                    entity.setDeliveredNumsSum(occupyNums.subtract(orderNums));
                    entity.setNotDeliveredNumsSum(nums.subtract(entity.getDeliveredNumsSum()));
                    orderDetailList.add(entity);
                    orderDeliveryDetailList.add(orderDelivery);
                }
            }
            this.logger.info("\u5220\u9664\u4fee\u6539\u8ba2\u5355-----" + JSONObject.toJSONString(orderDetailList));
            if (CollectionUtils.isNotEmpty(orderDetailList)) {
                this.outRmatOrderDetailService.updateBatchById(orderDetailList);
            }
            this.logger.info("\u5220\u9664\u8ba2\u5355\u51fa\u5e93\u6d41\u6c34-----" + JSONObject.toJSONString(orderDeliveryDetailList));
            if (CollectionUtils.isNotEmpty(orderDeliveryDetailList)) {
                this.removeByIds(orderDeliveryDetailList.stream().map(BaseEntity::getId).collect(Collectors.toList()), true);
            }
        }
    }
}

