/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outrmat.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.outrmat.delivery.bean.OutRmatDeliveryDetailEntity;
import com.ejianc.business.outrmat.order.bean.OutRmatOrderDeliveryEntity;
import com.ejianc.business.outrmat.order.bean.OutRmatOrderDetailEntity;
import com.ejianc.business.outrmat.order.bean.OutRmatOrderEntity;
import com.ejianc.business.outrmat.order.mapper.OutRmatOrderDeliveryMapper;
import com.ejianc.business.outrmat.order.service.IOutRmatOrderDeliveryService;
import com.ejianc.business.outrmat.order.service.IOutRmatOrderDetailService;
import com.ejianc.business.outrmat.order.service.IOutRmatOrderService;
import com.ejianc.business.outrmat.order.vo.OutRmatOrderDetailVO;
import com.ejianc.business.outrmat.order.vo.OutRmatOrderVO;
import com.ejianc.business.pro.rmat.api.IReceiptsApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outRmatOrderDeliveryService")
public class OutRmatOrderDeliveryServiceImpl
extends BaseServiceImpl<OutRmatOrderDeliveryMapper, OutRmatOrderDeliveryEntity>
implements IOutRmatOrderDeliveryService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOutRmatOrderDetailService outRmatOrderDetailService;
    @Autowired
    private IOutRmatOrderService outRmatOrderService;
    @Autowired
    private IReceiptsApi receiptsApi;

    @Override
    public void saveOrUpdate(List<OutRmatDeliveryDetailEntity> detailVOS, Long contractId) {
        this.delOrderDetail(detailVOS);
        this.addOrderDetail(detailVOS, contractId);
    }

    @Override
    public void delete(List<OutRmatDeliveryDetailEntity> detailVOS, Long contractId) {
        this.delOrderDetail(detailVOS);
    }

    public void addOrderDetail(List<OutRmatDeliveryDetailEntity> detailVOS, Long contractId) {
        HashMap<String, OutRmatOrderDeliveryEntity> orderDeliveryDetail = new HashMap<String, OutRmatOrderDeliveryEntity>();
        HashMap<String, OutRmatOrderDetailEntity> orderDetail = new HashMap<String, OutRmatOrderDetailEntity>();
        HashSet<Long> orderIds = new HashSet<Long>();
        if (CollectionUtils.isNotEmpty(detailVOS)) {
            for (OutRmatDeliveryDetailEntity outRmatDeliveryDetail : detailVOS) {
                BigDecimal orderNumsSum;
                List<OutRmatOrderDetailEntity> orderDetailEntities = this.outRmatOrderDetailService.queryMaterialDetail(contractId, outRmatDeliveryDetail.getMaterialId(), outRmatDeliveryDetail.getRentUnitId(), outRmatDeliveryDetail.getCalculateUnitId(), outRmatDeliveryDetail.getRentCalculationType().toString());
                BigDecimal bigDecimal = orderNumsSum = outRmatDeliveryDetail.getRentNum() == null ? BigDecimal.ZERO : outRmatDeliveryDetail.getRentNum();
                if (!CollectionUtils.isNotEmpty(orderDetailEntities)) continue;
                for (int i = 0; i < orderDetailEntities.size(); ++i) {
                    BigDecimal surplusNums;
                    if (orderNumsSum.compareTo(BigDecimal.ZERO) <= 0) continue;
                    BigDecimal orderNums = BigDecimal.ZERO;
                    OutRmatOrderDetailEntity entity = null;
                    entity = orderDetail.containsKey(orderDetailEntities.get(i).getId().toString()) ? (OutRmatOrderDetailEntity)((Object)orderDetail.get(orderDetailEntities.get(i).getId().toString())) : orderDetailEntities.get(i);
                    OutRmatOrderDeliveryEntity orderDelivery = (OutRmatOrderDeliveryEntity)((Object)BeanMapper.map((Object)((Object)entity), OutRmatOrderDeliveryEntity.class));
                    BigDecimal nums = entity.getReceiveNumsSum() == null ? BigDecimal.ZERO : entity.getReceiveNumsSum();
                    BigDecimal occupyNums = entity.getDeliveredNumsSum() == null ? BigDecimal.ZERO : entity.getDeliveredNumsSum();
                    BigDecimal bigDecimal2 = surplusNums = entity.getNotDeliveredNumsSum() == null ? BigDecimal.ZERO : entity.getNotDeliveredNumsSum();
                    orderNums = orderNumsSum.compareTo(surplusNums) < 0 ? orderNumsSum : (i == orderDetailEntities.size() - 1 ? orderNumsSum : surplusNums);
                    orderDelivery.setDeliveredNumsSum(orderNums);
                    orderIds.add(entity.getOrderId());
                    orderDelivery.setOrderDetailId(entity.getId());
                    orderDelivery.setDeliveryId(outRmatDeliveryDetail.getDeliveryId());
                    orderDelivery.setDeliveryDetailId(outRmatDeliveryDetail.getId());
                    entity.setDeliveredNumsSum(occupyNums.add(orderDelivery.getDeliveredNumsSum()));
                    entity.setNotDeliveredNumsSum(nums.subtract(entity.getDeliveredNumsSum()));
                    orderNumsSum = orderNumsSum.subtract(orderNums);
                    orderDetail.put(entity.getId().toString(), entity);
                    orderDeliveryDetail.put("" + orderDelivery.getOrderDetailId() + orderDelivery.getDeliveryDetailId(), orderDelivery);
                }
            }
            this.logger.info("\u65b0\u589e\u4fee\u6539\u8ba2\u5355-----" + JSONObject.toJSONString(orderDetail));
            if (MapUtils.isNotEmpty(orderDetail)) {
                this.outRmatOrderDetailService.updateBatchById(orderDetail.values());
                this.updateOrderDeliverState(new ArrayList<OutRmatOrderDetailEntity>(orderDetail.values()), true);
            }
            this.logger.info("\u65b0\u589e\u8ba2\u5355\u53d1\u8d27\u6d41\u6c34-----" + JSONObject.toJSONString(orderDeliveryDetail));
            if (MapUtils.isNotEmpty(orderDeliveryDetail)) {
                this.saveOrUpdateBatch(orderDeliveryDetail.values());
            }
            this.logger.info("\u4fee\u6539\u53d1\u8d27\u72b6\u6001\u8ba2\u5355-----" + JSONObject.toJSONString(orderIds));
        }
    }

    public void delOrderDetail(List<OutRmatDeliveryDetailEntity> detailVOS) {
        ArrayList<OutRmatOrderDetailEntity> orderDetailList = new ArrayList<OutRmatOrderDetailEntity>();
        ArrayList<OutRmatOrderDeliveryEntity> orderDeliveryDetailList = new ArrayList<OutRmatOrderDeliveryEntity>();
        HashSet<Long> orderIds = new HashSet<Long>();
        if (CollectionUtils.isNotEmpty(detailVOS)) {
            for (OutRmatDeliveryDetailEntity outRmatDeliveryDetail : detailVOS) {
                LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
                lambda.eq(OutRmatOrderDeliveryEntity::getDeliveryDetailId, (Object)outRmatDeliveryDetail.getId());
                lambda.eq(OutRmatOrderDeliveryEntity::getDeliveryId, (Object)outRmatDeliveryDetail.getDeliveryId());
                List list = this.list((Wrapper)lambda);
                if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                for (OutRmatOrderDeliveryEntity orderDelivery : list) {
                    OutRmatOrderDetailEntity entity = (OutRmatOrderDetailEntity)((Object)this.outRmatOrderDetailService.getById(orderDelivery.getOrderDetailId()));
                    BigDecimal nums = entity.getReceiveNumsSum() == null ? BigDecimal.ZERO : entity.getReceiveNumsSum();
                    BigDecimal occupyNums = entity.getDeliveredNumsSum() == null ? BigDecimal.ZERO : entity.getDeliveredNumsSum();
                    BigDecimal orderNums = orderDelivery.getDeliveredNumsSum() == null ? BigDecimal.ZERO : orderDelivery.getDeliveredNumsSum();
                    entity.setDeliveredNumsSum(occupyNums.subtract(orderNums));
                    entity.setNotDeliveredNumsSum(nums.subtract(entity.getDeliveredNumsSum()));
                    orderDetailList.add(entity);
                    orderDeliveryDetailList.add(orderDelivery);
                    orderIds.add(entity.getOrderId());
                }
            }
            this.logger.info("\u5220\u9664\u4fee\u6539\u8ba2\u5355-----" + JSONObject.toJSONString(orderDetailList));
            if (CollectionUtils.isNotEmpty(orderDetailList)) {
                this.outRmatOrderDetailService.updateBatchById(orderDetailList);
                this.updateOrderDeliverState(orderDetailList, false);
            }
            this.logger.info("\u5220\u9664\u8ba2\u5355\u53d1\u8d27\u6d41\u6c34-----" + JSONObject.toJSONString(orderDeliveryDetailList));
            if (CollectionUtils.isNotEmpty(orderDeliveryDetailList)) {
                this.removeByIds(orderDeliveryDetailList.stream().map(BaseEntity::getId).collect(Collectors.toList()), true);
            }
        }
    }

    public void updateOrderDeliverState(List<OutRmatOrderDetailEntity> orderDetailList, Boolean type) {
        Set<Long> longs;
        List<OutRmatOrderVO> outRmatOrderNumList;
        Map<Long, List<OutRmatOrderDetailEntity>> collect;
        this.logger.info((type != false ? "\u5360\u7528" : "\u91ca\u653e") + "\u8981\u4fee\u6539\u7684\u8ba2\u5355\u660e\u7ec6\u6570\u636e\u96c6\u5408:{}", (Object)JSONObject.toJSONString(orderDetailList));
        ArrayList<OutRmatOrderVO> orderDeliverState = new ArrayList<OutRmatOrderVO>();
        if (CollectionUtils.isNotEmpty(orderDetailList) && MapUtils.isNotEmpty(collect = orderDetailList.stream().collect(Collectors.groupingBy(item -> item.getOrderId()))) && CollectionUtils.isNotEmpty(outRmatOrderNumList = this.outRmatOrderDetailService.queryOrderNumTotal(new ArrayList<Long>(longs = collect.keySet())))) {
            for (OutRmatOrderVO orderVO : outRmatOrderNumList) {
                BigDecimal receiveNumsSumTotal = orderVO.getReceiveNumsSumTotal();
                BigDecimal notDeliveredNumsSumTotal = orderVO.getNotDeliveredNumsSumTotal();
                if (notDeliveredNumsSumTotal.compareTo(BigDecimal.ZERO) <= 0) {
                    orderVO.setDeliverState("2");
                } else if (receiveNumsSumTotal.compareTo(notDeliveredNumsSumTotal) > 0) {
                    orderVO.setDeliverState("3");
                } else if (receiveNumsSumTotal.compareTo(notDeliveredNumsSumTotal) == 0) {
                    orderVO.setDeliverState("1");
                } else {
                    this.logger.info("\u8ba2\u5355id:{},\u63a5\u6536\u6570\u91cf\u7d2f\u8ba1\uff1a{}\uff0c\u672a\u53d1\u8d27\u6570\u91cf\u7d2f\u8ba1\uff1a{}", new Object[]{orderVO.getId(), receiveNumsSumTotal, notDeliveredNumsSumTotal});
                    throw new BusinessException("\u8ba2\u5355\u53d1\u8d27\u72b6\u6001\u56de\u663e\u5931\u8d25,\u8ba1\u7b97\u53d1\u751f\u9519\u8bef\uff01");
                }
                List<OutRmatOrderDetailEntity> orderDetailEntities1 = collect.get(orderVO.getId());
                orderVO.setOrderDetailList(BeanMapper.mapList(orderDetailEntities1, OutRmatOrderDetailVO.class));
                orderDeliverState.add(orderVO);
            }
        }
        if (CollectionUtils.isNotEmpty(orderDeliverState)) {
            this.logger.info((type != false ? "\u5360\u7528" : "\u91ca\u653e") + "\u8981\u4fee\u6539\u53d1\u8d27\u72b6\u6001\u7684\u8ba2\u5355\u6570\u636e\u96c6\u5408:{}", (Object)JSONObject.toJSONString(orderDeliverState));
            this.outRmatOrderService.updateBatchById(BeanMapper.mapList(orderDeliverState, OutRmatOrderEntity.class));
            this.receiptsApi.orderChangeStatus(orderDeliverState);
        }
    }
}

