package com.ejianc.business.outrmat.restitute.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.rmat.bean.RestituteEntity;
import com.ejianc.business.assist.rmat.consts.RmatCommonConsts;
import com.ejianc.business.assist.rmat.enums.BillPushStatusEnum;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.enums.SupplierSignStatusEnum;
import com.ejianc.business.assist.rmat.service.IMaterialService;
import com.ejianc.business.assist.rmat.service.IRestituteService;
import com.ejianc.business.assist.rmat.service.IRmatFlowService;
import com.ejianc.business.assist.rmat.utils.MaterialConstant;
import com.ejianc.business.assist.rmat.vo.RestituteVO;
import com.ejianc.business.outrmat.delivery.bean.OutRmatDeliveryEntity;
import com.ejianc.business.outrmat.restitute.bean.OutRmatRestituteEntity;
import com.ejianc.business.outrmat.restitute.service.IOutRmatRestituteService;
import com.ejianc.business.outrmat.restitute.vo.OutRmatRestituteVO;
import com.ejianc.business.pro.rmat.api.IReceiptsApi;
import com.ejianc.business.pro.rmat.enums.ReceiptsEnum;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

@Service("outRmatRestitute") 
public class OutRmatRestituteBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IOutRmatRestituteService service;

	@Autowired
	private IMaterialService materialService;

	@Autowired
	private IRmatFlowService flowService;
	@Autowired
	private IReceiptsApi receiptsApi;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OutRmatRestituteEntity entity = service.selectById(billId);
		entity.setSubmitTime(new Date());
		service.saveOrUpdate(entity,false);
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		OutRmatRestituteEntity entity = service.selectById(billId);
		//推送供方验收单
		OutRmatRestituteEntity outRmatRestituteEntity = service.selectById(billId);
		CommonResponse<String> response = receiptsApi.receiptsSync((JSONObject) JSONObject.toJSON(outRmatRestituteEntity), ReceiptsEnum.退赔单.getName());
		if(!response.isSuccess()){
			throw new BusinessException(response.getMsg());
		}
		//单据协同推送
		boolean pushResult = service.pushBillToSupCenter(entity);
		if(pushResult) {
			entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
		} else {
			logger.error("单据-{}id-{}推送供应商服务失败", BillTypeEnum.退赔单.getName(), billId);
			entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		}
		entity.setSubmitTime(new Date());
		// 推送流水生效
//		if(!flowService.insertRestFlow(entity, billTypeCode, RmatCommonConsts.YES)){
//			return CommonResponse.error("审批回调失败，单据推送流水失败！");
//		}
		service.saveOrUpdate(entity, false);
		return CommonResponse.success("审批回调成功！");
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		OutRmatRestituteEntity entity = service.selectById(billId);
		//检测单据是否供应商已签字，
		if(SupplierSignStatusEnum.乙方已签字.getCode().equals(entity.getSupplierSignStatus())) {
			return CommonResponse.error("供应商已签字，无法执行此操作！");
		}
		// 同一个合同只能存在一个自由态或审批中的单据
		materialService.validateContract(entity.getContractId(), null, null, MaterialConstant.弃审);
		// 校验必须大于最大单据日期
		service.validateTime(BeanMapper.map(entity, OutRmatRestituteVO.class), MaterialConstant.弃审);
		// 是否被其他单据引用
		CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(!res.isSuccess()) {//单据未被下游单据引用
			return CommonResponse.error(res.getMsg());
		}
		//将推送至供方的单据作废
		if (BillPushStatusEnum.推送成功.getStatus().equals(entity.getBillPushFlag())) {
			boolean pushResult = service.delPushBill(entity);
			if (!pushResult) {
				return CommonResponse.error("弃审前回调失败，单据作废协同服务失败！");
			} else {
				entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
			}
		}
		entity.setSubmitTime(null);
		service.saveOrUpdate(entity, false);
		// 推送流水未生效
//		if(!flowService.insertRestFlow(entity, billTypeCode, RmatCommonConsts.NO)){
//			return CommonResponse.error("弃审前回调失败，单据推送流水失败！");
//		}
		return CommonResponse.success("弃审前回调成功！");
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OutRmatRestituteEntity outRmatRestituteEntity = service.selectById(billId);
		CommonResponse<String> response = receiptsApi.delReceipts(outRmatRestituteEntity.getId(), ReceiptsEnum.退赔单.getName());
		if(!response.isSuccess()){
			throw new BusinessException(response.getMsg());
		}
		return CommonResponse.success();
	}

}
