package com.ejianc.business.assist.material.service;

import com.ejianc.business.assist.material.bean.MaterialChangeEntity;
import com.ejianc.business.assist.material.vo.MaterialChangeVO;
import com.ejianc.business.assist.material.vo.MaterialContractVO;
import com.ejianc.business.assist.material.vo.record.MaterialChangeRecordVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * 辅料中心采购合同-变更表
 * 
 * @author generator
 * 
 */
public interface IMaterialChangeService extends IBaseService<MaterialChangeEntity> {

    MaterialChangeVO saveOrUpdate(@RequestBody MaterialChangeVO saveOrUpdateVO);

    void deleteByIds(List<MaterialChangeVO> vos);

    MaterialChangeRecordVO queryChangeRecord(Long id);

    MaterialChangeVO queryContractRecordDetail(Long id);
    
    CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState);

    Boolean pushContract(MaterialContractVO vo, String updateLevel);

    Map<String, Object> queryChangeCompare(Long id);
    
}
