package com.ejianc.business.outrmat.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.rmat.service.IBatchPlanService;
import com.ejianc.business.outrmat.contract.enums.StatusTypeEnum;
import com.ejianc.business.outrmat.lose.service.IOutRmatLoseService;
import com.ejianc.business.outrmat.order.service.IOutRmatOrderService;
import com.ejianc.business.outrmat.order.vo.OutRmatOrderVO;
import com.ejianc.business.outrmat.settle.service.IOutRmatSettleService;
import com.ejianc.business.outrmat.start.service.IOutRmatStartService;
import com.ejianc.business.outrmat.stop.service.IOutRmatStopService;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/api/outRmat/")
@Api(value = "辅料中心租出API接口", tags = {"辅料中心租出API接口"})
public class OutRmatApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOutRmatOrderService outRmatOrderService;
    @Autowired
    private IOutRmatSettleService outRmatSettleService;
    @Autowired
    private IOutRmatLoseService outRmatLoseService;
    @Autowired
    private IOutRmatStartService outRmatStartService;
    @Autowired
    private IOutRmatStopService outRmatStopService;

    @ApiOperation("保存推送的订单数据")
    @RequestMapping(value = "/saveOrder", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveOrder(@RequestBody OutRmatOrderVO saveOrUpdateVO) {
        logger.info("订单数据--"+ JSONObject.toJSONString(saveOrUpdateVO));
        outRmatOrderService.saveOrder(saveOrUpdateVO);
        return CommonResponse.success("操作成功！");
    }
    @ApiOperation("删除推送的订单数据")
    @RequestMapping(value = "/deleteOrder", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> deleteOrder(@RequestBody OutRmatOrderVO saveOrUpdateVO) {
        logger.info("订单数据--"+JSONObject.toJSONString(saveOrUpdateVO));
        outRmatOrderService.deleteOrder(saveOrUpdateVO);
        return CommonResponse.success("操作成功！");
    }
    @ApiOperation("订单关闭")
    @RequestMapping(value = "/updateOrderCloseFlag", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateOrderCloseFlag(@RequestBody OutRmatOrderVO saveOrUpdateVO) {
        logger.info("订单数据--"+JSONObject.toJSONString(saveOrUpdateVO));
        String s = outRmatOrderService.updateOrderCloseFlag(saveOrUpdateVO);
        return CommonResponse.success("操作成功！",s);
    }
    @ApiOperation("公共签字接口")
    @RequestMapping(value = "/updateBillSupSignSyncInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateBillSupSignSyncInfo(@RequestBody Map<String,String> map, String type) {
        logger.info("单据名称："+type+"数据信息--"+JSONObject.toJSONString(map));
        String msg = "该单据未定义！";
        switch (StatusTypeEnum.getEnumByName(type)){
            case 辅料中心租出合同结算单: msg = outRmatSettleService.updateBillSupSignSyncInfo(map);break;
            case 租出遗失单: msg = outRmatLoseService.updateBillSupSignSyncInfo(map);break;
            case 租出启用单: msg = outRmatStartService.updateBillSupSignSync(map);break;
            case 租出停用单: msg = outRmatStopService.updateBillSupSignSync(map);break;
        }
        if(StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }
}
