package com.ejianc.business.assist.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.material.bean.MaterialContractDetailEntity;
import com.ejianc.business.assist.material.bean.MaterialContractEntity;
import com.ejianc.business.assist.material.consts.MaterialConstant;
import com.ejianc.business.assist.material.service.IMaterialContractDetailService;
import com.ejianc.business.assist.material.service.IMaterialContractService;
import com.ejianc.business.assist.material.vo.MaterialContractDetailVO;
import com.ejianc.business.assist.material.vo.MaterialContractVO;
import com.ejianc.business.assist.material.vo.record.MaterialSupplementRecordVO;
import com.ejianc.business.assist.rmat.enums.PerformanceStatusEnum;
import com.ejianc.business.assist.rmat.enums.SignatureStatusEnum;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 辅料中心采购合同
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("materialContract")
public class MaterialContractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    
    @Autowired
    private IOrgApi orgApi;
    
    @Autowired
    private IMaterialContractService service;

    @Autowired
    private ITemplateCategoryApi templateCategoryApi;

    @Autowired
    private IMaterialContractDetailService detailService;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialContractVO> saveOrUpdate(@RequestBody MaterialContractVO saveOrUpdateVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(saveOrUpdateVO,authority));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialContractVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！", service.queryDetail(id));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialContractVO> vos) {
        return CommonResponse.success(service.delete(vos));
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", service.pageList(param));
    }
    
    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        CommonResponse<JSONObject> commonResponse = this.queryList(param);
        List<MaterialContractEntity> list = (List<MaterialContractEntity>) commonResponse.getData().get("records");

        List<MaterialContractVO> returnList = BeanMapper.mapList(list, MaterialContractVO.class);
        if (ListUtil.isNotEmpty(returnList)) {
            for (MaterialContractVO vo : returnList) {
                // 合同状态
                if (StringUtils.isBlank(vo.getPerformanceStatus())) {
                    vo.setPerformanceStatus(PerformanceStatusEnum.未签订.getDescription());
                }else {
                    vo.setPerformanceStatus(PerformanceStatusEnum.getEnumByCode(vo.getPerformanceStatus()).getDescription());
                }

                // 签章状态
                if (vo.getSignatureStatus() == null) {
                    vo.setSignatureStatusName(SignatureStatusEnum.未签章.getDescription());
                }else {
                    vo.setSignatureStatusName(SignatureStatusEnum.getEnumByCode(vo.getSignatureStatus()).getDescription());
                }

                // 单据状态名称
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            }
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", returnList);
        ExcelExport.getInstance().export("assistmaterial-contract-export.xlsx", beans, response);
    }

    /**
     * 辅料中心采购合同参照
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refMaterialContractData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialContractVO>> refMaterialContractData(@RequestParam Integer pageNumber
            , @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");
        
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        param.getParams().put("performanceStatus", new Parameter(QueryParam.EQ, PerformanceStatusEnum.履约中.getCode()));
        param.getParams().put("changeStatus", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        
        if(StringUtils.isNotEmpty(condition)){
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
            if (null != conditionMap.get("orgId")) {
                Long orgId = Long.valueOf(conditionMap.get("orgId").toString());
                param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }

        // 设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        if(null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);
        param.setOrderMap(orderMap);
        
        IPage<MaterialContractEntity> page = service.queryPage(param,false);
        IPage<MaterialContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialContractVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 辅料中心采购合同分类参照
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/amContractCategoryRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MaterialContractDetailVO>> arriContractCategoryRef(@RequestParam Long contractId) {
        QueryParam param = new QueryParam();

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("row_type", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
        param.getOrderMap().put("createTime", "desc");

        //  查询材料明细
        List<MaterialContractDetailEntity> detailList = detailService.queryList(param, false);
        List<MaterialContractDetailVO> refVOList = BeanMapper.mapList(detailList, MaterialContractDetailVO.class);

        return CommonResponse.success("查询参照数据成功！", refVOList);
    }


    /**
     * 根据合同Id查询合同文件管理信息
     *
     * @param contractId 合同Id
     * @return
     */
    @GetMapping(value = "/getContractFileMgrInfo")
    @ResponseBody
    public CommonResponse<JSONObject> getContractFileMgrInfo(@RequestParam(value = "contractId") Long contractId) {
        JSONObject resp = new JSONObject();
        CommonResponse<BillTypeVO> billTypeResp = billTypeApi.getByRefCode(MaterialConstant.CONTRACT_REFCODE);
        if(!billTypeResp.isSuccess()) {
            logger.error("根据refCode-{}查询对应元数据失败, 原因：{}", MaterialConstant.CONTRACT_REFCODE, billTypeResp.getMsg());
            return CommonResponse.error("查询元数据信息失败");
        }

        MaterialContractEntity contractEntity = service.selectById(contractId);
        CommonResponse<TemplateCategoryVO> categoryResp = templateCategoryApi.queryTmplCategoryById(contractEntity.getContractCategoryId());
        if(!categoryResp.isSuccess()) {
            logger.error("根据合同类别I的-{}查询对应合同类别信息失败, 原因：{}", contractEntity.getContractCategoryId(), categoryResp.getMsg());
            return CommonResponse.error("查询合同类别信息失败");
        }
        TemplateCategoryVO category = categoryResp.getData();
        resp.put("contactId", contractEntity.getId());
        resp.put("contractBillTypeCode", billTypeResp.getData().getBillCode());
        resp.put("contractCategoryId", category.getId());
        resp.put("boBillType", category.getBillTypeCode());

        return CommonResponse.success("查询成功！", resp);
    }

    /**
     * 合同补充协议历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/querySupplementRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialSupplementRecordVO> querySupplementRecord(@RequestParam Long id) {
        MaterialSupplementRecordVO vo = service.querySupplementRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * 辅料中心租入合同分类参照
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/materialContractCategoryRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MaterialContractDetailVO>> materialContractCategoryRef(@RequestParam Long contractId) {
        QueryParam param = new QueryParam();

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("row_type", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
        param.getOrderMap().put("createTime", "desc");

        List<MaterialContractDetailEntity> list = detailService.queryList(param);
        List<MaterialContractDetailVO> returnList = BeanMapper.mapList(list, MaterialContractDetailVO.class);
        
        return CommonResponse.success("查询参照数据成功！", returnList);
    }

    /**
     *  校验同一个合同只能存在一个自由态或审批中的单据（补充协议、变更单、冻结单、解除单）
     * @param contractId    合同主键
     * @param billType  待校验单据类型
     * @param billId    待校验单据主键
     * @return
     */
    @RequestMapping(value = "/validateContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> validateContract(@RequestParam("contractId") Long contractId, @RequestParam(value = "billType", required = false) String billType
            , @RequestParam(value = "billId", required = false) Long billId, @RequestParam(value = "type", required = false) String type) {
        String msg = service.validateContract(contractId, billType, billId, type);
        return CommonResponse.success("校验成功！", msg);
    }
    
}
