package com.ejianc.business.assist.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.rmat.vo.ConvertIdVO;
import com.ejianc.business.assist.rmat.vo.ConvertRequest;
import com.ejianc.business.assist.rmat.vo.ResidualVO;
import com.ejianc.business.assist.rmat.vo.ConvertVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.assist.rmat.mapper.ConvertMapper;
import com.ejianc.business.assist.rmat.bean.ConvertEntity;
import com.ejianc.business.assist.rmat.service.IConvertService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 转换系数设置
 *
 * @author generator
 */
@Service("convertService")
public class ConvertServiceImpl extends BaseServiceImpl<ConvertMapper, ConvertEntity> implements IConvertService {

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public Boolean saveOrUpdate(ConvertVO saveOrUpdateVO) {
        Long orgId = InvocationInfoProxy.getOrgId();
        Long tenantid = InvocationInfoProxy.getTenantid();
        saveOrUpdateVO.setTenantId(tenantid);
        String orgCode = sessionManager.getUserContext().getOrgCode();
        String orgName = sessionManager.getUserContext().getOrgName();
        // 校验启用,同一组织下
        if (saveOrUpdateVO.getConvertStatus() == 1) {
            Integer rowType = saveOrUpdateVO.getRowType();
            LambdaQueryWrapper<ConvertEntity> lambd = new LambdaQueryWrapper<>();
            lambd.eq(ConvertEntity::getConvertStatus, 1);
            lambd.eq(ConvertEntity::getRowType, rowType);
            lambd.eq(ConvertEntity::getUnitId, saveOrUpdateVO.getUnitId());
            lambd.eq(ConvertEntity::getUnitMId, saveOrUpdateVO.getUnitMId());
            if (rowType == 1) {
                lambd.eq(ConvertEntity::getMaterialTypeId, saveOrUpdateVO.getMaterialTypeId());
            } else {
                lambd.eq(ConvertEntity::getMaterialId, saveOrUpdateVO.getMaterialId());
            }
            if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0) { //修改
                lambd.eq(ConvertEntity::getOrgId, saveOrUpdateVO.getOrgId());
                lambd.ne(ConvertEntity::getId, saveOrUpdateVO.getId());
            } else {
                lambd.eq(ConvertEntity::getOrgId, orgId);
            }
            List<ConvertEntity> list = super.list(lambd);
            if (CollectionUtils.isNotEmpty(list)) {
                if (rowType == 1) {
                    throw new BusinessException(saveOrUpdateVO.getMaterialTypeName() + "已经有启用的重量转换系数，请变更状态后，提交信息。");
                } else {
                    throw new BusinessException(saveOrUpdateVO.getMaterialName() + "已经有启用的重量转换系数，请变更状态后，提交信息。");
                }

            }
        }
        if (saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() <= 0) { //新增
            saveOrUpdateVO.setOrgId(orgId);
            saveOrUpdateVO.setOrgCode(orgCode);
            saveOrUpdateVO.setOrgName(orgName);
        }
        ConvertEntity entity = BeanMapper.map(saveOrUpdateVO, ConvertEntity.class);
        return super.saveOrUpdate(entity, false);
    }

    @Override
    public String turnSwitch(ConvertVO vo) {
        if (vo.getConvertStatus() == 0) {
            LambdaUpdateWrapper<ConvertEntity> lambd = new LambdaUpdateWrapper<>();
            lambd.set(ConvertEntity::getConvertStatus, 0);
            lambd.eq(ConvertEntity::getId, vo.getId());
            super.update(lambd);
            return "停用成功！";
        } else {
            // 先停用已启用的
            Integer rowType = vo.getRowType();
            LambdaUpdateWrapper<ConvertEntity> lambd = new LambdaUpdateWrapper<>();
            lambd.set(ConvertEntity::getConvertStatus, 0);
            lambd.eq(ConvertEntity::getConvertStatus, 1);
            lambd.eq(ConvertEntity::getOrgId, vo.getOrgId());
            lambd.eq(ConvertEntity::getUnitId, vo.getUnitId());
            lambd.eq(ConvertEntity::getUnitMId, vo.getUnitMId());
            lambd.eq(ConvertEntity::getRowType, rowType);
            if (rowType == 1) {
                lambd.eq(ConvertEntity::getMaterialTypeId, vo.getMaterialTypeId());
            } else {
                lambd.eq(ConvertEntity::getMaterialId, vo.getMaterialId());
            }
            lambd.ne(ConvertEntity::getId, vo.getId());
            super.update(lambd);

            // 启用
            LambdaUpdateWrapper<ConvertEntity> lambdUpdate = new LambdaUpdateWrapper<>();
            lambdUpdate.set(ConvertEntity::getConvertStatus, 1);
            lambdUpdate.eq(ConvertEntity::getId, vo.getId());
            super.update(lambdUpdate);
            return "启用成功！";
        }
    }

    @Override
    public Map<String, ConvertEntity> getResidualRate(ConvertRequest vo) {
        Long orgId = vo.getOrgId();
        List<ConvertIdVO> convertIds = vo.getConvertIds();
        List<String> reskey = new ArrayList<>();
        if (CollectionUtils.isEmpty(convertIds)) {
            return new HashMap<>();
        } else {
            for (ConvertIdVO cvo : convertIds) {
                reskey.add(String.valueOf(cvo.getMaterialId()) + "," + String.valueOf(cvo.getUnitMId()) + "," + String.valueOf(cvo.getUnitId()));
            }
        }


        Map<String, ConvertEntity> rateMap = getResidualRateByOrgId(orgId, reskey);
        return rateMap;
    }

    private Map<String, ConvertEntity> getResidualRateByOrgId(Long orgId, List<String> reskey) {

        LambdaQueryWrapper<ConvertEntity> lambd = new LambdaQueryWrapper<>();
        lambd.eq(ConvertEntity::getOrgId, orgId);
        lambd.eq(ConvertEntity::getConvertStatus, 1);
        List<ConvertEntity> list = super.list(lambd);// 包含材料

        Map<String, ConvertEntity> map = new HashMap<>();

        for (ConvertEntity entity : list) {
            if (entity.getRowType() == 2 && reskey.size() > 0) {
                String key = String.valueOf(entity.getMaterialId()) + "," + String.valueOf(entity.getUnitMId()) + "," + String.valueOf(entity.getUnitId());
                if (reskey.contains(key)) {
                    map.put(key, entity);
                    reskey.remove(key);
                }
            }
        }
        if (reskey.size() == 0) {
            // 已经全部查出
            return map;
        } else {
            // 没有设置分类，查上级组织
            OrgVO parentsVo = orgApi.detailById(orgId).getData();
            if (parentsVo.getParentId() != null && parentsVo.getParentId() > 0) {
                Map<String, ConvertEntity> resMap = getResidualRateByOrgId(parentsVo.getParentId(), reskey);
                map.putAll(resMap);
            }
            return map;
        }
    }

    private Map<Long, ConvertEntity> getResidualRateByCategory(List<ConvertEntity> typeList, Map<Long, List<MaterialCategoryVO>> dataMap) {
        Map<Long, ConvertEntity> resMap = new HashMap<>();
        Map<Long, ConvertEntity> typeMap = new HashMap<>();
        for (ConvertEntity entity : typeList) {
            typeMap.put(entity.getMaterialTypeId(), entity);
        }
        for (Long materialId : dataMap.keySet()) {
            List<MaterialCategoryVO> materialCategoryVOS = dataMap.get(materialId);
            for (MaterialCategoryVO vo : materialCategoryVOS) {
                if (typeMap.containsKey(vo.getId())) {
                    resMap.put(materialId, typeMap.get(vo.getId()));
                    break;
                }
            }
        }
        return resMap;
    }
}
